/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.Client;
import com.hazelcast.core.ClientListener;
import com.hazelcast.core.ClientService;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.util.ConcurrentHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class ClientServiceImpl
implements ClientService {
    private final Set<Client> clients = new ConcurrentHashSet<Client>();
    private final List<ClientListener> listeners = new CopyOnWriteArrayList<ClientListener>();
    private final ConcurrentMapManager concurrentMapManager;

    public ClientServiceImpl(ConcurrentMapManager concurrentMapManager) {
        this.concurrentMapManager = concurrentMapManager;
    }

    @Override
    public Collection<Client> getConnectedClients() {
        return this.clients;
    }

    @Override
    public void addClientListener(ClientListener clientListener) {
        this.listeners.add(clientListener);
    }

    @Override
    public void removeClientListener(ClientListener clientListener) {
        this.listeners.remove(clientListener);
    }

    private void doFireClientEvent(final Client client, final boolean connected) {
        if (client == null) {
            throw new IllegalArgumentException("Client is null.");
        }
        for (final ClientListener clientListener : this.listeners) {
            this.concurrentMapManager.node.executorManager.executeNow(new Runnable(){

                @Override
                public void run() {
                    if (connected) {
                        clientListener.clientConnected(client);
                    } else {
                        clientListener.clientDisconnected(client);
                    }
                }
            });
        }
    }

    void add(Client client) {
        this.clients.add(client);
        this.doFireClientEvent(client, true);
    }

    void remove(Client client) {
        this.clients.remove(client);
        this.doFireClientEvent(client, false);
    }
}

