/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.Call;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.Packet;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.client.impl.EntryListenerManager;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.core.ItemListener;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.DataAwareEntryEvent;
import com.hazelcast.impl.DataAwareItemEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ItemListenerManager {
    final Map<ItemListener, EntryListener> itemListener2EntryListener = new ConcurrentHashMap<ItemListener, EntryListener>();
    private final EntryListenerManager entryListenerManager;

    public ItemListenerManager(EntryListenerManager entryListenerManager) {
        this.entryListenerManager = entryListenerManager;
    }

    public synchronized <E, V> void registerListener(final String name, final ItemListener<V> itemListener, boolean includeValue) {
        EntryAdapter e = new EntryAdapter<E, V>(){

            @Override
            public void entryAdded(EntryEvent<E, V> event) {
                DataAwareEntryEvent dataAwareEntryEvent = (DataAwareEntryEvent)event;
                itemListener.itemAdded(new DataAwareItemEvent(name, ItemEventType.ADDED, dataAwareEntryEvent.getNewValueData()));
            }

            @Override
            public void entryRemoved(EntryEvent<E, V> event) {
                DataAwareEntryEvent dataAwareEntryEvent = (DataAwareEntryEvent)event;
                itemListener.itemRemoved(new DataAwareItemEvent(name, ItemEventType.REMOVED, dataAwareEntryEvent.getNewValueData()));
            }
        };
        this.entryListenerManager.registerListener(name, null, includeValue, e);
        this.itemListener2EntryListener.put(itemListener, e);
    }

    public synchronized void removeListener(String name, ItemListener itemListener) {
        EntryListener entryListener = this.itemListener2EntryListener.remove(itemListener);
        this.entryListenerManager.removeListener(name, null, entryListener);
    }

    public Call createNewAddListenerCall(ProxyHelper proxyHelper, boolean includeValue) {
        Packet request = proxyHelper.createRequestPacket(ClusterOperation.ADD_LISTENER, null, null);
        request.setLongValue(includeValue ? 1L : 0L);
        return proxyHelper.createCall(request);
    }

    public Collection<Call> calls(HazelcastClient client) {
        return Collections.emptyList();
    }
}

