/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.Clock;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class LifecycleServiceClientImpl
implements LifecycleService {
    static final ILogger logger = Logger.getLogger(LifecycleServiceClientImpl.class.getName());
    final AtomicBoolean paused = new AtomicBoolean(false);
    final AtomicBoolean running = new AtomicBoolean(true);
    final CopyOnWriteArrayList<LifecycleListener> lsLifecycleListeners = new CopyOnWriteArrayList();
    final Object lifecycleLock = new Object();
    final HazelcastClient hazelcastClient;
    final ExecutorService es = Executors.newSingleThreadExecutor();

    public LifecycleServiceClientImpl(HazelcastClient hazelcastClient) {
        this.hazelcastClient = hazelcastClient;
        if (hazelcastClient.getClientConfig() != null) {
            LinkedList<LifecycleListener> listeners = new LinkedList<LifecycleListener>();
            for (Object listener : hazelcastClient.getClientConfig().getListeners()) {
                if (!(listener instanceof LifecycleListener)) continue;
                listeners.add((LifecycleListener)listener);
            }
            this.lsLifecycleListeners.addAll(listeners);
        }
    }

    @Override
    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lsLifecycleListeners.add(lifecycleListener);
    }

    @Override
    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lsLifecycleListeners.remove(lifecycleListener);
    }

    public void fireLifecycleEvent(final LifecycleEvent.LifecycleState lifecycleState) {
        this.callAsync(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                LifecycleServiceClientImpl.this.fireLifecycleEvent(new LifecycleEvent(lifecycleState));
                return null;
            }
        });
    }

    private void callAsync(Callable callable) {
        this.es.submit(callable);
    }

    public void fireLifecycleEvent(LifecycleEvent event) {
        logger.log(Level.INFO, "HazelcastClient is " + (Object)((Object)event.getState()));
        for (LifecycleListener lifecycleListener : this.lsLifecycleListeners) {
            lifecycleListener.stateChanged(event);
        }
    }

    @Override
    public boolean resume() {
        Callable<Boolean> callable = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() {
                Object object = LifecycleServiceClientImpl.this.lifecycleLock;
                synchronized (object) {
                    if (!LifecycleServiceClientImpl.this.paused.get()) {
                        return false;
                    }
                    LifecycleServiceClientImpl.this.fireLifecycleEvent(LifecycleEvent.LifecycleState.RESUMING);
                    LifecycleServiceClientImpl.this.paused.set(false);
                    LifecycleServiceClientImpl.this.fireLifecycleEvent(LifecycleEvent.LifecycleState.RESUMED);
                    return true;
                }
            }
        };
        return HazelcastClient.callAsyncAndWait(callable);
    }

    @Override
    public boolean pause() {
        Callable<Boolean> callable = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() {
                Object object = LifecycleServiceClientImpl.this.lifecycleLock;
                synchronized (object) {
                    if (LifecycleServiceClientImpl.this.paused.get()) {
                        return false;
                    }
                    LifecycleServiceClientImpl.this.fireLifecycleEvent(LifecycleEvent.LifecycleState.PAUSING);
                    LifecycleServiceClientImpl.this.paused.set(true);
                    LifecycleServiceClientImpl.this.fireLifecycleEvent(LifecycleEvent.LifecycleState.PAUSED);
                    return true;
                }
            }
        };
        return HazelcastClient.callAsyncAndWait(callable);
    }

    @Override
    public void shutdown() {
        Callable<Boolean> callable = new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() {
                Object object = LifecycleServiceClientImpl.this.lifecycleLock;
                synchronized (object) {
                    long begin = Clock.currentTimeMillis();
                    LifecycleServiceClientImpl.this.fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTTING_DOWN);
                    LifecycleServiceClientImpl.this.hazelcastClient.doShutdown();
                    LifecycleServiceClientImpl.this.running.set(false);
                    long time = Clock.currentTimeMillis() - begin;
                    logger.log(Level.FINE, "HazelcastClient shutdown completed in " + time + " ms.");
                    LifecycleServiceClientImpl.this.fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTDOWN);
                    return true;
                }
            }
        };
        HazelcastClient.callAsyncAndWait(callable);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.es.shutdown();
    }

    void destroy() {
        this.es.shutdownNow();
    }

    @Override
    public void kill() {
        this.shutdown();
    }

    @Override
    public void restart() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }
}

