/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.IOUtil;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.client.impl.InstanceListenerManager;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.Instance;
import com.hazelcast.core.InstanceListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.Keys;
import com.hazelcast.nio.Data;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class ClusterClientProxy
implements Cluster {
    final ProxyHelper proxyHelper;
    private final HazelcastClient client;

    public ClusterClientProxy(HazelcastClient client) {
        this.client = client;
        this.proxyHelper = new ProxyHelper("", client);
    }

    public Collection<Instance> getInstances() {
        Keys instances = (Keys)this.proxyHelper.doOp(ClusterOperation.GET_INSTANCES, null, null);
        ArrayList<Instance> list = new ArrayList<Instance>();
        if (instances != null) {
            for (Data data : instances) {
                Object o = IOUtil.toObject(data.buffer);
                if (o instanceof FactoryImpl.ProxyKey) {
                    FactoryImpl.ProxyKey proxyKey = (FactoryImpl.ProxyKey)o;
                    list.add((Instance)this.client.getClientProxy(proxyKey.getKey()));
                    continue;
                }
                list.add((Instance)this.client.getClientProxy(o));
            }
        }
        return list;
    }

    @Override
    public void addMembershipListener(MembershipListener listener) {
        ProxyHelper.check(listener);
        this.client.getListenerManager().getMembershipListenerManager().registerListener(listener);
    }

    @Override
    public void removeMembershipListener(MembershipListener listener) {
        this.client.getListenerManager().getMembershipListenerManager().removeListener(listener);
    }

    @Override
    public Set<Member> getMembers() {
        Keys cw = (Keys)this.proxyHelper.doOp(ClusterOperation.GET_MEMBERS, null, null);
        Collection<Data> datas = cw.getKeys();
        LinkedHashSet<Member> set = new LinkedHashSet<Member>();
        for (Data d : datas) {
            set.add((Member)IOUtil.toObject(d.buffer));
        }
        return set;
    }

    @Override
    public Member getLocalMember() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getClusterTime() {
        return (Long)this.proxyHelper.doOp(ClusterOperation.GET_CLUSTER_TIME, null, null);
    }

    public void addInstanceListener(InstanceListener listener) {
        ProxyHelper.check(listener);
        if (this.instanceListenerManager().noListenerRegistered()) {
            Call c = this.instanceListenerManager().createNewAddListenerCall(this.proxyHelper);
            this.proxyHelper.doCall(c);
        }
        this.instanceListenerManager().registerListener(listener);
    }

    public void removeInstanceListener(InstanceListener instanceListener) {
        ProxyHelper.check(instanceListener);
        this.instanceListenerManager().removeListener(instanceListener);
    }

    private InstanceListenerManager instanceListenerManager() {
        return this.client.getListenerManager().getInstanceListenerManager();
    }

    public String toString() {
        Set<Member> members = this.getMembers();
        StringBuffer sb = new StringBuffer("Cluster [");
        if (members != null) {
            sb.append(members.size());
            sb.append("] {");
            for (Member member : members) {
                sb.append("\n\t").append(member);
            }
        }
        sb.append("\n}\n");
        return sb.toString();
    }
}

