/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.ascii.rest;

import com.hazelcast.impl.Node;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.ascii.TextCommandService;
import com.hazelcast.impl.ascii.rest.HttpCommand;
import com.hazelcast.impl.ascii.rest.HttpCommandProcessor;
import com.hazelcast.impl.ascii.rest.HttpGetCommand;
import com.hazelcast.impl.ascii.rest.RestValue;
import com.hazelcast.nio.ConnectionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpGetCommandProcessor
extends HttpCommandProcessor<HttpGetCommand> {
    public HttpGetCommandProcessor(TextCommandService textCommandService) {
        super(textCommandService);
    }

    @Override
    public void handle(HttpGetCommand command) {
        String uri = command.getURI();
        if (uri.startsWith("/hazelcast/rest/maps/")) {
            int indexEnd = uri.indexOf(47, "/hazelcast/rest/maps/".length());
            String mapName = uri.substring("/hazelcast/rest/maps/".length(), indexEnd);
            String key = uri.substring(indexEnd + 1);
            Object value = this.textCommandService.get(mapName, key);
            this.prepareResponse(command, value);
        } else if (uri.startsWith("/hazelcast/rest/queues/")) {
            String queueName = uri.endsWith("/") ? uri.substring("/hazelcast/rest/queues/".length(), uri.length() - 1) : uri.substring("/hazelcast/rest/queues/".length());
            Object value = this.textCommandService.poll(queueName);
            this.prepareResponse(command, value);
        } else if (uri.startsWith("/hazelcast/rest/cluster")) {
            Node node = this.textCommandService.getNode();
            StringBuilder res = new StringBuilder(node.getClusterImpl().toString());
            res.append("\n");
            ConnectionManager connectionManager = node.getConnectionManager();
            res.append("ConnectionCount: ").append(connectionManager.getCurrentClientConnections());
            res.append("\n");
            res.append("AllConnectionCount: ").append(connectionManager.getAllTextConnections());
            res.append("\n");
            command.setResponse(null, res.toString().getBytes());
        } else if (uri.startsWith("/hazelcast/rest/dump")) {
            String fileName = this.textCommandService.getNode().getSystemLogService().dump();
            command.setResponse(HttpCommand.CONTENT_TYPE_PLAIN_TEXT, fileName.toString().getBytes());
        } else {
            command.send400();
        }
        this.textCommandService.sendResponse(command);
    }

    @Override
    public void handleRejection(HttpGetCommand command) {
        this.handle(command);
    }

    private void prepareResponse(HttpGetCommand command, Object value) {
        if (value == null) {
            command.send204();
        } else if (value instanceof byte[]) {
            command.setResponse(HttpCommand.CONTENT_TYPE_BINARY, (byte[])value);
        } else if (value instanceof RestValue) {
            RestValue restValue = (RestValue)value;
            command.setResponse(restValue.getContentType(), restValue.getValue());
        } else if (value instanceof String) {
            command.setResponse(HttpCommand.CONTENT_TYPE_PLAIN_TEXT, ((String)value).getBytes());
        } else {
            command.setResponse(HttpCommand.CONTENT_TYPE_BINARY, ThreadContext.get().toByteArray(value));
        }
    }
}

