/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.JoinInfo;
import com.hazelcast.impl.AddressPicker;
import com.hazelcast.impl.Joiner;
import com.hazelcast.impl.MulticastJoiner;
import com.hazelcast.impl.MulticastListener;
import com.hazelcast.impl.Node;
import com.hazelcast.nio.Address;
import java.util.Set;

public class NodeMulticastListener
implements MulticastListener {
    final Node node;
    final Set<String> trustedInterfaces;

    public NodeMulticastListener(Node node) {
        this.node = node;
        this.trustedInterfaces = node.getConfig().getNetworkConfig().getJoin().getMulticastConfig().getTrustedInterfaces();
    }

    public void onMessage(Object msg) {
        if (msg != null && msg instanceof JoinInfo) {
            JoinInfo joinInfo = (JoinInfo)msg;
            if (this.node.address != null && !this.node.address.equals(joinInfo.address)) {
                boolean validJoinRequest;
                try {
                    validJoinRequest = this.node.validateJoinRequest(joinInfo);
                }
                catch (Exception e) {
                    validJoinRequest = false;
                }
                if (validJoinRequest) {
                    Joiner joiner;
                    if (this.node.isMaster() && this.node.isActive() && this.node.joined()) {
                        if (joinInfo.isRequest()) {
                            this.node.multicastService.send(joinInfo.copy(false, this.node.address, this.node.getClusterImpl().getMembers().size()));
                        }
                    } else if (!this.node.joined() && !joinInfo.isRequest()) {
                        if (this.node.masterAddress == null) {
                            String masterHost = joinInfo.address.getHost();
                            if (this.trustedInterfaces.isEmpty() || AddressPicker.matchAddress(masterHost, this.trustedInterfaces)) {
                                this.node.masterAddress = new Address(joinInfo.address);
                            }
                        }
                    } else if (joinInfo.isRequest() && (joiner = this.node.getJoiner()) instanceof MulticastJoiner) {
                        MulticastJoiner mjoiner = (MulticastJoiner)joiner;
                        mjoiner.onReceivedJoinInfo(joinInfo);
                    }
                }
            }
        }
    }
}

