/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class Address
implements DataSerializable {
    private static final long serialVersionUID = -7626390274220424603L;
    private String host = null;
    private byte[] ip;
    private int port = -1;
    private transient InetSocketAddress inetSocketAddress;
    private int hash = -1;
    private boolean thisAddress = false;

    public Address() {
        this.ip = new byte[4];
    }

    public Address(InetSocketAddress inetSocketAddress) {
        this.ip = inetSocketAddress.getAddress().getAddress();
        this.port = inetSocketAddress.getPort();
        this.inetSocketAddress = inetSocketAddress;
    }

    public Address(InetAddress inetAddress, int port) {
        this(new InetSocketAddress(inetAddress, port));
    }

    public Address(Address address) {
        this.ip = new byte[4];
        System.arraycopy(address.getIP(), 0, this.ip, 0, 4);
        this.port = address.getPort();
    }

    public Address hardCopy() {
        return new Address(this);
    }

    public Address(String address, int port) throws UnknownHostException {
        this.port = port;
        this.ip = InetAddress.getByName(address).getAddress();
    }

    public boolean isThisAddress() {
        return this.thisAddress;
    }

    public void setThisAddress(boolean thisAddress) {
        this.thisAddress = thisAddress;
    }

    public Address(byte[] ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public static String toString(byte[] ip) {
        return (ip[0] & 0xFF) + "." + (ip[1] & 0xFF) + "." + (ip[2] & 0xFF) + "." + (ip[3] & 0xFF);
    }

    private void setHost() {
        this.host = Address.toString(this.ip);
    }

    public void writeData(DataOutput out) throws IOException {
        out.write(this.ip);
        out.writeInt(this.port);
    }

    public void readData(DataInput in) throws IOException {
        in.readFully(this.ip);
        this.port = in.readInt();
    }

    public void readObject(ByteBuffer buffer) {
        buffer.get(this.ip);
        this.port = buffer.getInt();
    }

    public void writeObject(ByteBuffer buffer) {
        buffer.put(this.ip);
        buffer.putInt(this.port);
    }

    public String getHost() {
        if (this.host == null) {
            this.setHost();
        }
        return this.host;
    }

    public String toString() {
        if (this.host == null) {
            this.setHost();
        }
        return "Address[" + this.host + ":" + this.port + "]";
    }

    public int getPort() {
        return this.port;
    }

    public String addressToString() {
        if (this.host == null) {
            this.setHost();
        }
        return this.host;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        return this.getInetSocketAddress().getAddress();
    }

    public InetSocketAddress getInetSocketAddress() throws UnknownHostException {
        if (this.host == null) {
            this.setHost();
        }
        if (this.inetSocketAddress == null) {
            this.inetSocketAddress = new InetSocketAddress(InetAddress.getByName(this.host), this.port);
        }
        return this.inetSocketAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address address = (Address)o;
        return this.hashCode() == address.hashCode() && this.port == address.port && Arrays.equals(this.ip, address.ip);
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.setHashCode();
        }
        return this.hash;
    }

    private void setHashCode() {
        this.hash = this.hash(this.ip) * 29 + this.port;
    }

    private int hash(byte[] bytes) {
        int hash = 0;
        for (byte b : bytes) {
            hash = hash * 29 + b;
        }
        return hash;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public byte[] getIP() {
        return this.ip;
    }
}

