/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.SemaphoreConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.merge.AddNewEntryMergePolicy;
import com.hazelcast.merge.HigherHitsMergePolicy;
import com.hazelcast.merge.LatestUpdateMergePolicy;
import com.hazelcast.merge.PassThroughMergePolicy;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.util.ByteUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config
implements DataSerializable {
    public static final int DEFAULT_PORT = 5701;
    private String xmlConfig = null;
    private String instanceName = null;
    private GroupConfig groupConfig = new GroupConfig();
    private int port = 5701;
    private boolean checkCompatibility = true;
    private boolean reuseAddress = false;
    private boolean portAutoIncrement = true;
    private ExecutorConfig executorConfig = new ExecutorConfig();
    private Map<String, ExecutorConfig> mapExecutors = new ConcurrentHashMap<String, ExecutorConfig>();
    private Map<String, TopicConfig> mapTopicConfigs = new ConcurrentHashMap<String, TopicConfig>();
    private Map<String, QueueConfig> mapQueueConfigs = new ConcurrentHashMap<String, QueueConfig>();
    private Map<String, MapConfig> mapConfigs = new ConcurrentHashMap<String, MapConfig>();
    private Map<String, MultiMapConfig> multiMapConfigs = new ConcurrentHashMap<String, MultiMapConfig>();
    private Map<String, SemaphoreConfig> mapSemaphoreConfigs = new ConcurrentHashMap<String, SemaphoreConfig>();
    private URL configurationUrl;
    private File configurationFile;
    private NetworkConfig networkConfig = new NetworkConfig();
    private boolean liteMember = false;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private Properties properties = new Properties();
    private Map<String, MergePolicyConfig> mapMergePolicyConfigs = new ConcurrentHashMap<String, MergePolicyConfig>();
    private Map<String, WanReplicationConfig> mapWanReplicationConfigs = new ConcurrentHashMap<String, WanReplicationConfig>();
    private SecurityConfig securityConfig = new SecurityConfig();
    private List<ListenerConfig> listenerConfigs;
    private PartitionGroupConfig partitionGroupConfig = new PartitionGroupConfig();

    public Config() {
        String os;
        String liteMemberProp = System.getProperty("hazelcast.super.client");
        if (liteMemberProp == null) {
            liteMemberProp = System.getProperty("hazelcast.lite.member");
        }
        if ("true".equalsIgnoreCase(liteMemberProp)) {
            this.liteMember = true;
        }
        this.reuseAddress = (os = System.getProperty("os.name").toLowerCase()).indexOf("win") == -1;
        this.addMergePolicyConfig(new MergePolicyConfig("hz.ADD_NEW_ENTRY", new AddNewEntryMergePolicy()));
        this.addMergePolicyConfig(new MergePolicyConfig("hz.HIGHER_HITS", new HigherHitsMergePolicy()));
        this.addMergePolicyConfig(new MergePolicyConfig("hz.LATEST_UPDATE", new LatestUpdateMergePolicy()));
        this.addMergePolicyConfig(new MergePolicyConfig("hz.PASS_THROUGH", new PassThroughMergePolicy()));
    }

    public void addMergePolicyConfig(MergePolicyConfig mergePolicyConfig) {
        this.mapMergePolicyConfigs.put(mergePolicyConfig.getName(), mergePolicyConfig);
    }

    public MergePolicyConfig getMergePolicyConfig(String name) {
        return this.mapMergePolicyConfigs.get(name);
    }

    public Map<String, MergePolicyConfig> getMergePolicyConfigs() {
        return this.mapMergePolicyConfigs;
    }

    public void setMergePolicyConfigs(Map<String, MergePolicyConfig> mapMergePolicyConfigs) {
        this.mapMergePolicyConfigs = mapMergePolicyConfigs;
    }

    public WanReplicationConfig getWanReplicationConfig(String name) {
        return this.mapWanReplicationConfigs.get(name);
    }

    public void addWanReplicationConfig(WanReplicationConfig wanReplicationConfig) {
        this.mapWanReplicationConfigs.put(wanReplicationConfig.getName(), wanReplicationConfig);
    }

    public Map<String, WanReplicationConfig> getWanReplicationConfigs() {
        return this.mapWanReplicationConfigs;
    }

    public Config setWanReplicationConfigs(Map<String, WanReplicationConfig> wanReplicationConfigs) {
        this.mapWanReplicationConfigs = wanReplicationConfigs;
        for (Map.Entry<String, WanReplicationConfig> entry : this.mapWanReplicationConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Config setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public Config setProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public QueueConfig findMatchingQueueConfig(String name) {
        QueueConfig config = Config.lookupByPattern(this.mapQueueConfigs, name);
        if (config != null) {
            return config;
        }
        return this.getQueueConfig("default");
    }

    public QueueConfig getQueueConfig(String name) {
        QueueConfig config = Config.lookupByPattern(this.mapQueueConfigs, name);
        if (config != null) {
            return config;
        }
        QueueConfig defConfig = this.mapQueueConfigs.get("default");
        if (defConfig == null) {
            defConfig = new QueueConfig();
            defConfig.setName("default");
            this.addQueueConfig(defConfig);
        }
        config = new QueueConfig(defConfig);
        config.setName(name);
        this.addQueueConfig(config);
        return config;
    }

    public MapConfig getMapConfig(String name) {
        MapConfig config = Config.lookupByPattern(this.mapConfigs, name);
        if (config != null) {
            return config;
        }
        MapConfig defConfig = this.mapConfigs.get("default");
        if (defConfig == null) {
            defConfig = new MapConfig();
            defConfig.setName("default");
            this.addMapConfig(defConfig);
        }
        config = new MapConfig(defConfig);
        config.setName(name);
        this.addMapConfig(config);
        return config;
    }

    public MultiMapConfig getMultiMapConfig(String name) {
        MultiMapConfig config = Config.lookupByPattern(this.multiMapConfigs, name);
        if (config != null) {
            return config;
        }
        MultiMapConfig defConfig = this.multiMapConfigs.get("default");
        if (defConfig == null) {
            defConfig = new MultiMapConfig();
            defConfig.setName("default");
            this.addMultiMapConfig(defConfig);
        }
        config = new MultiMapConfig(defConfig);
        config.setName(name);
        this.addMultiMapConfig(config);
        return config;
    }

    public MapConfig findMatchingMapConfig(String name) {
        MapConfig config = Config.lookupByPattern(this.mapConfigs, name);
        if (config != null) {
            return config;
        }
        return this.getMapConfig("default");
    }

    public TopicConfig findMatchingTopicConfig(String name) {
        TopicConfig config = Config.lookupByPattern(this.mapTopicConfigs, name);
        if (config != null) {
            return config;
        }
        return this.getTopicConfig("default");
    }

    public TopicConfig getTopicConfig(String name) {
        TopicConfig config = Config.lookupByPattern(this.mapTopicConfigs, name);
        if (config != null) {
            return config;
        }
        TopicConfig defConfig = this.mapTopicConfigs.get("default");
        if (defConfig == null) {
            defConfig = new TopicConfig();
            defConfig.setName("default");
            this.addTopicConfig(defConfig);
        }
        config = new TopicConfig(defConfig);
        config.setName(name);
        this.addTopicConfig(config);
        return config;
    }

    private static <T> T lookupByPattern(Map<String, T> map, String name) {
        T t = map.get(name);
        if (t == null) {
            Set<String> tNames = map.keySet();
            for (String pattern : tNames) {
                if (!Config.nameMatches(name, pattern)) continue;
                return map.get(pattern);
            }
        }
        return t;
    }

    public static boolean nameMatches(String name, String pattern) {
        int index = pattern.indexOf(42);
        if (index == -1) {
            return name.equals(pattern);
        }
        String firstPart = pattern.substring(0, index);
        int indexFirstPart = name.indexOf(firstPart, 0);
        if (indexFirstPart == -1) {
            return false;
        }
        String secondPart = pattern.substring(index + 1);
        int indexSecondPart = name.indexOf(secondPart, index + 1);
        return indexSecondPart != -1;
    }

    public NetworkConfig getNetworkConfig() {
        return this.networkConfig;
    }

    public Config setNetworkConfig(NetworkConfig networkConfig) {
        this.networkConfig = networkConfig;
        return this;
    }

    public String getXmlConfig() {
        return this.xmlConfig;
    }

    public Config setXmlConfig(String xmlConfig) {
        this.xmlConfig = xmlConfig;
        return this;
    }

    public GroupConfig getGroupConfig() {
        return this.groupConfig;
    }

    public Config setGroupConfig(GroupConfig groupConfig) {
        this.groupConfig = groupConfig;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public Config setPort(int port) {
        this.port = port;
        return this;
    }

    public boolean isPortAutoIncrement() {
        return this.portAutoIncrement;
    }

    public Config setPortAutoIncrement(boolean portAutoIncrement) {
        this.portAutoIncrement = portAutoIncrement;
        return this;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public Config setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
        return this;
    }

    public boolean isCheckCompatibility() {
        return this.checkCompatibility;
    }

    public Config setCheckCompatibility(boolean checkCompatibility) {
        this.checkCompatibility = checkCompatibility;
        return this;
    }

    public ExecutorConfig getExecutorConfig() {
        return this.executorConfig;
    }

    public Config setExecutorConfig(ExecutorConfig executorConfig) {
        this.addExecutorConfig(executorConfig);
        return this;
    }

    public Config addExecutorConfig(ExecutorConfig executorConfig) {
        this.mapExecutors.put(executorConfig.getName(), executorConfig);
        return this;
    }

    public ExecutorConfig getExecutorConfig(String name) {
        ExecutorConfig defaultConfig;
        ExecutorConfig ec = this.mapExecutors.get(name);
        if (ec == null && (defaultConfig = this.mapExecutors.get("default")) != null) {
            ec = new ExecutorConfig(name, defaultConfig.getCorePoolSize(), defaultConfig.getMaxPoolSize(), defaultConfig.getKeepAliveSeconds());
        }
        if (ec == null) {
            ec = new ExecutorConfig(name);
            this.mapExecutors.put(name, ec);
        }
        return ec;
    }

    public Collection<ExecutorConfig> getExecutorConfigs() {
        return this.mapExecutors.values();
    }

    public Map<String, ExecutorConfig> getExecutorConfigMap() {
        return Collections.unmodifiableMap(this.mapExecutors);
    }

    public void setExecutorConfigMap(Map<String, ExecutorConfig> mapExecutors) {
        this.mapExecutors = mapExecutors;
        for (Map.Entry<String, ExecutorConfig> entry : this.mapExecutors.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
    }

    public void addTopicConfig(TopicConfig topicConfig) {
        this.mapTopicConfigs.put(topicConfig.getName(), topicConfig);
    }

    public Map<String, TopicConfig> getTopicConfigs() {
        return Collections.unmodifiableMap(this.mapTopicConfigs);
    }

    public Config setTopicConfigs(Map<String, TopicConfig> mapTopicConfigs) {
        this.mapTopicConfigs = mapTopicConfigs;
        for (Map.Entry<String, TopicConfig> entry : this.mapTopicConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Map<String, QueueConfig> getQConfigs() {
        return Collections.unmodifiableMap(this.mapQueueConfigs);
    }

    public void addQueueConfig(QueueConfig queueConfig) {
        this.mapQueueConfigs.put(queueConfig.getName(), queueConfig);
    }

    public void setQConfigs(Map<String, QueueConfig> mapQConfigs) {
        this.mapQueueConfigs = mapQConfigs;
        for (Map.Entry<String, QueueConfig> entry : this.mapQueueConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
    }

    public Config setMapQConfigs(Map<String, QueueConfig> mapQConfigs) {
        this.mapQueueConfigs = mapQConfigs;
        for (Map.Entry<String, QueueConfig> entry : this.mapQueueConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public void addMapConfig(MapConfig mapConfig) {
        this.mapConfigs.put(mapConfig.getName(), mapConfig);
    }

    public void addMultiMapConfig(MultiMapConfig multiMapConfig) {
        this.multiMapConfigs.put(multiMapConfig.getName(), multiMapConfig);
    }

    public Map<String, MapConfig> getMapConfigs() {
        return Collections.unmodifiableMap(this.mapConfigs);
    }

    public Map<String, MultiMapConfig> getMultiMapConfigs() {
        return Collections.unmodifiableMap(this.multiMapConfigs);
    }

    public Config setMapConfigs(Map<String, MapConfig> mapConfigs) {
        this.mapConfigs = mapConfigs;
        for (Map.Entry<String, MapConfig> entry : this.mapConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Config setMultiMapConfigs(Map<String, MultiMapConfig> multiMapConfigs) {
        this.multiMapConfigs = multiMapConfigs;
        for (Map.Entry<String, MultiMapConfig> entry : this.multiMapConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Config addSemaphoreConfig(SemaphoreConfig semaphoreConfig) {
        this.mapSemaphoreConfigs.put(semaphoreConfig.getName(), semaphoreConfig);
        return this;
    }

    public SemaphoreConfig getSemaphoreConfig(String name) {
        SemaphoreConfig defaultConfig;
        SemaphoreConfig sc = this.mapSemaphoreConfigs.get(name);
        if (sc == null && (defaultConfig = this.mapSemaphoreConfigs.get("default")) != null) {
            sc = new SemaphoreConfig(name, defaultConfig);
        }
        if (sc == null) {
            sc = new SemaphoreConfig(name);
            this.mapSemaphoreConfigs.put(name, sc);
        }
        return sc;
    }

    public Collection<SemaphoreConfig> getSemaphoreConfigs() {
        return this.mapSemaphoreConfigs.values();
    }

    public Map<String, SemaphoreConfig> getSemaphoreConfigMap() {
        return Collections.unmodifiableMap(this.mapSemaphoreConfigs);
    }

    public void setSemaphoreConfigMap(Map<String, SemaphoreConfig> mapSemaphores) {
        this.mapSemaphoreConfigs = mapSemaphores;
        for (Map.Entry<String, SemaphoreConfig> entry : this.mapSemaphoreConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
    }

    public URL getConfigurationUrl() {
        return this.configurationUrl;
    }

    public Config setConfigurationUrl(URL configurationUrl) {
        this.configurationUrl = configurationUrl;
        return this;
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public Config setConfigurationFile(File configurationFile) {
        this.configurationFile = configurationFile;
        return this;
    }

    public boolean isSuperClient() {
        return this.liteMember;
    }

    public boolean isLiteMember() {
        return this.liteMember;
    }

    public Config setSuperClient(boolean liteMember) {
        this.liteMember = liteMember;
        return this;
    }

    public Config setLiteMember(boolean liteMember) {
        this.liteMember = liteMember;
        return this;
    }

    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public void setSecurityConfig(SecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
    }

    public Config addListenerConfig(ListenerConfig listenerConfig) {
        this.getListenerConfigs().add(listenerConfig);
        return this;
    }

    public List<ListenerConfig> getListenerConfigs() {
        if (this.listenerConfigs == null) {
            this.listenerConfigs = new ArrayList<ListenerConfig>();
        }
        return this.listenerConfigs;
    }

    public void setListenerConfigs(List<ListenerConfig> listenerConfigs) {
        this.listenerConfigs = listenerConfigs;
    }

    public PartitionGroupConfig getPartitionGroupConfig() {
        return this.partitionGroupConfig;
    }

    public void setPartitionGroupConfig(PartitionGroupConfig partitionGroupConfig) {
        this.partitionGroupConfig = partitionGroupConfig;
    }

    public boolean isCompatible(Config config) {
        if (config == null) {
            throw new IllegalArgumentException("Expected not null config");
        }
        if (!this.groupConfig.getName().equals(config.getGroupConfig().getName())) {
            return false;
        }
        if (!this.groupConfig.getPassword().equals(config.getGroupConfig().getPassword())) {
            throw new RuntimeException("Incompatible group password");
        }
        if (this.checkCompatibility) {
            this.checkMapConfigCompatible(config);
            this.checkQueueConfigCompatible(config);
            this.checkTopicConfigCompatible(config);
        }
        return true;
    }

    private void checkMapConfigCompatible(Config config) {
        HashSet<String> mapConfigNames = new HashSet<String>(this.mapConfigs.keySet());
        mapConfigNames.addAll(config.mapConfigs.keySet());
        for (String name : mapConfigNames) {
            MapConfig thisMapConfig = Config.lookupByPattern(this.mapConfigs, name);
            MapConfig thatMapConfig = Config.lookupByPattern(config.mapConfigs, name);
            if (thisMapConfig == null || thatMapConfig == null || thisMapConfig.isCompatible(thatMapConfig)) continue;
            throw new RuntimeException(MessageFormat.format("Incompatible map config this:\n{0}\nanother:\n{1}", thisMapConfig, thatMapConfig));
        }
    }

    private void checkQueueConfigCompatible(Config config) {
        HashSet<String> queueConfigNames = new HashSet<String>(this.mapQueueConfigs.keySet());
        queueConfigNames.addAll(config.mapQueueConfigs.keySet());
        for (String name : queueConfigNames) {
            QueueConfig thisQueueConfig = Config.lookupByPattern(this.mapQueueConfigs, name);
            QueueConfig thatQueueConfig = Config.lookupByPattern(config.mapQueueConfigs, name);
            if (thisQueueConfig == null || thatQueueConfig == null || thisQueueConfig.isCompatible(thatQueueConfig)) continue;
            throw new RuntimeException(MessageFormat.format("Incompatible queue config this:\n{0}\nanother:\n{1}", thisQueueConfig, thatQueueConfig));
        }
    }

    private void checkTopicConfigCompatible(Config config) {
        HashSet<String> topicConfigNames = new HashSet<String>(this.mapTopicConfigs.keySet());
        topicConfigNames.addAll(config.mapTopicConfigs.keySet());
        for (String name : topicConfigNames) {
            TopicConfig thisTopicConfig = Config.lookupByPattern(this.mapTopicConfigs, name);
            TopicConfig thatTopicConfig = Config.lookupByPattern(config.mapTopicConfigs, name);
            if (thisTopicConfig == null || thatTopicConfig == null || thisTopicConfig.equals(thatTopicConfig)) continue;
            throw new RuntimeException(MessageFormat.format("Incompatible topic config this:\n{0}\nanother:\n{1}", thisTopicConfig, thatTopicConfig));
        }
    }

    @Override
    public void readData(DataInput in) throws IOException {
        int i;
        int size;
        this.groupConfig = new GroupConfig();
        this.groupConfig.readData(in);
        this.port = in.readInt();
        boolean[] b1 = ByteUtil.fromByte(in.readByte());
        this.checkCompatibility = b1[0];
        this.reuseAddress = b1[1];
        this.portAutoIncrement = b1[2];
        this.liteMember = b1[3];
        boolean[] b2 = ByteUtil.fromByte(in.readByte());
        boolean hasMapConfigs = b2[0];
        boolean hasMapExecutors = b2[1];
        boolean hasMapTopicConfigs = b2[2];
        boolean hasMapQueueConfigs = b2[3];
        boolean hasMapMergePolicyConfigs = b2[4];
        boolean hasMapSemaphoreConfigs = b2[5];
        boolean hasProperties = b2[6];
        this.networkConfig = new NetworkConfig();
        this.networkConfig.readData(in);
        this.executorConfig = new ExecutorConfig();
        this.executorConfig.readData(in);
        if (hasMapConfigs) {
            size = in.readInt();
            this.mapConfigs = new ConcurrentHashMap<String, MapConfig>(size);
            for (i = 0; i < size; ++i) {
                MapConfig mapConfig = new MapConfig();
                mapConfig.readData(in);
                this.mapConfigs.put(mapConfig.getName(), mapConfig);
            }
        }
        if (hasMapExecutors) {
            size = in.readInt();
            this.mapExecutors = new ConcurrentHashMap<String, ExecutorConfig>(size);
            for (i = 0; i < size; ++i) {
                ExecutorConfig executorConfig = new ExecutorConfig();
                executorConfig.readData(in);
                this.mapExecutors.put(executorConfig.getName(), executorConfig);
            }
        }
        if (hasMapSemaphoreConfigs) {
            size = in.readInt();
            this.mapSemaphoreConfigs = new ConcurrentHashMap<String, SemaphoreConfig>(size);
            for (i = 0; i < size; ++i) {
                SemaphoreConfig semaphoreConfig = new SemaphoreConfig();
                semaphoreConfig.readData(in);
                this.mapSemaphoreConfigs.put(semaphoreConfig.getName(), semaphoreConfig);
            }
        }
        if (hasMapTopicConfigs) {
            size = in.readInt();
            this.mapTopicConfigs = new ConcurrentHashMap<String, TopicConfig>(size);
            for (i = 0; i < size; ++i) {
                TopicConfig topicConfig = new TopicConfig();
                topicConfig.readData(in);
                this.mapTopicConfigs.put(topicConfig.getName(), topicConfig);
            }
        }
        if (hasMapQueueConfigs) {
            size = in.readInt();
            this.mapQueueConfigs = new ConcurrentHashMap<String, QueueConfig>(size);
            for (i = 0; i < size; ++i) {
                QueueConfig queueConfig = new QueueConfig();
                queueConfig.readData(in);
                this.mapQueueConfigs.put(queueConfig.getName(), queueConfig);
            }
        }
        if (hasMapMergePolicyConfigs) {
            // empty if block
        }
        if (hasProperties) {
            size = in.readInt();
            this.properties = new Properties();
            for (i = 0; i < size; ++i) {
                String name = in.readUTF();
                String value = in.readUTF();
                this.properties.put(name, value);
            }
        }
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        String name;
        this.getGroupConfig().writeData(out);
        out.writeInt(this.port);
        boolean hasMapConfigs = this.mapConfigs != null && !this.mapConfigs.isEmpty();
        boolean hasMapExecutors = this.mapExecutors != null && !this.mapExecutors.isEmpty();
        boolean hasMapTopicConfigs = this.mapTopicConfigs != null && !this.mapTopicConfigs.isEmpty();
        boolean hasMapQueueConfigs = this.mapQueueConfigs != null && !this.mapQueueConfigs.isEmpty();
        boolean hasMapMergePolicyConfigs = this.mapMergePolicyConfigs != null && !this.mapMergePolicyConfigs.isEmpty();
        boolean hasMapSemaphoreConfigs = this.mapSemaphoreConfigs != null && !this.mapSemaphoreConfigs.isEmpty();
        boolean hasProperties = this.properties != null && !this.properties.isEmpty();
        out.writeByte(ByteUtil.toByte(this.checkCompatibility, this.reuseAddress, this.portAutoIncrement, this.liteMember));
        out.writeByte(ByteUtil.toByte(hasMapConfigs, hasMapExecutors, hasMapTopicConfigs, hasMapQueueConfigs, hasMapMergePolicyConfigs, hasMapSemaphoreConfigs, hasProperties));
        this.networkConfig.writeData(out);
        this.executorConfig.writeData(out);
        if (hasMapConfigs) {
            out.writeInt(this.mapConfigs.size());
            for (Map.Entry<String, DataSerializable> entry : this.mapConfigs.entrySet()) {
                name = entry.getKey();
                MapConfig mapConfig = (MapConfig)entry.getValue();
                mapConfig.setName(name);
                mapConfig.writeData(out);
            }
        }
        if (hasMapExecutors) {
            out.writeInt(this.mapExecutors.size());
            for (Map.Entry<String, DataSerializable> entry : this.mapExecutors.entrySet()) {
                name = entry.getKey();
                ExecutorConfig executorConfig = (ExecutorConfig)entry.getValue();
                executorConfig.setName(name);
                executorConfig.writeData(out);
            }
        }
        if (hasMapSemaphoreConfigs) {
            out.writeInt(this.mapSemaphoreConfigs.size());
            for (Map.Entry<String, DataSerializable> entry : this.mapSemaphoreConfigs.entrySet()) {
                name = entry.getKey();
                SemaphoreConfig semaphoreConfig = (SemaphoreConfig)entry.getValue();
                semaphoreConfig.setName(name);
                semaphoreConfig.writeData(out);
            }
        }
        if (hasMapTopicConfigs) {
            out.writeInt(this.mapTopicConfigs.size());
            for (Map.Entry<String, DataSerializable> entry : this.mapTopicConfigs.entrySet()) {
                name = entry.getKey();
                TopicConfig topicConfig = (TopicConfig)entry.getValue();
                topicConfig.setName(name);
                topicConfig.writeData(out);
            }
        }
        if (hasMapQueueConfigs) {
            out.writeInt(this.mapQueueConfigs.size());
            for (Map.Entry<String, DataSerializable> entry : this.mapQueueConfigs.entrySet()) {
                name = entry.getKey();
                QueueConfig queueConfig = (QueueConfig)entry.getValue();
                queueConfig.setName(name);
                queueConfig.writeData(out);
            }
        }
        if (hasMapMergePolicyConfigs) {
            // empty if block
        }
        if (hasProperties) {
            out.writeInt(this.properties.size());
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                out.writeUTF(key);
                out.writeUTF(value);
            }
        }
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String toString() {
        return "Config [groupConfig=" + this.groupConfig + ", port=" + this.port + ", liteMember=" + this.liteMember + ", reuseAddress=" + this.reuseAddress + ", checkCompatibility=" + this.checkCompatibility + ", portAutoIncrement=" + this.portAutoIncrement + ", properties=" + this.properties + ", networkConfig=" + this.networkConfig + ", mapConfigs=" + this.mapConfigs + ", mapMergePolicyConfigs=" + this.mapMergePolicyConfigs + ", executorConfig=" + this.executorConfig + ", mapExecutors=" + this.mapExecutors + ", mapTopicConfigs=" + this.mapTopicConfigs + ", mapQueueConfigs=" + this.mapQueueConfigs + "]";
    }
}

