/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.SelectionHandler;
import com.hazelcast.nio.SelectorBase;
import com.hazelcast.nio.SocketChannelWrapper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public class InOutSelector
extends SelectorBase {
    final ServerSocketChannel serverSocketChannel;

    public InOutSelector(ConnectionManager connectionManager, final ServerSocketChannel serverSocketChannel) {
        super(connectionManager, 1);
        this.serverSocketChannel = serverSocketChannel;
        if (serverSocketChannel != null) {
            this.addTask(new Runnable(){

                public void run() {
                    try {
                        serverSocketChannel.register(InOutSelector.this.selector, 16, new Acceptor());
                        InOutSelector.this.selector.wakeup();
                    }
                    catch (ClosedChannelException e) {
                        InOutSelector.this.logger.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            });
            this.logger.log(Level.FINEST, "Started Selector at " + serverSocketChannel.socket().getLocalPort());
        }
    }

    public void connect(Address address) {
        this.logger.log(Level.FINEST, "connect to " + address);
        Connector connector = new Connector(address);
        this.addTask(connector);
    }

    public void publishUtilization() {
    }

    private class Acceptor
    implements SelectionHandler {
        private Acceptor() {
        }

        public void handle() {
            try {
                SocketChannelWrapper channel = InOutSelector.this.connectionManager.wrapSocketChannel(InOutSelector.this.serverSocketChannel.accept(), false);
                InOutSelector.this.logger.log(Level.INFO, channel.socket().getLocalPort() + " is accepting socket connection from " + channel.socket().getRemoteSocketAddress());
                InOutSelector.this.initSocket(channel.socket());
                channel.configureBlocking(false);
                InOutSelector.this.connectionManager.assignSocketChannel(channel);
            }
            catch (Exception e) {
                InOutSelector.this.logger.log(Level.FINEST, e.getMessage(), e);
                try {
                    InOutSelector.this.serverSocketChannel.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                InOutSelector.this.connectionManager.ioService.onFatalError(e);
            }
        }
    }

    private class Connector
    implements Runnable,
    SelectionHandler {
        final Address address;
        SocketChannel socketChannel = null;
        long startTime;
        long lastCheck = this.startTime = System.currentTimeMillis();

        public Connector(Address address) {
            this.address = address;
        }

        public void handle() {
            try {
                boolean finished = this.socketChannel.finishConnect();
                if (!finished) {
                    long now = System.currentTimeMillis();
                    if (now - this.lastCheck > 5000L) {
                        InOutSelector.this.logger.log(Level.WARNING, "Couldn't connect to " + this.address + " for " + (now - this.startTime) / 1000L + " seconds!");
                        this.lastCheck = now;
                    }
                    this.socketChannel.register(InOutSelector.this.selector, 8, this);
                    return;
                }
                InOutSelector.this.logger.log(Level.FINEST, "connected to " + this.address);
                SocketChannelWrapper socketChannelWrapper = InOutSelector.this.connectionManager.wrapSocketChannel(this.socketChannel, true);
                Connection connection = InOutSelector.this.connectionManager.createConnection(socketChannelWrapper, InOutSelector.this);
                InOutSelector.this.connectionManager.bind(this.address, connection, false);
            }
            catch (Throwable e) {
                try {
                    String msg = "Couldn't connect to " + this.address + ", cause: " + e.getMessage();
                    InOutSelector.this.logger.log(Level.FINEST, msg, e);
                    this.socketChannel.close();
                    InOutSelector.this.connectionManager.failedConnection(this.address, e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void run() {
            try {
                this.socketChannel = SocketChannel.open();
                this.initSocket(this.socketChannel.socket());
                Address thisAddress = InOutSelector.this.connectionManager.ioService.getThisAddress();
                this.socketChannel.configureBlocking(false);
                this.socketChannel.socket().bind(new InetSocketAddress(thisAddress.getInetAddress(), 0));
                InOutSelector.this.logger.log(Level.FINEST, "connecting to " + this.address);
                boolean connected = this.socketChannel.connect(new InetSocketAddress(this.address.getInetAddress(), this.address.getPort()));
                InOutSelector.this.logger.log(Level.FINEST, "connection check. connected: " + connected + ", " + this.address);
                this.handle();
            }
            catch (Throwable e) {
                InOutSelector.this.logger.log(Level.WARNING, e.getMessage(), e);
                if (this.socketChannel != null) {
                    try {
                        this.socketChannel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                InOutSelector.this.connectionManager.failedConnection(this.address, e);
            }
        }

        private void initSocket(Socket socket) throws Exception {
            InOutSelector.this.initSocket(socket);
            if (InOutSelector.this.connectionManager.SOCKET_TIMEOUT > 0) {
                socket.setSoTimeout(InOutSelector.this.connectionManager.SOCKET_TIMEOUT);
            }
        }
    }
}

