/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.concurrentmap;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.PartitionManager;
import com.hazelcast.impl.base.Pairs;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.query.Predicate;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapQueryCallable
implements Callable<Pairs>,
DataSerializable,
HazelcastInstanceAware {
    private Data predicateData;
    private int partitionVersion;
    private String mapName;
    private ClusterOperation operation;
    private transient HazelcastInstance hazelcast;

    public MapQueryCallable(String mapName, ClusterOperation operation, Data predicateData, int partitionVersion) {
        this.mapName = mapName;
        this.operation = operation;
        this.predicateData = predicateData;
        this.partitionVersion = partitionVersion;
    }

    public MapQueryCallable() {
    }

    @Override
    public Pairs call() throws Exception {
        FactoryImpl factory = (FactoryImpl)this.hazelcast;
        ConcurrentMapManager concurrentMapManager = factory.node.concurrentMapManager;
        CMap cmap = concurrentMapManager.getMap(this.mapName);
        if (cmap == null) {
            return new Pairs();
        }
        PartitionManager partitionManager = concurrentMapManager.getPartitionManager();
        if (partitionManager.getVersion() != this.partitionVersion) {
            return null;
        }
        Pairs pairs = factory.node.concurrentMapManager.queryMap(cmap, this.operation, (Predicate)IOUtil.toObject(this.predicateData));
        if (partitionManager.getVersion() != this.partitionVersion) {
            return null;
        }
        return pairs;
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.mapName);
        out.writeByte(this.operation.getValue());
        out.writeInt(this.partitionVersion);
        boolean hasPredicate = this.predicateData != null;
        out.writeBoolean(hasPredicate);
        if (hasPredicate) {
            this.predicateData.writeData(out);
        }
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.mapName = in.readUTF();
        this.operation = ClusterOperation.create(in.readByte());
        this.partitionVersion = in.readInt();
        boolean hasPredicate = in.readBoolean();
        if (hasPredicate) {
            this.predicateData = new Data();
            this.predicateData.readData(in);
        }
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcast = hazelcastInstance;
    }
}

