/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.base.CallState;
import com.hazelcast.impl.base.DistributedLock;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.Packet;

public class Request {
    public static final long DEFAULT_TIMEOUT = -1L;
    public static final long DEFAULT_TTL = -1L;
    public static final int DEFAULT_REDO_COUNT = 0;
    public static final long DEFAULT_TXN_ID = -1L;
    public static final int DEFAULT_LOCK_COUNT = 0;
    public static final int DEFAULT_LOCK_THREAD_ID = -1;
    public static final int DEFAULT_BLOCK_ID = -1;
    public static final long DEFAULT_CALL_ID = -1L;
    public static final long DEFAULT_VERSION = -1L;
    public String name = null;
    public Data key = null;
    public Data value = null;
    public long timeout = -1L;
    public long ttl = -1L;
    public boolean local = true;
    public boolean scheduled = false;
    public ClusterOperation operation;
    public Address caller = null;
    public Address lockAddress = null;
    public int redoCount = 0;
    public int lockCount = 0;
    public int lockThreadId = -1;
    public int blockId = -1;
    public long callId = -1L;
    public long longValue = Long.MIN_VALUE;
    public long version = -1L;
    public long txnId = -1L;
    public Long[] indexes;
    public byte[] indexTypes;
    public Object attachment = null;
    public Object response = null;
    public ResponseType responseType = ResponseType.OBJECT;
    public Record record = null;
    public CallState callState = null;

    public boolean hasEnoughTimeToSchedule() {
        return this.timeout == -1L || this.timeout > 100L;
    }

    public String toString() {
        return "Request{name='" + this.name + '\'' + "," + (Object)((Object)this.operation) + ", redoCount='" + this.redoCount + '\'' + ", callId='" + this.callId + '\'' + ", lockThreadId='" + this.lockThreadId + '\'' + '}';
    }

    public void reset() {
        this.local = true;
        this.operation = ClusterOperation.NONE;
        this.name = null;
        this.key = null;
        this.value = null;
        this.blockId = -1;
        this.timeout = -1L;
        this.ttl = -1L;
        this.txnId = -1L;
        this.callId = -1L;
        this.lockThreadId = -1;
        this.lockAddress = null;
        this.lockCount = 0;
        this.caller = null;
        this.longValue = Long.MIN_VALUE;
        this.version = -1L;
        this.response = null;
        this.scheduled = false;
        this.attachment = null;
        this.redoCount = 0;
        this.indexes = null;
        this.indexTypes = null;
        this.responseType = ResponseType.OBJECT;
        this.record = null;
        this.callState = null;
    }

    public void beforeRedo() {
        this.record = null;
        this.scheduled = false;
        this.response = null;
    }

    public void setIndexes(Long[] newIndexes, byte[] indexTypes) {
        this.indexes = newIndexes;
        this.indexTypes = indexTypes;
        if (this.indexes.length != indexTypes.length) {
            throw new RuntimeException("Indexes length and indexTypes length has to be the same." + this.indexes.length + " vs. " + indexTypes.length);
        }
    }

    private void set(boolean local, ClusterOperation operation, String name, Data key, Data value, int blockId, long timeout, long ttl, long txnId, long callId, int lockThreadId, Address lockAddress, int lockCount, Address caller, long longValue, long version) {
        this.local = local;
        this.operation = operation;
        this.name = name;
        this.key = key;
        this.value = value;
        this.blockId = blockId;
        this.timeout = timeout < 0L ? -1L : timeout;
        this.ttl = ttl;
        this.txnId = txnId;
        this.callId = callId;
        this.lockThreadId = lockThreadId;
        this.lockAddress = lockAddress;
        this.lockCount = lockCount;
        this.caller = caller;
        this.longValue = longValue;
        this.version = version;
        this.record = null;
    }

    public void setLocal(ClusterOperation operation, String name, Data key, Data value, int blockId, long timeout, long ttl, Address thisAddress) {
        this.response = null;
        this.scheduled = false;
        this.attachment = null;
        this.redoCount = 0;
        this.indexes = null;
        this.indexTypes = null;
        this.responseType = ResponseType.OBJECT;
        this.set(true, operation, name, key, value, blockId, timeout, ttl, ThreadContext.get().getTxnId(), -1L, ThreadContext.get().getThreadId(), thisAddress, 0, thisAddress, Long.MIN_VALUE, -1L);
    }

    public void setFromRequest(Request req) {
        this.set(req.local, req.operation, req.name, req.key, req.value, req.blockId, req.timeout, req.ttl, req.txnId, req.callId, req.lockThreadId, req.lockAddress, req.lockCount, req.caller, req.longValue, req.version);
        this.attachment = req.attachment;
        this.response = req.response;
        this.scheduled = req.scheduled;
        this.indexes = req.indexes;
        this.indexTypes = req.indexTypes;
        this.callState = req.callState;
    }

    public static Request copy(Packet packet) {
        Request copy = new Request();
        copy.set(false, packet.operation, packet.name, packet.getKeyData(), packet.getValueData(), packet.blockId, packet.timeout, packet.ttl, packet.txnId, packet.callId, packet.threadId, packet.lockAddress, packet.lockCount, packet.conn.getEndPoint(), packet.longValue, packet.version);
        copy.indexes = packet.indexes;
        copy.indexTypes = packet.indexTypes;
        copy.callState = packet.callState;
        return copy;
    }

    public void setFromRecord(Record record) {
        this.reset();
        this.name = record.getName();
        this.version = record.getVersion();
        this.blockId = record.getBlockId();
        DistributedLock lock = record.getLock();
        if (lock != null) {
            this.lockThreadId = lock.getLockThreadId();
            this.lockAddress = lock.getLockAddress();
            this.lockCount = lock.getLockCount();
        }
        this.ttl = record.getRemainingTTL();
        this.timeout = record.getRemainingIdle();
        this.key = record.getKeyData();
        this.value = record.getValueData();
        if (record.getIndexes() != null) {
            this.setIndexes(record.getIndexes(), record.getIndexTypes());
        }
    }

    public Request hardCopy() {
        Request copy = new Request();
        copy.setFromRequest(this);
        return copy;
    }

    public void setPacket(Packet packet) {
        packet.operation = this.operation;
        packet.name = this.name;
        packet.setKey(this.key);
        packet.setValue(this.value);
        packet.blockId = this.blockId;
        packet.timeout = this.timeout;
        packet.ttl = this.ttl;
        packet.txnId = this.txnId;
        packet.callId = this.callId;
        packet.threadId = this.lockThreadId;
        packet.lockAddress = this.lockAddress;
        packet.lockCount = this.lockCount;
        packet.longValue = this.longValue;
        packet.version = this.version;
        packet.indexes = this.indexes;
        packet.indexTypes = this.indexTypes;
        packet.callState = this.callState;
    }

    public void clearForResponse() {
        if (!this.local) {
            this.name = null;
            this.key = null;
            this.value = null;
            this.blockId = -1;
            this.timeout = -1L;
            this.ttl = -1L;
            this.txnId = -1L;
            this.lockThreadId = -1;
            this.lockAddress = null;
            this.lockCount = 0;
            this.longValue = Long.MIN_VALUE;
            this.version = -1L;
            this.indexes = null;
            this.indexTypes = null;
            this.record = null;
            this.callState = null;
        }
    }

    public void setLongRequest() {
        this.responseType = ResponseType.LONG;
    }

    public void setBooleanRequest() {
        this.responseType = ResponseType.BOOLEAN;
    }

    public void setObjectRequest() {
        this.responseType = ResponseType.OBJECT;
    }

    public boolean isLongRequest() {
        return this.responseType == ResponseType.LONG;
    }

    public boolean isBooleanRequest() {
        return this.responseType == ResponseType.BOOLEAN;
    }

    public boolean isObjectRequest() {
        return this.responseType == ResponseType.OBJECT;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ResponseType {
        OBJECT,
        BOOLEAN,
        LONG;

    }
}

