/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.nio.AbstractSelectionHandler;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.SocketPacketWriter;
import com.hazelcast.nio.SocketWritable;
import com.hazelcast.nio.SocketWriter;
import com.hazelcast.nio.ascii.SocketTextWriter;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public final class WriteHandler
extends AbstractSelectionHandler
implements Runnable {
    private final Queue<SocketWritable> writeQueue = new ConcurrentLinkedQueue<SocketWritable>();
    private final AtomicBoolean informSelector = new AtomicBoolean(true);
    private final ByteBuffer socketBB = ByteBuffer.allocate(32768);
    private boolean ready = false;
    private SocketWritable lastWritable = null;
    private SocketWriter socketWriter = null;

    WriteHandler(Connection connection) {
        super(connection);
    }

    public void setProtocol(String protocol) {
        if (this.socketWriter == null) {
            if ("HZC".equals(protocol)) {
                this.socketWriter = new SocketPacketWriter(this.node, this.socketChannel, this.connection);
                this.socketBB.put("HZC".getBytes());
                this.outSelector.addTask(this);
            } else {
                this.socketWriter = new SocketTextWriter(this.connection);
            }
        }
    }

    public SocketWriter getSocketWriter() {
        return this.socketWriter;
    }

    public void enqueueSocketWritable(SocketWritable socketWritable) {
        socketWritable.onEnqueue();
        this.writeQueue.offer(socketWritable);
        if (this.informSelector.compareAndSet(true, false)) {
            this.outSelector.addTask(this);
            this.outSelector.selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle() {
        if (this.socketWriter == null) {
            this.setProtocol("HZC");
        }
        if (this.lastWritable == null) {
            this.lastWritable = this.writeQueue.poll();
            if (this.lastWritable == null && this.socketBB.position() == 0) {
                this.ready = true;
                return;
            }
        }
        if (!this.connection.live()) {
            return;
        }
        try {
            while (this.socketBB.hasRemaining()) {
                if (this.lastWritable == null) {
                    this.lastWritable = this.writeQueue.poll();
                }
                if (this.lastWritable == null) break;
                boolean complete = this.socketWriter.write(this.lastWritable, this.socketBB);
                if (complete) {
                    this.lastWritable = null;
                    continue;
                }
                if (!this.socketBB.hasRemaining()) continue;
                break;
            }
            this.socketBB.flip();
            try {
                int written = this.socketChannel.write(this.socketBB);
            }
            catch (Exception e) {
                if (this.lastWritable != null) {
                    this.lastWritable = null;
                }
                this.handleSocketException(e);
                this.ready = false;
                this.registerWrite();
                return;
            }
            if (this.socketBB.hasRemaining()) {
                this.socketBB.compact();
            } else {
                this.socketBB.clear();
            }
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "Fatal Error at WriteHandler for endPoint: " + this.connection.getEndPoint(), t);
            t.printStackTrace();
        }
        finally {
            this.ready = false;
            this.registerWrite();
        }
    }

    public void run() {
        this.informSelector.set(true);
        if (this.ready) {
            this.handle();
        } else {
            this.registerWrite();
        }
        this.ready = false;
    }

    private void registerWrite() {
        this.registerOp(this.outSelector.selector, 4);
    }

    public void shutdown() {
        this.writeQueue.clear();
    }
}

