/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.Packet;
import com.hazelcast.client.Serializer;
import com.hazelcast.core.Instance;
import com.hazelcast.core.InstanceEvent;
import com.hazelcast.core.InstanceListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class InstanceListenerManager {
    private final List<InstanceListener> instanceListeners = new CopyOnWriteArrayList<InstanceListener>();
    private final HazelcastClient client;

    public InstanceListenerManager(HazelcastClient client) {
        this.client = client;
    }

    public void registerInstanceListener(InstanceListener listener) {
        this.instanceListeners.add(listener);
    }

    public void removeInstanceListener(InstanceListener instanceListener) {
        this.instanceListeners.remove(instanceListener);
    }

    public synchronized boolean noInstanceListenerRegistered() {
        return this.instanceListeners.isEmpty();
    }

    public void notifyInstanceListeners(Packet packet) {
        String id = (String)Serializer.toObject(packet.getKey());
        InstanceEvent.InstanceEventType instanceEventType = (InstanceEvent.InstanceEventType)((Object)Serializer.toObject(packet.getValue()));
        InstanceEvent event = new InstanceEvent(instanceEventType, (Instance)this.client.getClientProxy(id));
        for (InstanceListener listener : this.instanceListeners) {
            if (InstanceEvent.InstanceEventType.CREATED.equals((Object)event.getEventType())) {
                listener.instanceCreated(event);
                continue;
            }
            if (!InstanceEvent.InstanceEventType.DESTROYED.equals((Object)event.getEventType())) continue;
            listener.instanceDestroyed(event);
        }
    }
}

