/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.core.Member;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.nio.Address;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.SocketFactory;

public class Connection {
    private static final int BUFFER_SIZE = 32768;
    private final Socket socket;
    private final InetSocketAddress address;
    private final int id;
    private final DataOutputStream dos;
    private final DataInputStream dis;
    boolean headersWritten = false;
    boolean headerRead = false;

    public Connection(String host, int port, int id) {
        this(new InetSocketAddress(host, port), id);
    }

    public Connection(InetSocketAddress address, int id) {
        this.id = id;
        this.address = address;
        try {
            this.socket = SocketFactory.getDefault().createSocket(address.getAddress(), address.getPort());
            this.socket.setKeepAlive(true);
            this.dos = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream(), 32768));
            this.dis = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 32768));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public int getVersion() {
        return this.id;
    }

    public String toString() {
        return "Connection [" + this.id + "]" + " [" + this.address + "]";
    }

    public DataOutputStream getOutputStream() {
        return this.dos;
    }

    public DataInputStream getInputStream() {
        return this.dis;
    }

    public Member getMember() {
        return new MemberImpl(new Address(this.address), false);
    }
}

