/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.config.AsymmetricEncryptionConfig;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.Interfaces;
import com.hazelcast.config.Join;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.config.WanTargetClusterConfig;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HazelcastConfigBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlConfigBuilder springXmlConfigBuilder = new SpringXmlConfigBuilder(parserContext);
        springXmlConfigBuilder.handleConfig(element);
        return springXmlConfigBuilder.getBeanDefinition();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SpringXmlConfigBuilder
    extends AbstractXmlConfigHelper {
        private final ParserContext parserContext;
        private BeanDefinitionBuilder configBuilder;
        private ManagedMap mapConfigManagedMap;
        private ManagedMap queueManagedMap;
        private ManagedMap topicManagedMap;
        private ManagedMap executorManagedMap;
        private ManagedMap wanReplicationManagedMap;
        private ManagedMap mergePolicyConfigMap;
        final Map<String, Integer> counter = new HashMap<String, Integer>();

        public SpringXmlConfigBuilder(ParserContext parserContext) {
            this.parserContext = parserContext;
            this.configBuilder = BeanDefinitionBuilder.rootBeanDefinition(Config.class);
            this.mapConfigManagedMap = new ManagedMap();
            this.queueManagedMap = new ManagedMap();
            this.topicManagedMap = new ManagedMap();
            this.executorManagedMap = new ManagedMap();
            this.wanReplicationManagedMap = new ManagedMap();
            this.mergePolicyConfigMap = new ManagedMap();
            this.configBuilder.addPropertyValue("mapConfigs", (Object)this.mapConfigManagedMap);
            this.configBuilder.addPropertyValue("QConfigs", (Object)this.queueManagedMap);
            this.configBuilder.addPropertyValue("topicConfigs", (Object)this.topicManagedMap);
            this.configBuilder.addPropertyValue("executorConfigMap", (Object)this.executorManagedMap);
            this.configBuilder.addPropertyValue("wanReplicationConfigs", (Object)this.wanReplicationManagedMap);
            this.configBuilder.addPropertyValue("mergePolicyConfigs", (Object)this.mergePolicyConfigMap);
        }

        public AbstractBeanDefinition getBeanDefinition() {
            return this.configBuilder.getBeanDefinition();
        }

        private String nextId(String id) {
            Integer idx = this.counter.get(id);
            idx = (idx != null ? idx : 0) + 1;
            this.counter.put(id, idx);
            return id + idx;
        }

        protected BeanDefinitionBuilder createBeanBuilder(Class clazz, String id) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((Class)clazz);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, this.nextId(id));
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)this.parserContext.getRegistry());
            return builder;
        }

        protected BeanDefinitionBuilder createAndFillBeanBuilder(Node node, Class clazz, String propertyName, BeanDefinitionBuilder parent, String ... exceptPropertyNames) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(clazz, propertyName);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            this.fillValues(node, builder, exceptPropertyNames);
            parent.addPropertyValue(propertyName, (Object)beanDefinition);
            return builder;
        }

        protected void createAndFillListedBean(Node node, Class clazz, String propertyName, ManagedMap managedMap) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(clazz, propertyName);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getValue(attName);
            builder.addPropertyValue("name", (Object)name);
            this.fillValues(node, builder, new String[0]);
            managedMap.put((Object)name, (Object)beanDefinition);
        }

        protected void fillValues(Node node, BeanDefinitionBuilder builder, String ... excludeNames) {
            HashSet<String> epn = excludeNames != null && excludeNames.length > 0 ? new HashSet<String>(Arrays.asList(excludeNames)) : null;
            this.fillAttributeValues(node, builder, (Collection<String>)epn);
            for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String name = this.xmlToJavaName(this.cleanNodeName(n));
                if (epn != null && epn.contains(name)) continue;
                String value = this.getValue(n);
                builder.addPropertyValue(name, (Object)value);
            }
        }

        private void fillAttributeValues(Node node, BeanDefinitionBuilder builder, Collection<String> epn) {
            NamedNodeMap atts = node.getAttributes();
            if (atts != null) {
                for (int a = 0; a < atts.getLength(); ++a) {
                    Node att = atts.item(a);
                    String name = this.xmlToJavaName(att.getNodeName());
                    if (epn != null && epn.contains(name)) continue;
                    String value = att.getNodeValue();
                    builder.addPropertyValue(name, (Object)value);
                }
            }
        }

        public void handleConfig(Element docElement) {
            for (Node node : new AbstractXmlConfigHelper.IterableNodeList(docElement, 1)) {
                String nodeName = SpringXmlConfigBuilder.cleanNodeName(node.getNodeName());
                if ("network".equals(nodeName)) {
                    this.handleNetwork(node);
                    continue;
                }
                if ("group".equals(nodeName)) {
                    this.handleGroup(node);
                    continue;
                }
                if ("properties".equals(nodeName)) {
                    this.handleProperties(node);
                    continue;
                }
                if ("executor-service".equals(nodeName)) {
                    this.handleExecutor(node);
                    continue;
                }
                if ("queue".equals(nodeName)) {
                    this.handleQueue(node);
                    continue;
                }
                if ("map".equals(nodeName)) {
                    this.handleMap(node);
                    continue;
                }
                if ("topic".equals(nodeName)) {
                    this.handleTopic(node);
                    continue;
                }
                if ("merge-policies".equals(nodeName)) {
                    this.handleMergePolicies(node);
                    continue;
                }
                if (!"wan-replication".equals(nodeName)) continue;
                this.handleWanReplication(node);
            }
        }

        public void handleNetwork(Node node) {
            BeanDefinitionBuilder networkConfigBuilder = this.createBeanBuilder(NetworkConfig.class, "networkConfig");
            AbstractBeanDefinition beanDefinition = networkConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, this.configBuilder, null);
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String nodeName = this.cleanNodeName(child);
                if ("join".equals(nodeName)) {
                    this.handleJoin(child, networkConfigBuilder);
                    continue;
                }
                if ("interfaces".equals(nodeName)) {
                    this.handleInterfaces(child, networkConfigBuilder);
                    continue;
                }
                if ("symmetric-encryption".equals(nodeName)) {
                    this.handleSymmetricEncryption(child, networkConfigBuilder);
                    continue;
                }
                if (!"asymmetric-encryption".equals(nodeName)) continue;
                this.handleAsymmetricEncryption(child, networkConfigBuilder);
            }
            this.configBuilder.addPropertyValue("networkConfig", (Object)beanDefinition);
        }

        protected void handleViaReflection(Node child) {
            Method method;
            String methodName = this.xmlToJavaName("handle-" + this.cleanNodeName(child));
            try {
                method = this.getClass().getMethod(methodName, Node.class);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                return;
            }
            try {
                method.invoke((Object)this, child);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void handleGroup(Node node) {
            this.createAndFillBeanBuilder(node, GroupConfig.class, "groupConfig", this.configBuilder, new String[0]);
        }

        public void handleProperties(Node node) {
            this.handleProperties(node, this.configBuilder);
        }

        public void handleInterfaces(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(Interfaces.class, "interfaces");
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            NamedNodeMap atts = node.getAttributes();
            if (atts != null) {
                for (int a = 0; a < atts.getLength(); ++a) {
                    Node att = atts.item(a);
                    String name = this.xmlToJavaName(att.getNodeName());
                    String value = att.getNodeValue();
                    builder.addPropertyValue(name, (Object)value);
                }
            }
            ManagedList interfacesSet = new ManagedList();
            for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String name = this.xmlToJavaName(this.cleanNodeName(n));
                String value = this.getValue(n);
                if (!"interface".equals(name)) continue;
                interfacesSet.add((Object)value);
            }
            builder.addPropertyValue("interfaces", (Object)interfacesSet);
            networkConfigBuilder.addPropertyValue("interfaces", (Object)beanDefinition);
        }

        public void handleJoin(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            BeanDefinitionBuilder joinConfigBuilder = this.createBeanBuilder(Join.class, "join");
            AbstractBeanDefinition beanDefinition = joinConfigBuilder.getBeanDefinition();
            for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node, 1)) {
                String name = this.cleanNodeName(child);
                if ("multicast".equals(name)) {
                    this.handleMulticast(child, joinConfigBuilder);
                    continue;
                }
                if ("tcp-ip".equals(name)) {
                    this.handleTcpIp(child, joinConfigBuilder);
                    continue;
                }
                if (!"aws".equals(name)) continue;
                this.handleAws(child, joinConfigBuilder);
            }
            networkConfigBuilder.addPropertyValue("join", (Object)beanDefinition);
        }

        public void handleAsymmetricEncryption(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            this.createAndFillBeanBuilder(node, AsymmetricEncryptionConfig.class, "asymmetricEncryptionConfig", networkConfigBuilder, new String[0]);
        }

        public void handleSymmetricEncryption(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            this.createAndFillBeanBuilder(node, SymmetricEncryptionConfig.class, "symmetricEncryptionConfig", networkConfigBuilder, new String[0]);
        }

        public void handleExecutor(Node node) {
            this.createAndFillListedBean(node, ExecutorConfig.class, "executorConfig", this.executorManagedMap);
        }

        public void handleMulticast(Node node, BeanDefinitionBuilder joinConfigBuilder) {
            this.createAndFillBeanBuilder(node, MulticastConfig.class, "multicastConfig", joinConfigBuilder, new String[0]);
        }

        public void handleTcpIp(Node node, BeanDefinitionBuilder joinConfigBuilder) {
            BeanDefinitionBuilder builder = this.createAndFillBeanBuilder(node, TcpIpConfig.class, "tcpIpConfig", joinConfigBuilder, "interface", "member", "members");
            ManagedList members = new ManagedList();
            for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                String name = this.xmlToJavaName(SpringXmlConfigBuilder.cleanNodeName(n.getNodeName()));
                if (!"member".equals(name) && !"members".equals(name) && !"interface".equals(name)) continue;
                String value = this.getValue(n);
                members.add((Object)value);
            }
            builder.addPropertyValue("members", (Object)members);
        }

        public void handleAws(Node node, BeanDefinitionBuilder joinConfigBuilder) {
            this.createAndFillBeanBuilder(node, AwsConfig.class, "awsConfig", joinConfigBuilder, new String[0]);
        }

        public void handleQueue(Node node) {
            this.createAndFillListedBean(node, QueueConfig.class, "queueConfig", this.queueManagedMap);
        }

        public void handleMap(Node node) {
            BeanDefinitionBuilder mapConfigBuilder = this.createBeanBuilder(MapConfig.class, "mapConfig");
            AbstractBeanDefinition beanDefinition = mapConfigBuilder.getBeanDefinition();
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getValue(attName);
            mapConfigBuilder.addPropertyValue("name", (Object)name);
            this.fillValues(node, mapConfigBuilder, "mapStore", "nearCache");
            for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                String nname = SpringXmlConfigBuilder.cleanNodeName(n.getNodeName());
                if ("map-store".equals(nname)) {
                    this.handleMapStoreConfig(n, mapConfigBuilder);
                    continue;
                }
                if ("near-cache".equals(nname)) {
                    this.handleNearCacheConfig(n, mapConfigBuilder);
                    continue;
                }
                if (!"wan-replication-ref".equals(nname)) continue;
                BeanDefinitionBuilder wanReplicationRefBuilder = this.createBeanBuilder(WanReplicationRef.class, "wanReplicationRef");
                AbstractBeanDefinition wanReplicationRefBeanDefinition = wanReplicationRefBuilder.getBeanDefinition();
                this.fillValues(n, wanReplicationRefBuilder, new String[0]);
                mapConfigBuilder.addPropertyValue("wanReplicationRef", (Object)wanReplicationRefBeanDefinition);
            }
            this.mapConfigManagedMap.put((Object)name, (Object)beanDefinition);
            mapConfigBuilder = null;
        }

        public void handleWanReplication(Node node) {
            BeanDefinitionBuilder wanRepConfigBuilder = this.createBeanBuilder(WanReplicationConfig.class, "wanReplicationConfig");
            AbstractBeanDefinition beanDefinition = wanRepConfigBuilder.getBeanDefinition();
            Node attName = node.getAttributes().getNamedItem("name");
            String name = this.getValue(attName);
            wanRepConfigBuilder.addPropertyValue("name", (Object)name);
            ManagedList targetClusters = new ManagedList();
            for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                String nName = this.cleanNodeName(n);
                if (!"target-cluster".equals(nName)) continue;
                BeanDefinitionBuilder targetClusterConfigBuilder = this.createBeanBuilder(WanTargetClusterConfig.class, "targetClusterConfig");
                AbstractBeanDefinition childBeanDefinition = targetClusterConfigBuilder.getBeanDefinition();
                this.fillAttributeValues(n, targetClusterConfigBuilder, Collections.EMPTY_LIST);
                for (Node childNode : new AbstractXmlConfigHelper.IterableNodeList(n.getChildNodes(), 1)) {
                    String childNodeName = this.cleanNodeName(childNode);
                    if ("replication-impl".equals(childNodeName)) {
                        targetClusterConfigBuilder.addPropertyValue(this.xmlToJavaName(childNodeName), (Object)this.getValue(childNode));
                        continue;
                    }
                    if ("replication-impl-object".equals(childNodeName)) {
                        Node refName = childNode.getAttributes().getNamedItem("ref");
                        targetClusterConfigBuilder.addPropertyReference(this.xmlToJavaName(childNodeName), this.getValue(refName));
                        continue;
                    }
                    if (!"end-points".equals(childNodeName)) continue;
                    ManagedList addresses = new ManagedList();
                    for (Node addressNode : new AbstractXmlConfigHelper.IterableNodeList(childNode.getChildNodes(), 1)) {
                        if (!"address".equals(this.cleanNodeName(addressNode))) continue;
                        addresses.add((Object)this.getValue(addressNode));
                    }
                    targetClusterConfigBuilder.addPropertyValue("endpoints", (Object)addresses);
                }
                targetClusters.add((Object)childBeanDefinition);
            }
            wanRepConfigBuilder.addPropertyValue("targetClusterConfigs", (Object)targetClusters);
            this.wanReplicationManagedMap.put((Object)name, (Object)beanDefinition);
        }

        public void handleNearCacheConfig(Node node, BeanDefinitionBuilder mapConfigBuilder) {
            BeanDefinitionBuilder nearCacheConfigBuilder = this.createBeanBuilder(NearCacheConfig.class, "nearCacheConfig");
            AbstractBeanDefinition beanDefinition = nearCacheConfigBuilder.getBeanDefinition();
            this.fillValues(node, nearCacheConfigBuilder, new String[0]);
            mapConfigBuilder.addPropertyValue("nearCacheConfig", (Object)beanDefinition);
            nearCacheConfigBuilder = null;
        }

        public void handleMapStoreConfig(Node node, BeanDefinitionBuilder mapConfigBuilder) {
            BeanDefinitionBuilder mapStoreConfigBuilder = this.createBeanBuilder(MapStoreConfig.class, "mapStoreConfig");
            AbstractBeanDefinition beanDefinition = mapStoreConfigBuilder.getBeanDefinition();
            String implAttrName = "implementation";
            String factoryImplAttrName = "factory-implementation";
            this.fillValues(node, mapStoreConfigBuilder, "implementation", "factory-implementation");
            this.handleProperties(node, mapStoreConfigBuilder);
            NamedNodeMap attrs = node.getAttributes();
            Node implRef = attrs.getNamedItem("implementation");
            Node factoryImplRef = attrs.getNamedItem("factory-implementation");
            if (factoryImplRef != null) {
                mapStoreConfigBuilder.addPropertyReference(this.xmlToJavaName("factory-implementation"), this.getValue(factoryImplRef));
            }
            if (implRef != null) {
                mapStoreConfigBuilder.addPropertyReference(this.xmlToJavaName("implementation"), this.getValue(implRef));
            }
            mapConfigBuilder.addPropertyValue("mapStoreConfig", (Object)beanDefinition);
            mapStoreConfigBuilder = null;
        }

        public void handleProperties(Node node, BeanDefinitionBuilder beanDefinitionBuilder) {
            ManagedMap properties = new ManagedMap();
            for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                String name = SpringXmlConfigBuilder.cleanNodeName(n.getNodeName());
                if (!"property".equals(name)) continue;
                String propertyName = this.getTextContent(n.getAttributes().getNamedItem("name")).trim();
                String value = this.getValue(n);
                properties.put((Object)propertyName, (Object)value);
            }
            beanDefinitionBuilder.addPropertyValue("properties", (Object)properties);
        }

        public void handleTopic(Node node) {
            this.createAndFillListedBean(node, TopicConfig.class, "topicConfig", this.topicManagedMap);
        }

        public void handleMergePolicies(Node node) {
            String implAttr = "implementation";
            for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes(), 1)) {
                if (!"map-merge-policy".equals(this.cleanNodeName(n))) continue;
                BeanDefinitionBuilder mergePolicyConfigBuilder = this.createBeanBuilder(MergePolicyConfig.class, "mergePolicyConfig");
                AbstractBeanDefinition beanDefinition = mergePolicyConfigBuilder.getBeanDefinition();
                this.fillValues(n, mergePolicyConfigBuilder, "implementation");
                Node impl = n.getAttributes().getNamedItem("implementation");
                if ("implementation" != null) {
                    mergePolicyConfigBuilder.addPropertyReference("implementation", this.getValue(impl));
                }
                String name = this.getValue(n.getAttributes().getNamedItem("name"));
                this.mergePolicyConfigMap.put((Object)name, (Object)beanDefinition);
            }
        }
    }
}

