/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.ascii.rest;

import com.hazelcast.impl.ascii.AbstractTextCommand;
import com.hazelcast.impl.ascii.TextCommandConstants;
import com.hazelcast.nio.IOUtil;
import java.nio.ByteBuffer;

public abstract class HttpCommand
extends AbstractTextCommand {
    public static final String HEADER_CONTENT_TYPE = "content-type: ";
    public static final String HEADER_CONTENT_LENGTH = "content-length: ";
    public static final String HEADER_CHUNKED = "transfer-encoding: chunked";
    public static final String HEADER_EXPECT_100 = "expect: 100";
    protected final String uri;
    protected ByteBuffer response;
    public static final byte[] RES_200 = "HTTP/1.1 200 OK\r\n".getBytes();
    public static final byte[] RES_400 = "HTTP/1.1 400 Bad Request\r\nContent-Length: 0\r\n\r\n".getBytes();
    public static final byte[] RES_404 = "HTTP/1.1 404 Not Found\r\n\r\n".getBytes();
    public static final byte[] RES_100 = "HTTP/1.1 100 Continue\r\n\r\n".getBytes();
    public static final byte[] RES_204 = "HTTP/1.1 204 No Content\r\nContent-Length: 0\r\n\r\n".getBytes();
    public static final byte[] RES_503 = "HTTP/1.1 503 Service Unavailable\r\nContent-Length: 0\r\n\r\n".getBytes();
    public static final byte[] RES_505 = "HTTP/1.1 505 Internal Server Error\r\nContent-Length: 0\r\n\r\n".getBytes();
    public static final byte[] CONTENT_TYPE = "Content-Type: ".getBytes();
    public static final byte[] CONTENT_LENGTH = "Content-Length: ".getBytes();
    public static final byte[] CONTENT_TYPE_PLAIN_TEXT = "text/plain".getBytes();

    public HttpCommand(TextCommandConstants.TextCommandType type, String uri) {
        super(type);
        this.uri = uri;
    }

    public boolean shouldReply() {
        return true;
    }

    public String getURI() {
        return this.uri;
    }

    public void send204() {
        this.response = ByteBuffer.wrap(RES_204);
    }

    public void send400() {
        this.response = ByteBuffer.wrap(RES_400);
    }

    public void setResponse(byte[] value) {
        this.response = ByteBuffer.wrap(value);
    }

    public void setResponse(byte[] contentType, byte[] value) {
        int valueSize = value == null ? 0 : value.length;
        byte[] len = String.valueOf(valueSize).getBytes();
        int size = RES_200.length;
        if (contentType != null) {
            size += CONTENT_TYPE.length;
            size += contentType.length;
            size += RETURN.length;
        }
        size += CONTENT_LENGTH.length;
        size += len.length;
        size += RETURN.length;
        size += RETURN.length;
        size += valueSize;
        this.response = ByteBuffer.allocate(size += RETURN.length);
        this.response.put(RES_200);
        if (contentType != null) {
            this.response.put(CONTENT_TYPE);
            this.response.put(contentType);
            this.response.put(RETURN);
        }
        this.response.put(CONTENT_LENGTH);
        this.response.put(len);
        this.response.put(RETURN);
        this.response.put(RETURN);
        if (value != null) {
            this.response.put(value);
        }
        this.response.put(RETURN);
        this.response.flip();
    }

    public boolean writeTo(ByteBuffer bb) {
        IOUtil.copyToHeapBuffer(this.response, bb);
        return !this.response.hasRemaining();
    }

    public String toString() {
        return "HttpCommand [" + (Object)((Object)this.type) + "]{" + "uri='" + this.uri + '\'' + '}' + super.toString();
    }
}

