/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.instance;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Settings;
import org.hibernate.classic.Session;
import org.hibernate.engine.SessionFactoryImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HazelcastAccessor {
    static final ILogger logger = Logger.getLogger(HazelcastAccessor.class.getName());
    static final String METHOD_GET_REGION_FACTORY = "getRegionFactory";
    static final String METHOD_GET_CACHE_PROVIDER = "getCacheProvider";
    private static final String CLASS_CACHE_PROVIDER_ACCESSOR = "com.hazelcast.hibernate.instance.CacheProviderHazelcastAccessor";
    private static final String CLASS_REGION_FACTORY_ACCESSOR = "com.hazelcast.hibernate.instance.RegionFactoryHazelcastAccessor";
    private static final AtomicReference<HazelcastAccessor> OLD_HIBERNATE_ACCESSOR = new AtomicReference();
    private static final AtomicReference<HazelcastAccessor> HIBERNATE_ACCESSOR = new AtomicReference();

    public static HazelcastInstance getHazelcastInstance(Session session) {
        return HazelcastAccessor.getHazelcastInstance(session.getSessionFactory());
    }

    public static HazelcastInstance getHazelcastInstance(SessionFactory sessionFactory) {
        if (!(sessionFactory instanceof SessionFactoryImplementor)) {
            logger.log(Level.WARNING, "SessionFactory is expected to be instance of SessionFactoryImplementor.");
            return null;
        }
        return HazelcastAccessor.getHazelcastInstance((SessionFactoryImplementor)sessionFactory);
    }

    public static HazelcastInstance getHazelcastInstance(SessionFactoryImplementor sessionFactory) {
        boolean oldHibernateVersion = false;
        try {
            sessionFactory.getSettings().getClass().getMethod(METHOD_GET_REGION_FACTORY, new Class[0]);
        }
        catch (NoSuchMethodException ignore) {
            oldHibernateVersion = true;
        }
        try {
            HazelcastAccessor accessor = oldHibernateVersion ? HazelcastAccessor.getAccessor(OLD_HIBERNATE_ACCESSOR, CLASS_CACHE_PROVIDER_ACCESSOR) : HazelcastAccessor.getAccessor(HIBERNATE_ACCESSOR, CLASS_REGION_FACTORY_ACCESSOR);
            return accessor.getHazelcastInstance(sessionFactory.getSettings());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    private static HazelcastAccessor getAccessor(AtomicReference<HazelcastAccessor> ref, String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        HazelcastAccessor accessor = ref.get();
        if (accessor == null) {
            ClassLoader cl = HazelcastAccessor.class.getClassLoader();
            accessor = (HazelcastAccessor)cl.loadClass(className).newInstance();
            ref.set(accessor);
        }
        return accessor;
    }

    HazelcastAccessor() {
    }

    abstract HazelcastInstance getHazelcastInstance(Settings var1);
}

