/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.config.MapConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.MapEntry;
import com.hazelcast.core.Member;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.Keys;
import com.hazelcast.impl.ListenerManager;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.Request;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.TransactionImpl;
import com.hazelcast.impl.base.PacketProcessor;
import com.hazelcast.impl.base.RuntimeInterruptedException;
import com.hazelcast.impl.base.ScheduledAction;
import com.hazelcast.impl.monitor.LocalQueueStatsImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingQueueManager
extends BaseManager {
    private static final long BILLION = 1000000000L;
    boolean addKeyAsync = false;
    final Map<String, BQ> mapBQ = new HashMap<String, BQ>();

    BlockingQueueManager(Node node) {
        super(node);
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_ITERATE, new InitializationAwareOperationHandler(){

            void doOperation(BQ queue, Request request) {
                queue.iterate(request);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_SIZE, new InitializationAwareOperationHandler(){

            void doOperation(BQ queue, Request request) {
                queue.size(request);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_GET_KEY_BY_INDEX, new InitializationAwareOperationHandler(){

            public void doOperation(BQ queue, Request request) {
                queue.doGetKeyByIndex(request);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_GET_INDEX_BY_KEY, new InitializationAwareOperationHandler(){

            public void doOperation(BQ queue, Request request) {
                queue.doGetIndexByKey(request);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_TAKE_KEY, new InitializationAwareOperationHandler(){

            public void doOperation(BQ queue, Request request) {
                queue.doTakeKey(request);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_CANCEL_TAKE_KEY, new InitializationAwareOperationHandler(){

            public void doOperation(BQ queue, Request request) {
                queue.cancelTakeKey(request);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_SET, new InitializationAwareOperationHandler(){

            public void doOperation(BQ queue, Request request) {
                queue.doSet(request);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_PEEK_KEY, new BaseManager.ResponsiveOperationHandler(){

            public void handle(Request request) {
                BlockingQueueManager.this.handlePeekKey(request);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_ADD_KEY, new BaseManager.ResponsiveOperationHandler(){

            public void handle(Request request) {
                BlockingQueueManager.this.handleAddKey(request);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_REMOVE_KEY, new InitializationAwareOperationHandler(){

            void doOperation(BQ queue, Request request) {
                queue.removeKey(request);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_GENERATE_KEY, new BaseManager.ResponsiveOperationHandler(){

            public void handle(Request request) {
                BlockingQueueManager.this.handleGenerateKey(request);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_OFFER_KEY, new PacketProcessor(){

            public void process(Packet packet) {
                BlockingQueueManager.this.handleOfferKey(packet);
            }
        });
    }

    public void destroy(String name) {
        this.mapBQ.remove(name);
    }

    private void sendKeyToMaster(final String queueName, final Data key, final int index) {
        this.enqueueAndReturn(new Processable(){

            public void process() {
                if (BlockingQueueManager.this.isMaster()) {
                    BlockingQueueManager.this.doAddKey(queueName, key, index);
                } else {
                    Packet packet = BlockingQueueManager.this.obtainPacket();
                    packet.name = queueName;
                    packet.setKey(key);
                    packet.operation = ClusterOperation.BLOCKING_OFFER_KEY;
                    packet.longValue = index;
                    boolean bl = BlockingQueueManager.this.send(packet, BlockingQueueManager.this.getMasterAddress());
                }
            }
        });
    }

    public int size(String name) {
        ThreadContext threadContext = ThreadContext.get();
        TransactionImpl txn = threadContext.getCallContext().getTransaction();
        int size = this.queueSize(name);
        if (txn != null && txn.getStatus() == 1) {
            size += txn.size(name);
        }
        return size;
    }

    public boolean remove(String name, Object obj) {
        Set<Long> keys = this.getValueKeys(name, IOUtil.toData(obj));
        if (keys != null) {
            for (Long key : keys) {
                Data keyData = IOUtil.toData(key);
                if (!this.removeKey(name, keyData)) continue;
                try {
                    this.getStorageMap(name).tryRemove(keyData, 0L, TimeUnit.SECONDS);
                }
                catch (TimeoutException ignored) {
                    // empty catch block
                }
                return true;
            }
        }
        return false;
    }

    public boolean add(String name, Object obj, int index) {
        try {
            return this.offer(name, obj, index, 0L);
        }
        catch (InterruptedException ignored) {
            return false;
        }
    }

    public boolean offer(String name, Object obj, long timeout) throws InterruptedException {
        return this.offer(name, obj, Integer.MAX_VALUE, timeout);
    }

    public boolean offer(String name, Object obj, int index, long timeout) throws InterruptedException {
        Long key = this.generateKey(name, timeout);
        ThreadContext threadContext = ThreadContext.get();
        TransactionImpl txn = threadContext.getCallContext().getTransaction();
        if (key != -1L) {
            if (txn != null && txn.getStatus() == 1) {
                txn.attachPutOp(name, key, obj, timeout, true);
            } else {
                this.storeQueueItem(name, key, obj, index);
            }
            return true;
        }
        return false;
    }

    public Object set(String name, Object newValue, int index) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        Data key = this.getKeyByIndex(name, index);
        if (key == null) {
            throw new IndexOutOfBoundsException();
        }
        IMap imap = this.getStorageMap(name);
        return imap.put(key, newValue);
    }

    public Object remove(String name, int index) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        Data key = null;
        try {
            key = this.takeKey(name, index, 0L);
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
        if (key == null) {
            throw new IndexOutOfBoundsException();
        }
        IMap imap = this.getStorageMap(name);
        try {
            return imap.tryRemove(key, 0L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    public void offerCommit(String name, Object key, Object obj) {
        this.storeQueueItem(name, key, obj, Integer.MAX_VALUE);
    }

    public void rollbackPoll(String name, Object key, Object obj) {
        Data dataKey = IOUtil.toData(key);
        if (this.addKeyAsync) {
            this.sendKeyToMaster(name, dataKey, 0);
        } else {
            this.addKey(name, dataKey, 0);
        }
    }

    private void storeQueueItem(String name, Object key, Object obj, int index) {
        IMap imap = this.getStorageMap(name);
        Data dataKey = IOUtil.toData(key);
        imap.put(dataKey, obj);
        if (this.addKeyAsync) {
            this.sendKeyToMaster(name, dataKey, index);
        } else {
            this.addKey(name, dataKey, index);
        }
    }

    public Object poll(String name, long timeout) throws InterruptedException {
        if (timeout == -1L) {
            timeout = Long.MAX_VALUE;
        }
        Object removedItem = null;
        long start = System.currentTimeMillis();
        while (removedItem == null && timeout >= 0L) {
            Data key = this.takeKey(name, timeout);
            if (key == null) {
                return null;
            }
            IMap imap = this.getStorageMap(name);
            try {
                ThreadContext threadContext;
                TransactionImpl txn;
                removedItem = imap.tryRemove(key, 0L, TimeUnit.MILLISECONDS);
                if (removedItem != null && (txn = (threadContext = ThreadContext.get()).getCallContext().getTransaction()) != null && txn.getStatus() == 1) {
                    txn.attachRemoveOp(name, key, removedItem, true);
                }
            }
            catch (TimeoutException e) {
                // empty catch block
            }
            long now = System.currentTimeMillis();
            timeout -= now - start;
            start = now;
        }
        return removedItem;
    }

    public Object peek(String name) {
        Data key = this.peekKey(name);
        if (key == null) {
            return null;
        }
        IMap imap = this.getStorageMap(name);
        return imap.get(key);
    }

    private Data takeKey(String name, long timeout) throws InterruptedException {
        return this.takeKey(name, -1, timeout);
    }

    private Data takeKey(String name, int index, long timeout) throws InterruptedException {
        try {
            MasterOp op = new MasterOp(ClusterOperation.BLOCKING_TAKE_KEY, name, timeout);
            op.request.longValue = index;
            op.request.txnId = ThreadContext.get().getThreadId();
            op.initOp();
            return (Data)op.getResultAsIs();
        }
        catch (Exception e) {
            if (e instanceof RuntimeInterruptedException) {
                MasterOp op = new MasterOp(ClusterOperation.BLOCKING_CANCEL_TAKE_KEY, name, timeout);
                op.request.longValue = index;
                op.request.txnId = ThreadContext.get().getThreadId();
                op.initOp();
                throw new InterruptedException();
            }
            return null;
        }
    }

    int getIndexOf(String name, Object obj, boolean first) {
        Set<Long> keys = this.getValueKeys(name, IOUtil.toData(obj));
        if (keys == null || keys.size() == 0) {
            return -1;
        }
        Long key = null;
        key = first ? keys.iterator().next() : (Long)keys.toArray()[keys.size() - 1];
        return this.getIndexByKey(name, IOUtil.toData(key));
    }

    Set<Long> getValueKeys(String name, Data item) {
        while (true) {
            this.node.checkNodeState();
            try {
                return this.doGetValueKeys(name, item);
            }
            catch (Throwable e) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                }
                continue;
            }
            break;
        }
    }

    Set<Long> doGetValueKeys(String name, Data item) throws ExecutionException, InterruptedException {
        Set<Member> members = this.node.getClusterImpl().getMembers();
        ArrayList<DistributedTask<Keys>> lsFutures = new ArrayList<DistributedTask<Keys>>(members.size());
        for (Member member : members) {
            GetValueKeysCallable getValueKeysCallable = new GetValueKeysCallable(name, item);
            DistributedTask<Keys> dt = new DistributedTask<Keys>(getValueKeysCallable, member);
            lsFutures.add(dt);
            this.node.factory.getExecutorService().execute(dt);
        }
        TreeSet<Long> foundKeys = new TreeSet<Long>();
        for (Future future : lsFutures) {
            Keys keys = (Keys)future.get();
            if (keys == null) continue;
            for (Data keyData : keys.getKeys()) {
                foundKeys.add((Long)IOUtil.toObject(keyData));
            }
        }
        return foundKeys;
    }

    Object getItemByIndex(String name, int index) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        Data key = this.getKeyByIndex(name, index);
        if (key == null) {
            throw new IndexOutOfBoundsException();
        }
        IMap imap = this.getStorageMap(name);
        return imap.get(key);
    }

    private Data getKeyByIndex(String name, int index) {
        MasterOp op = new MasterOp(ClusterOperation.BLOCKING_GET_KEY_BY_INDEX, name, 0L);
        op.request.longValue = index;
        op.initOp();
        return (Data)op.getResultAsIs();
    }

    private Integer getIndexByKey(String name, Data keyData) {
        MasterOp op = new MasterOp(ClusterOperation.BLOCKING_GET_INDEX_BY_KEY, name, 0L);
        op.request.key = keyData;
        op.initOp();
        return (Integer)op.getResultAsObject();
    }

    private Data peekKey(String name) {
        MasterOp op = new MasterOp(ClusterOperation.BLOCKING_PEEK_KEY, name, 0L);
        op.initOp();
        return (Data)op.getResultAsIs();
    }

    public IMap getStorageMap(String queueName) {
        return this.node.factory.getMap(queueName);
    }

    CMap getStorageCMap(String queueName) {
        return this.node.concurrentMapManager.getMap("c:" + queueName);
    }

    CMap getOrCreateStorageCMap(String queueName) {
        return this.node.concurrentMapManager.getOrCreateMap("c:" + queueName);
    }

    public Iterator iterate(final String name) {
        MasterOp op = new MasterOp(ClusterOperation.BLOCKING_ITERATE, name, 0L);
        op.initOp();
        Keys keys = (Keys)op.getResultAsObject();
        Collection<Data> dataKeys = keys.getKeys();
        ArrayList<Data> allKeys = new ArrayList<Data>(dataKeys);
        TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
        Map txnOfferItems = null;
        if (txn != null && (txnOfferItems = txn.newKeys(name)) != null) {
            allKeys.addAll(txnOfferItems.keySet());
        }
        final Map txnMap = txnOfferItems;
        final Iterator it = allKeys.iterator();
        final IMap imap = this.getStorageMap(name);
        return new Iterator(){
            Object key = null;
            Object next = null;
            boolean hasNext = false;
            boolean set = false;

            public boolean hasNext() {
                if (!this.set) {
                    this.set();
                }
                boolean result = this.hasNext;
                this.hasNext = false;
                this.set = false;
                return result;
            }

            public Object next() {
                if (!this.set) {
                    this.set();
                }
                Object result = this.next;
                this.set = false;
                this.next = null;
                return result;
            }

            public void remove() {
                if (this.key != null) {
                    try {
                        Data dataKey = IOUtil.toData(this.key);
                        imap.tryRemove(dataKey, 0L, TimeUnit.MILLISECONDS);
                        BlockingQueueManager.this.removeKey(name, dataKey);
                    }
                    catch (TimeoutException timeoutException) {
                        // empty catch block
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void set() {
                try {
                    while (this.next == null) {
                        this.hasNext = it.hasNext();
                        if (this.hasNext) {
                            this.key = it.next();
                            if (txnMap != null) {
                                this.next = txnMap.get(this.key);
                            }
                            if (this.next != null) continue;
                            this.next = imap.get(this.key);
                            continue;
                        }
                        return;
                    }
                }
                finally {
                    this.set = true;
                }
            }
        };
    }

    public boolean addKey(String name, Data key, int index) {
        MasterOp op = new MasterOp(ClusterOperation.BLOCKING_ADD_KEY, name, 0L);
        op.request.key = key;
        op.request.setBooleanRequest();
        op.request.longValue = index;
        op.initOp();
        return op.getResultAsBoolean();
    }

    public Data set(String name, Data key, int index) {
        MasterOp op = new MasterOp(ClusterOperation.BLOCKING_SET, name, 0L);
        op.request.key = key;
        op.request.setBooleanRequest();
        op.request.longValue = index;
        op.initOp();
        return (Data)op.getResultAsIs();
    }

    public boolean removeKey(String name, Data key) {
        MasterOp op = new MasterOp(ClusterOperation.BLOCKING_REMOVE_KEY, name, 0L);
        op.request.key = key;
        op.request.setBooleanRequest();
        op.initOp();
        return op.getResultAsBoolean();
    }

    public long generateKey(String name, long timeout) throws InterruptedException {
        try {
            MasterOp op = new MasterOp(ClusterOperation.BLOCKING_GENERATE_KEY, name, timeout);
            op.request.setLongRequest();
            op.request.txnId = ThreadContext.get().getThreadId();
            op.initOp();
            return (Long)op.getResultAsObject();
        }
        catch (Exception e) {
            if (e instanceof RuntimeInterruptedException) {
                throw new InterruptedException();
            }
            return -1L;
        }
    }

    public int queueSize(String name) {
        MasterOp op = new MasterOp(ClusterOperation.BLOCKING_SIZE, name, 0L);
        op.request.setLongRequest();
        op.initOp();
        return ((Long)op.getResultAsObject()).intValue();
    }

    long getKey(String queueName) {
        return this.node.factory.getIdGenerator(queueName).newId();
    }

    BQ getOrCreateBQ(String name) {
        BQ bq = this.mapBQ.get(name);
        if (bq == null) {
            bq = new BQ(name);
            this.mapBQ.put(name, bq);
        }
        return bq;
    }

    final void handlePeekKey(Request req) {
        if (this.isMaster() && this.ready(req)) {
            BQ bq = this.getOrCreateBQ(req.name);
            bq.doPeekKey(req);
        } else {
            this.returnRedoResponse(req);
        }
    }

    final void handleOfferKey(Packet packet) {
        if (this.isMaster()) {
            this.doAddKey(packet.name, packet.getKeyData(), (int)packet.longValue);
        }
        this.releasePacket(packet);
    }

    final void doAddKey(String name, Data key, int index) {
        BQ bq = this.getOrCreateBQ(name);
        bq.doAddKey(key, index);
    }

    final void handleAddKey(Request req) {
        if (this.isMaster() && this.ready(req)) {
            BQ bq = this.getOrCreateBQ(req.name);
            bq.doAddKey(req.key, (int)req.longValue);
            req.key = null;
            req.response = Boolean.TRUE;
            this.returnResponse(req);
        } else {
            this.returnRedoResponse(req);
        }
    }

    final void handleGenerateKey(Request req) {
        if (this.isMaster() && this.ready(req)) {
            BQ bq = this.getOrCreateBQ(req.name);
            bq.doGenerateKey(req);
        } else {
            this.returnRedoResponse(req);
        }
    }

    boolean ready(Request request) {
        BQ q = this.getOrCreateBQ(request.name);
        if (q.state == MasterState.READY) {
            return true;
        }
        if (q.state == MasterState.NOT_INITIALIZED) {
            q.state = MasterState.INITIALIZING;
            this.initialize(request.name);
        }
        return false;
    }

    void initialize(final String queueName) {
        final BQ q = this.getOrCreateBQ(queueName);
        final CMap cmapStorage = this.getOrCreateStorageCMap(queueName);
        this.executeLocally(new Runnable(){

            public void run() {
                Set keys;
                TreeSet itemKeys = null;
                if (cmapStorage.loader != null && (keys = cmapStorage.loader.loadAllKeys()) != null && keys.size() > 0) {
                    itemKeys = new TreeSet(keys);
                }
                if ((keys = BlockingQueueManager.this.getStorageMap(queueName).keySet()) != null && keys.size() > 0) {
                    if (itemKeys == null) {
                        itemKeys = new TreeSet(keys);
                    } else {
                        itemKeys.addAll(keys);
                    }
                }
                if (itemKeys != null) {
                    final TreeSet queueKeys = itemKeys;
                    BlockingQueueManager.this.enqueueAndReturn(new Processable(){

                        public void process() {
                            for (Long key : queueKeys) {
                                Data keyData = IOUtil.toData(key);
                                if (!q.keys.add(keyData)) continue;
                                q.queue.add(new QData(keyData));
                                q.nextKey = Math.max(q.nextKey, key);
                            }
                            q.nextKey += 1000000000L;
                            q.state = MasterState.READY;
                        }
                    });
                } else {
                    q.state = MasterState.READY;
                }
            }
        });
    }

    public void addItemListener(String name, ItemListener listener, boolean includeValue) {
        IMap map = this.getStorageMap(name);
        map.addEntryListener(new QueueItemListener(listener, includeValue), includeValue);
    }

    public void removeItemListener(String name, ItemListener listener) {
        List<ListenerManager.ListenerItem> lsListenerItems = this.node.listenerManager.getListeners();
        for (ListenerManager.ListenerItem listenerItem : lsListenerItems) {
            if (!(listenerItem.listener instanceof QueueItemListener)) continue;
            QueueItemListener queueListener = (QueueItemListener)listenerItem.listener;
            if (queueListener.itemListener != listener) continue;
            this.node.listenerManager.getListeners().remove(listenerItem);
            return;
        }
    }

    class QData {
        final Data data;
        final long createDate;

        QData(Data data) {
            this.data = data;
            this.createDate = System.currentTimeMillis();
        }
    }

    class BQ {
        final LinkedList<ScheduledAction> offerWaitList = new LinkedList();
        final LinkedList<PollAction> pollWaitList = new LinkedList();
        final LinkedList<Lease> leases = new LinkedList();
        final LinkedList<QData> queue = new LinkedList();
        final Set<Data> keys = new HashSet<Data>(1000);
        final int maxSizePerJVM;
        final long ttl;
        final String name;
        long nextKey = 0L;
        volatile MasterState state = MasterState.NOT_INITIALIZED;

        BQ(String name) {
            this.name = name;
            String shortName = name.substring("q:".length());
            QueueConfig qConfig = BlockingQueueManager.this.node.getConfig().findMatchingQueueConfig(shortName);
            MapConfig backingMapConfig = BlockingQueueManager.this.node.getConfig().findMatchingMapConfig(qConfig.getBackingMapRef());
            int backingMapTTL = backingMapConfig.getTimeToLiveSeconds();
            this.maxSizePerJVM = qConfig.getMaxSizePerJVM() == 0 ? Integer.MAX_VALUE : qConfig.getMaxSizePerJVM();
            this.ttl = backingMapTTL == 0 ? Integer.MAX_VALUE : TimeUnit.SECONDS.toMillis(backingMapTTL);
        }

        int maxSize() {
            return this.maxSizePerJVM == Integer.MAX_VALUE ? Integer.MAX_VALUE : this.maxSizePerJVM * BlockingQueueManager.this.lsMembers.size();
        }

        void doGenerateKey(Request req) {
            if (this.size() >= this.maxSize()) {
                if (req.hasEnoughTimeToSchedule()) {
                    this.addOfferAction(new OfferAction(req));
                } else {
                    req.response = -1L;
                    BlockingQueueManager.this.returnResponse(req);
                }
            } else {
                this.generateKeyAndLease(req);
                BlockingQueueManager.this.returnResponse(req);
            }
        }

        void size(Request req) {
            req.response = (long)this.queue.size();
            BlockingQueueManager.this.returnResponse(req);
        }

        void generateKeyAndLease(Request req) {
            this.leases.add(new Lease(req.caller));
            req.response = this.nextKey++;
        }

        void doSet(Request req) {
            int index = (int)req.longValue;
            Data key = req.key;
            Data oldKey = null;
            boolean added = false;
            if (this.queue.size() >= index) {
                this.queue.add(new QData(key));
                added = true;
            } else {
                QData old = this.queue.set(index, new QData(key));
                if (this.isValid(old, System.currentTimeMillis())) {
                    oldKey = old.data;
                } else {
                    added = true;
                }
            }
            if (added) {
                this.takeOne();
            }
            req.response = oldKey;
            BlockingQueueManager.this.returnResponse(req);
        }

        void doAddKey(Data key, int index) {
            if (this.keys.add(key)) {
                if (this.leases.size() > 0) {
                    this.leases.removeFirst();
                }
                if (index == Integer.MAX_VALUE || index >= this.queue.size()) {
                    this.queue.add(new QData(key));
                } else if (index == 0) {
                    this.queue.addFirst(new QData(key));
                } else {
                    this.queue.add(index, new QData(key));
                }
                this.takeOne();
            }
        }

        public void removeKey(Request request) {
            if (this.keys.remove(request.key)) {
                Iterator it = this.queue.iterator();
                while (it.hasNext()) {
                    QData qData = (QData)it.next();
                    if (!qData.data.equals(request.key)) continue;
                    it.remove();
                    request.response = Boolean.TRUE;
                    break;
                }
            }
            if (request.response == null) {
                request.response = Boolean.FALSE;
            }
            BlockingQueueManager.this.returnResponse(request);
        }

        void takeOne() {
            while (this.pollWaitList.size() > 0) {
                ScheduledAction scheduledActionPoll = this.pollWaitList.removeFirst();
                if (scheduledActionPoll.expired() || !scheduledActionPoll.isValid()) continue;
                scheduledActionPoll.consume();
                BlockingQueueManager.this.node.clusterManager.deregisterScheduledAction(scheduledActionPoll);
                return;
            }
        }

        void offerOne() {
            while (this.offerWaitList.size() > 0) {
                ScheduledAction scheduledActionOffer = this.offerWaitList.removeFirst();
                if (scheduledActionOffer.expired() || !scheduledActionOffer.isValid()) continue;
                scheduledActionOffer.consume();
                BlockingQueueManager.this.node.clusterManager.deregisterScheduledAction(scheduledActionOffer);
                return;
            }
        }

        QData pollValidItem() {
            QData qdata = this.queue.poll();
            if (qdata == null) {
                return null;
            }
            long now = System.currentTimeMillis();
            if (this.isValid(qdata, now)) {
                return qdata;
            }
            while (qdata != null) {
                qdata = this.queue.poll();
                if (!this.isValid(qdata, now)) continue;
                return qdata;
            }
            return qdata;
        }

        QData removeItemByIndex(int index) {
            if (index >= this.queue.size()) {
                return null;
            }
            return this.queue.remove(index);
        }

        boolean isValid(QData qdata, long now) {
            return qdata != null && now - qdata.createDate < this.ttl;
        }

        void cancelTakeKey(Request req) {
            this.cancelPollAction(req);
        }

        void doTakeKey(Request req) {
            QData qdata = req.longValue > 0L ? this.removeItemByIndex((int)req.longValue) : this.pollValidItem();
            if (qdata != null) {
                this.keys.remove(qdata.data);
                req.response = qdata.data;
                BlockingQueueManager.this.returnResponse(req);
                this.offerOne();
            } else if (req.hasEnoughTimeToSchedule()) {
                this.addPollAction(new PollAction(req));
            } else {
                req.response = null;
                BlockingQueueManager.this.returnResponse(req);
            }
        }

        void doGetIndexByKey(Request req) {
            Data keyData = req.key;
            int i = -1;
            for (QData qdata : this.queue) {
                if (qdata.data.equals(keyData)) {
                    ++i;
                    break;
                }
                ++i;
            }
            req.response = IOUtil.toData(i);
            BlockingQueueManager.this.returnResponse(req);
        }

        void doGetKeyByIndex(Request req) {
            int index = (int)req.longValue;
            long now = System.currentTimeMillis();
            int i = 0;
            QData key = null;
            for (QData qdata : this.queue) {
                if (!this.isValid(qdata, now)) continue;
                if (index == i) {
                    key = qdata;
                    break;
                }
                ++i;
            }
            req.response = key == null ? null : key.data;
            BlockingQueueManager.this.returnResponse(req);
        }

        void doPeekKey(Request req) {
            QData qdata = this.queue.peek();
            req.response = qdata == null ? null : qdata.data;
            BlockingQueueManager.this.returnResponse(req);
        }

        void addPollAction(PollAction pollAction) {
            this.pollWaitList.add(pollAction);
            BlockingQueueManager.this.node.clusterManager.registerScheduledAction(pollAction);
        }

        void cancelPollAction(Request req) {
            PollAction toCancel = null;
            for (PollAction pollAction : this.pollWaitList) {
                Request pReq = pollAction.getRequest();
                if (!pReq.caller.equals(req.caller) || pReq.longValue != req.longValue || pReq.txnId != req.txnId) continue;
                toCancel = pollAction;
            }
            if (toCancel != null) {
                this.pollWaitList.remove(toCancel);
                BlockingQueueManager.this.node.clusterManager.deregisterScheduledAction(toCancel);
            }
        }

        void addOfferAction(OfferAction offerAction) {
            this.offerWaitList.add(offerAction);
            BlockingQueueManager.this.node.clusterManager.registerScheduledAction(offerAction);
        }

        public int size() {
            return this.queue.size() + this.leases.size();
        }

        public void iterate(Request request) {
            Keys keys = new Keys();
            for (QData qData : this.queue) {
                keys.add(qData.data);
            }
            request.response = keys;
            BlockingQueueManager.this.returnResponse(request);
        }

        public int getMaxSizePerJVM() {
            return this.maxSizePerJVM;
        }

        public LocalQueueStatsImpl getQueueStats() {
            long now = System.currentTimeMillis();
            CMap cmap = BlockingQueueManager.this.getStorageCMap(this.name);
            IMap storageMap = BlockingQueueManager.this.getStorageMap(this.name);
            Set localKeys = storageMap.localKeySet();
            int total = cmap != null ? cmap.mapRecords.size() : 0;
            int ownedCount = localKeys.size();
            int backupCount = Math.abs(total - ownedCount);
            long minAge = Long.MAX_VALUE;
            long maxAge = Long.MIN_VALUE;
            long totalAge = 0L;
            for (Object localKey : localKeys) {
                MapEntry entry = storageMap.getMapEntry(localKey);
                if (entry == null) continue;
                long age = now - entry.getCreationTime();
                minAge = Math.min(minAge, age);
                maxAge = Math.max(maxAge, age);
                totalAge += age;
            }
            long aveAge = ownedCount == 0 ? 0L : totalAge / (long)ownedCount;
            return new LocalQueueStatsImpl(ownedCount, backupCount, minAge, maxAge, aveAge);
        }

        public class PollAction
        extends ScheduledAction {
            public PollAction(Request request) {
                super(request);
            }

            public boolean consume() {
                BQ.this.doTakeKey(this.request);
                this.setValid(false);
                return true;
            }

            public void onExpire() {
                this.request.response = null;
                BlockingQueueManager.this.returnResponse(this.request);
                this.setValid(false);
            }
        }

        public class OfferAction
        extends ScheduledAction {
            public OfferAction(Request request) {
                super(request);
            }

            public boolean consume() {
                BQ.this.generateKeyAndLease(this.request);
                BlockingQueueManager.this.returnResponse(this.request);
                this.setValid(false);
                return true;
            }

            public void onExpire() {
                this.request.response = -1L;
                BlockingQueueManager.this.returnResponse(this.request);
                this.setValid(false);
            }
        }
    }

    class QueueItemListener
    implements EntryListener {
        final ItemListener itemListener;
        final boolean includeValue;

        QueueItemListener(ItemListener itemListener, boolean includeValue) {
            this.itemListener = itemListener;
            this.includeValue = includeValue;
        }

        public void entryAdded(EntryEvent entryEvent) {
            Object item = this.includeValue ? (Object)entryEvent.getValue() : null;
            this.itemListener.itemAdded(item);
        }

        public void entryRemoved(EntryEvent entryEvent) {
            Object item = this.includeValue ? (Object)entryEvent.getValue() : null;
            this.itemListener.itemRemoved(item);
        }

        public void entryUpdated(EntryEvent entryEvent) {
        }

        public void entryEvicted(EntryEvent entryEvent) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MasterState {
        NOT_INITIALIZED,
        INITIALIZING,
        READY;

    }

    class Lease {
        final long timeout;
        final Address address;

        Lease(Address address) {
            this.address = address;
            this.timeout = System.currentTimeMillis() + 10000L;
        }
    }

    class MasterOp
    extends BaseManager.TargetAwareOp {
        private final ClusterOperation op;
        private final String name;
        private final long timeout;

        MasterOp(ClusterOperation op, String name, long timeout) {
            this.op = op;
            this.name = name;
            this.timeout = timeout;
        }

        public void setTarget() {
            this.target = BlockingQueueManager.this.getMasterAddress();
        }

        void initOp() {
            this.request.operation = this.op;
            this.request.name = this.name;
            this.request.timeout = this.timeout;
            this.doOp();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetValueKeysCallable
    implements Callable<Keys>,
    DataSerializable,
    HazelcastInstanceAware {
        HazelcastInstance hazelcast;
        Data item;
        String name;

        public GetValueKeysCallable() {
        }

        public GetValueKeysCallable(String name, Data item) {
            this.name = name;
            this.item = item;
        }

        @Override
        public Keys call() throws Exception {
            IMap imap = this.hazelcast.getMap(this.name);
            Set localKeys = imap.localKeySet();
            if (localKeys != null) {
                Object itemObject = IOUtil.toObject(this.item);
                Keys keys = new Keys();
                for (Object key : localKeys) {
                    Object v = imap.get(key);
                    if (v == null || !v.equals(itemObject)) continue;
                    keys.add(IOUtil.toData(key));
                }
                return keys;
            }
            return null;
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            out.writeUTF(this.name);
            this.item.writeData(out);
        }

        @Override
        public void readData(DataInput in) throws IOException {
            this.name = in.readUTF();
            this.item = new Data();
            this.item.readData(in);
        }

        @Override
        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            this.hazelcast = hazelcastInstance;
        }
    }

    abstract class InitializationAwareOperationHandler
    extends BaseManager.ResponsiveOperationHandler {
        InitializationAwareOperationHandler() {
        }

        abstract void doOperation(BQ var1, Request var2);

        public void handle(Request request) {
            if (BlockingQueueManager.this.isMaster() && BlockingQueueManager.this.ready(request)) {
                BQ bq = BlockingQueueManager.this.getOrCreateBQ(request.name);
                this.doOperation(bq, request);
            } else {
                BlockingQueueManager.this.returnRedoResponse(request);
            }
        }
    }
}

