/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.instance;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.instance.HazelcastAccessor;
import com.hazelcast.hibernate.provider.HazelcastCacheProvider;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cfg.Settings;

final class CacheProviderHazelcastAccessor
extends HazelcastAccessor {
    CacheProviderHazelcastAccessor() {
    }

    public HazelcastInstance getHazelcastInstance(Settings settings) {
        Object providerObject = null;
        try {
            Method getCacheProviderMethod = Settings.class.getMethod("getCacheProvider", new Class[0]);
            providerObject = getCacheProviderMethod.invoke((Object)settings, new Object[0]);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        CacheProvider provider = (CacheProvider)providerObject;
        if (provider == null) {
            logger.log(Level.SEVERE, "Hibernate 2nd level cache has not been enabled!");
            return null;
        }
        if (provider instanceof HazelcastCacheProvider) {
            return ((HazelcastCacheProvider)provider).getHazelcastInstance();
        }
        logger.log(Level.WARNING, "Current 2nd level cache implementation is not HazelcastCacheProvider!");
        return null;
    }
}

