/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws.utility;

import com.hazelcast.aws.utility.AwsURLEncoder;
import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.impl.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudyUtility {
    static final ILogger logger = Logger.getLogger(CloudyUtility.class.getName());

    public static String getQueryString(Map<String, String> attributes) {
        StringBuilder query = new StringBuilder();
        for (String key : attributes.keySet()) {
            String value = attributes.get(key);
            query.append(AwsURLEncoder.urlEncode(key)).append("=").append(AwsURLEncoder.urlEncode(value)).append("&");
        }
        String result = query.toString();
        if (result != null && !result.equals("")) {
            result = "?" + result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static Object unmarshalTheResponse(InputStream stream) throws IOException {
        Object o = CloudyUtility.parse(stream);
        return o;
    }

    private static Object parse(InputStream in) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(in);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Util.streamXML(doc, baos);
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            Element element = doc.getDocumentElement();
            NodeHolder elementNodeHolder = new NodeHolder(element);
            ArrayList<String> names = new ArrayList<String>();
            List<NodeHolder> reservationset = elementNodeHolder.getSubNodes("reservationset");
            for (NodeHolder reservation : reservationset) {
                List<NodeHolder> items = reservation.getSubNodes("item");
                for (NodeHolder item : items) {
                    NodeHolder instancesset = item.getSub("instancesset");
                    names.addAll(instancesset.getList("privateipaddress"));
                }
            }
            return names;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return new ArrayList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NodeHolder {
        Node node;

        public NodeHolder(Node node) {
            this.node = node;
        }

        public NodeHolder getSub(String name) {
            if (this.node != null) {
                for (Node node : new AbstractXmlConfigHelper.IterableNodeList(this.node.getChildNodes())) {
                    String nodeName = AbstractXmlConfigHelper.cleanNodeName(node.getNodeName());
                    if (!name.equals(nodeName)) continue;
                    return new NodeHolder(node);
                }
            }
            return new NodeHolder(null);
        }

        public List<NodeHolder> getSubNodes(String name) {
            ArrayList<NodeHolder> list = new ArrayList<NodeHolder>();
            if (this.node != null) {
                for (Node node : new AbstractXmlConfigHelper.IterableNodeList(this.node.getChildNodes())) {
                    String nodeName = AbstractXmlConfigHelper.cleanNodeName(node.getNodeName());
                    if (!name.equals(nodeName)) continue;
                    list.add(new NodeHolder(node));
                }
            }
            return list;
        }

        public List<String> getList(String name) {
            ArrayList<String> list = new ArrayList<String>();
            if (this.node != null) {
                for (Node node : new AbstractXmlConfigHelper.IterableNodeList(this.node.getChildNodes())) {
                    String ip;
                    String nodeName = AbstractXmlConfigHelper.cleanNodeName(node.getNodeName());
                    if (!"item".equals(nodeName) || !new NodeHolder(node).getSub("instancestate").getSub("name").getNode().getFirstChild().getNodeValue().equals("running") || (ip = new NodeHolder(node).getSub(name).getNode().getFirstChild().getNodeValue()) == null) continue;
                    list.add(ip);
                }
            }
            return list;
        }

        public Node getNode() {
            return this.node;
        }
    }
}

