/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.RemotelyProcessable;
import com.hazelcast.core.Instance;
import com.hazelcast.core.MapEntry;
import com.hazelcast.core.Member;
import com.hazelcast.impl.Block;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.Constants;
import com.hazelcast.impl.DataAwareEntryEvent;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.Keys;
import com.hazelcast.impl.MProxy;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.Request;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.base.AddressAwareException;
import com.hazelcast.impl.base.Call;
import com.hazelcast.impl.base.PacketProcessor;
import com.hazelcast.impl.base.RequestHandler;
import com.hazelcast.impl.base.RuntimeInterruptedException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.util.ResponseQueueFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseManager {
    protected static final boolean zeroBackup = false;
    protected final LinkedList<MemberImpl> lsMembers;
    protected final Map<Address, MemberImpl> mapMembers;
    protected final Queue<Packet> qServiceThreadPacketCache;
    protected final Map<Long, Call> mapCalls;
    protected final AtomicLong localIdGen;
    protected final Address thisAddress;
    protected final MemberImpl thisMember;
    protected final Node node;
    protected final ILogger logger;
    protected final long redoWaitMillis;

    protected BaseManager(Node node) {
        this.node = node;
        this.lsMembers = node.baseVariables.lsMembers;
        this.mapMembers = node.baseVariables.mapMembers;
        this.mapCalls = node.baseVariables.mapCalls;
        this.thisAddress = node.baseVariables.thisAddress;
        this.thisMember = node.baseVariables.thisMember;
        this.qServiceThreadPacketCache = node.baseVariables.qServiceThreadPacketCache;
        this.localIdGen = node.baseVariables.localIdGen;
        this.logger = node.getLogger(this.getClass().getName());
        this.redoWaitMillis = node.getGroupProperties().REDO_WAIT_MILLIS.getLong();
    }

    public LinkedList<MemberImpl> getMembers() {
        return this.lsMembers;
    }

    public Address getThisAddress() {
        return this.thisAddress;
    }

    public Node getNode() {
        return this.node;
    }

    public static MapEntry createSimpleMapEntry(final FactoryImpl factory, final String name, final Object key, final Object value) {
        return new MapEntry(){

            public Object getKey() {
                return key;
            }

            public Object getValue() {
                return value;
            }

            public Object setValue(Object newValue) {
                return ((MProxy)factory.getOrCreateProxyByName(name)).put(key, newValue);
            }

            public long getCost() {
                return 0L;
            }

            public long getCreationTime() {
                return 0L;
            }

            public long getExpirationTime() {
                return 0L;
            }

            public int getHits() {
                return 0;
            }

            public long getLastAccessTime() {
                return 0L;
            }

            public long getLastStoredTime() {
                return 0L;
            }

            public long getLastUpdateTime() {
                return 0L;
            }

            public long getVersion() {
                return 0L;
            }

            public boolean isValid() {
                return false;
            }

            public String toString() {
                return "Map.Entry key=" + this.getKey() + ", value=" + this.getValue();
            }
        };
    }

    protected void rethrowException(ClusterOperation operation, AddressAwareException exception) {
        String msg = (Object)((Object)operation) + " failed at " + this.thisAddress + " because of an exception thrown at " + exception.getAddress();
        throw new RuntimeException(msg, exception.getException());
    }

    public boolean returnRedoResponse(Request request) {
        request.response = Constants.Objects.OBJECT_REDO;
        return this.returnResponse(request, null);
    }

    public boolean returnResponse(Request request) {
        return this.returnResponse(request, null);
    }

    public boolean returnResponse(Request request, Connection conn) {
        if (request.local) {
            TargetAwareOp targetAwareOp = (TargetAwareOp)request.attachment;
            targetAwareOp.setResult(request.response);
        } else {
            Packet packet = this.obtainPacket();
            request.setPacket(packet);
            packet.operation = ClusterOperation.RESPONSE;
            packet.responseType = (byte)3;
            packet.longValue = request.longValue;
            if (request.value != null) {
                packet.setValue(request.value);
            }
            if (request.response == Constants.Objects.OBJECT_REDO) {
                packet.lockAddress = null;
                packet.responseType = (byte)5;
            } else if (request.response != null) {
                if (request.response instanceof Boolean) {
                    if (request.response == Boolean.FALSE) {
                        packet.responseType = (byte)4;
                    }
                } else if (request.response instanceof Long) {
                    packet.longValue = (Long)request.response;
                } else {
                    Data data = request.response instanceof Data ? (Data)request.response : IOUtil.toData(request.response);
                    if (data != null && data.size() > 0) {
                        packet.setValue(data);
                    }
                }
            }
            if (conn != null) {
                conn.getWriteHandler().enqueueSocketWritable(packet);
            } else {
                return this.sendResponse(packet, request.caller);
            }
        }
        return true;
    }

    protected boolean isMigrating(Request req) {
        return false;
    }

    public static Instance.InstanceType getInstanceType(String name) {
        if (name.startsWith("a:")) {
            return Instance.InstanceType.ATOMIC_NUMBER;
        }
        if (name.startsWith("d:")) {
            return Instance.InstanceType.COUNT_DOWN_LATCH;
        }
        if (name.startsWith("i:")) {
            return Instance.InstanceType.ID_GENERATOR;
        }
        if (name.startsWith("l:")) {
            return Instance.InstanceType.LIST;
        }
        if (name.startsWith("c:")) {
            return Instance.InstanceType.MAP;
        }
        if (name.startsWith("m:u:")) {
            return Instance.InstanceType.MULTIMAP;
        }
        if (name.startsWith("q:")) {
            return Instance.InstanceType.QUEUE;
        }
        if (name.startsWith("4:")) {
            return Instance.InstanceType.SEMAPHORE;
        }
        if (name.startsWith("m:s:")) {
            return Instance.InstanceType.SET;
        }
        if (name.startsWith("t:")) {
            return Instance.InstanceType.TOPIC;
        }
        throw new RuntimeException("Unknown InstanceType " + name);
    }

    public void enqueueCall(Call call) {
        call.onEnqueue();
        this.enqueueAndReturn(call);
    }

    public void enqueueAndReturn(Processable obj) {
        this.node.clusterService.enqueueAndReturn(obj);
    }

    public boolean enqueueAndWait(Processable processable, int seconds) {
        return this.node.clusterService.enqueueAndWait(processable, seconds);
    }

    public Packet obtainPacket(String name, Object key, Object value, ClusterOperation operation, long timeout) {
        Packet packet = this.obtainPacket();
        packet.set(name, operation, key, value);
        packet.timeout = timeout;
        return packet;
    }

    public Call getCall(long id) {
        return this.mapCalls.get(id);
    }

    public long addCall(Call call) {
        long id = this.localIdGen.incrementAndGet();
        call.setCallId(id);
        this.mapCalls.put(id, call);
        return id;
    }

    public Call removeCall(long id) {
        Call callRemoved = this.mapCalls.remove(id);
        if (callRemoved != null) {
            callRemoved.setCallId(-1L);
        }
        return callRemoved;
    }

    public void registerPacketProcessor(ClusterOperation operation, PacketProcessor packetProcessor) {
        this.node.clusterService.registerPacketProcessor(operation, packetProcessor);
    }

    public PacketProcessor getPacketProcessor(ClusterOperation operation) {
        return this.node.clusterService.getPacketProcessor(operation);
    }

    public void returnScheduledAsBoolean(Request request) {
        if (request.local) {
            TargetAwareOp mop = (TargetAwareOp)request.attachment;
            mop.setResult(request.response);
        } else {
            Packet packet = this.obtainPacket();
            request.setPacket(packet);
            if (request.response == Boolean.TRUE) {
                boolean sent = this.sendResponse(packet, request.caller);
                this.logger.log(Level.FINEST, request.local + " returning scheduled response " + sent);
            } else {
                this.sendResponseFailure(packet, request.caller);
            }
        }
    }

    public void returnScheduledAsSuccess(Request request) {
        if (request.local) {
            TargetAwareOp targetAwareOp = (TargetAwareOp)request.attachment;
            targetAwareOp.setResult(request.response);
        } else {
            Data data;
            Packet packet = this.obtainPacket();
            request.setPacket(packet);
            Object result = request.response;
            if (result != null && result instanceof Data && (data = (Data)result).size() > 0) {
                packet.setValue(data);
            }
            this.sendResponse(packet, request.caller);
        }
    }

    public void sendEvents(int eventType, String name, Data key, Data value, Map<Address, Boolean> mapListeners, Address callerAddress) {
        if (mapListeners != null) {
            Set<Map.Entry<Address, Boolean>> listeners = mapListeners.entrySet();
            for (Map.Entry<Address, Boolean> listener : listeners) {
                Address toAddress = listener.getKey();
                boolean includeValue = listener.getValue();
                if (toAddress.isThisAddress()) {
                    this.enqueueEvent(eventType, name, key, includeValue ? value : null, callerAddress, true);
                    continue;
                }
                Packet packet = this.obtainPacket();
                packet.set(name, ClusterOperation.EVENT, key, includeValue ? value : null);
                packet.lockAddress = callerAddress;
                packet.longValue = eventType;
                boolean sent = this.send(packet, toAddress);
                if (sent) continue;
                this.releasePacket(packet);
            }
        }
    }

    public void sendProcessableTo(RemotelyProcessable rp, Address address) {
        Data value = IOUtil.toData(rp);
        Packet packet = this.obtainPacket();
        packet.set("remotelyProcess", ClusterOperation.REMOTELY_PROCESS, null, value);
        boolean sent = this.send(packet, address);
        if (!sent) {
            this.releasePacket(packet);
        }
    }

    public void sendProcessableToAll(RemotelyProcessable rp, boolean processLocally) {
        rp.setNode(this.node);
        if (processLocally) {
            rp.process();
        }
        Data value = IOUtil.toData(rp);
        for (MemberImpl member : this.lsMembers) {
            if (member.localMember()) continue;
            Packet packet = this.obtainPacket();
            packet.set("remotelyProcess", ClusterOperation.REMOTELY_PROCESS, null, value);
            boolean sent = this.send(packet, member.getAddress());
            if (sent) continue;
            this.releasePacket(packet);
        }
    }

    public void executeLocally(Runnable runnable) {
        this.node.executorManager.executeLocally(runnable);
    }

    protected Address getMasterAddress() {
        return this.node.getMasterAddress();
    }

    protected MemberImpl getNextMemberAfter(Address address, boolean skipSuperClient, int distance) {
        return this.getNextMemberAfter(this.lsMembers, address, skipSuperClient, distance);
    }

    protected MemberImpl getNextMemberAfter(List<MemberImpl> lsMembers, Address address, boolean skipSuperClient, int distance) {
        int size = lsMembers.size();
        if (size <= 1) {
            return null;
        }
        int indexOfMember = -1;
        for (int i = 0; i < size; ++i) {
            MemberImpl member = lsMembers.get(i);
            if (!member.getAddress().equals(address)) continue;
            indexOfMember = i;
        }
        if (indexOfMember == -1) {
            return null;
        }
        int foundDistance = 0;
        for (int i = indexOfMember; i < size + indexOfMember; ++i) {
            MemberImpl member = lsMembers.get((1 + i) % size);
            if (!skipSuperClient || !member.isSuperClient()) {
                ++foundDistance;
            }
            if (foundDistance != distance) continue;
            return member;
        }
        return null;
    }

    protected int getMemberIndexOf(Address address) {
        int size = this.lsMembers.size();
        for (int i = 0; i < size; ++i) {
            MemberImpl member = this.lsMembers.get(i);
            if (!member.getAddress().equals(address)) continue;
            return i;
        }
        return -1;
    }

    protected int getDistance(Address from, Address to) {
        int fromIndex = this.getMemberIndexOf(from);
        int toIndex = this.getMemberIndexOf(to);
        if (fromIndex == -1 || toIndex == -1) {
            return -1;
        }
        int size = this.lsMembers.size();
        return (toIndex - fromIndex + size) % size;
    }

    protected MemberImpl getNextMemberBeforeSync(Address address, boolean skipSuperClient, int distance) {
        return this.getNextMemberAfter(this.node.clusterManager.getMembersBeforeSync(), address, skipSuperClient, distance);
    }

    protected MemberImpl getPreviousMemberBefore(Address address, boolean skipSuperClient, int distance) {
        return this.getPreviousMemberBefore(this.lsMembers, address, skipSuperClient, distance);
    }

    protected MemberImpl getPreviousMemberBefore(List<MemberImpl> lsMembers, Address address, boolean skipSuperClient, int distance) {
        int size = lsMembers.size();
        if (size <= 1) {
            return null;
        }
        int indexOfMember = -1;
        for (int i = 0; i < size; ++i) {
            MemberImpl member = lsMembers.get(i);
            if (!member.getAddress().equals(address)) continue;
            indexOfMember = i;
        }
        if (indexOfMember == -1) {
            return null;
        }
        indexOfMember += size - 1;
        int foundDistance = 0;
        for (int i = 0; i < size; ++i) {
            MemberImpl member = lsMembers.get((indexOfMember - i) % size);
            if (!skipSuperClient || !member.isSuperClient()) {
                ++foundDistance;
            }
            if (foundDistance != distance) continue;
            return member;
        }
        return null;
    }

    protected boolean isVeryFirstMember() {
        return this.isMaster() && this.node.clusterManager.getMembersBeforeSync().size() == 0;
    }

    protected boolean isMaster() {
        return this.node.isMaster();
    }

    protected boolean isSuperClient() {
        return this.node.isSuperClient();
    }

    protected Packet obtainPacket() {
        return this.node.getPacketPool().obtain();
    }

    protected boolean releasePacket(Packet packet) {
        return this.node.getPacketPool().release(packet);
    }

    protected boolean send(String name, ClusterOperation operation, DataSerializable ds, Address address) {
        Packet packet = this.obtainPacket();
        packet.set(name, operation, null, ds);
        boolean sent = this.send(packet, address);
        if (!sent) {
            this.releasePacket(packet);
        }
        return sent;
    }

    protected boolean sendRedoResponse(Packet packet) {
        packet.responseType = (byte)5;
        packet.lockAddress = null;
        return this.sendResponse(packet);
    }

    protected boolean sendResponse(Packet packet) {
        packet.operation = ClusterOperation.RESPONSE;
        if (packet.responseType == 2) {
            packet.responseType = (byte)3;
        } else if (packet.responseType == 5) {
            packet.lockAddress = null;
        }
        boolean sent = this.send(packet, packet.conn);
        if (!sent) {
            this.releasePacket(packet);
        }
        return sent;
    }

    protected boolean sendResponse(Packet packet, Address address) {
        packet.conn = this.node.connectionManager.getConnection(address);
        return this.sendResponse(packet);
    }

    protected boolean sendResponseFailure(Packet packet) {
        packet.operation = ClusterOperation.RESPONSE;
        packet.responseType = (byte)4;
        boolean sent = this.send(packet, packet.conn);
        if (!sent) {
            this.releasePacket(packet);
        }
        return sent;
    }

    protected boolean sendResponseFailure(Packet packet, Address address) {
        packet.conn = this.node.connectionManager.getConnection(address);
        return this.sendResponseFailure(packet);
    }

    protected void throwCME(Object key) {
        throw new ConcurrentModificationException("Another thread holds a lock for the key : " + key);
    }

    void enqueueEvent(int eventType, String name, Data key, Data value, Address from, boolean localEvent) {
        try {
            Keys keys;
            Collection<Data> values;
            MemberImpl member = this.getMember(from);
            if (member == null) {
                member = new MemberImpl(from, this.thisAddress.equals(from));
            }
            Data newValue = value;
            Data oldValue = null;
            if (value != null && BaseManager.getInstanceType(name).isMap() && (values = (keys = (Keys)IOUtil.toObject(value)).getKeys()) != null) {
                Iterator<Data> it = values.iterator();
                if (it.hasNext()) {
                    newValue = it.next();
                }
                if (it.hasNext()) {
                    oldValue = it.next();
                }
            }
            final DataAwareEntryEvent dataAwareEntryEvent = new DataAwareEntryEvent(member, eventType, name, key, newValue, oldValue, localEvent);
            int hash = key != null ? key.hashCode() : BaseManager.hashTwo(from.hashCode(), name.hashCode());
            this.node.executorManager.getEventExecutorService().executeOrderedRunnable(hash, new Runnable(){

                public void run() {
                    try {
                        BaseManager.this.node.listenerManager.callListeners(dataAwareEntryEvent);
                    }
                    catch (Exception e) {
                        BaseManager.this.logger.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            });
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public final void checkServiceThread() {
        if (Thread.currentThread() != this.node.serviceThread) {
            String msg = "Only ServiceThread can access this method. " + Thread.currentThread();
            this.logger.log(Level.SEVERE, msg);
            throw new Error(msg);
        }
    }

    static int hashTwo(int hash1, int hash2) {
        return hash1 * 29 + hash2;
    }

    void fireMapEvent(Map<Address, Boolean> mapListeners, String name, int eventType, Data value, Address callerAddress) {
        this.fireMapEvent(mapListeners, name, eventType, null, value, callerAddress);
    }

    void fireMapEvent(Map<Address, Boolean> mapListeners, String name, int eventType, Data oldValue, Data value, Address callerAddress) {
        this.fireMapEvent(mapListeners, name, eventType, null, oldValue, value, null, callerAddress);
    }

    void fireMapEvent(Map<Address, Boolean> mapListeners, String name, int eventType, Data key, Data oldValue, Data value, Map<Address, Boolean> keyListeners, Address callerAddress) {
        if (keyListeners == null && (mapListeners == null || mapListeners.size() == 0)) {
            return;
        }
        try {
            HashMap<Address, Boolean> mapTargetListeners = null;
            if (keyListeners != null) {
                mapTargetListeners = new HashMap<Address, Boolean>(keyListeners);
            }
            if (mapListeners != null && mapListeners.size() > 0) {
                if (mapTargetListeners == null) {
                    mapTargetListeners = new HashMap<Address, Boolean>(mapListeners);
                } else {
                    Set<Map.Entry<Address, Boolean>> entries = mapListeners.entrySet();
                    for (Map.Entry<Address, Boolean> entry : entries) {
                        if (mapTargetListeners.containsKey(entry.getKey())) {
                            if (!entry.getValue().booleanValue()) continue;
                            mapTargetListeners.put(entry.getKey(), entry.getValue());
                            continue;
                        }
                        mapTargetListeners.put(entry.getKey(), entry.getValue());
                    }
                }
            }
            if (mapTargetListeners == null || mapTargetListeners.size() == 0) {
                return;
            }
            Data packetValue = value;
            if (value != null && BaseManager.getInstanceType(name).isMap()) {
                Keys keys = new Keys();
                keys.add(value);
                if (oldValue != null) {
                    keys.add(oldValue);
                }
                packetValue = IOUtil.toData(keys);
            }
            this.sendEvents(eventType, name, key, packetValue, mapTargetListeners, callerAddress);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    MemberImpl getMember(Address address) {
        return this.node.clusterManager.getMember(address);
    }

    void handleListenerRegistrations(boolean add, String name, Data key, Address address, boolean includeValue) {
        if (name.startsWith("q:")) {
            this.node.blockingQueueManager.handleListenerRegistrations(add, name, key, address, includeValue);
        } else if (name.startsWith("t:")) {
            this.node.topicManager.handleListenerRegistrations(add, name, key, address, includeValue);
        } else {
            this.node.concurrentMapManager.handleListenerRegistrations(add, name, key, address, includeValue);
        }
    }

    public final void handleResponse(Packet packetResponse) {
        Call call = this.getCall(packetResponse.callId);
        if (call != null) {
            call.handleResponse(packetResponse);
        } else {
            this.logger.log(Level.FINEST, (Object)((Object)packetResponse.operation) + " No call for callId " + packetResponse.callId);
            this.releasePacket(packetResponse);
        }
    }

    protected boolean send(Packet packet, Address address) {
        if (address == null) {
            return false;
        }
        Connection conn = this.node.connectionManager.getConnection(address);
        return conn != null && conn.live() && this.writePacket(conn, packet);
    }

    protected final boolean send(Packet packet, Connection conn) {
        return conn != null && conn.live() && this.writePacket(conn, packet);
    }

    protected final boolean sendOrReleasePacket(Packet packet, Connection conn) {
        if (conn != null && conn.live() && this.writePacket(conn, packet)) {
            return true;
        }
        this.releasePacket(packet);
        return false;
    }

    private boolean writePacket(Connection conn, Packet packet) {
        MemberImpl memberImpl = this.getMember(conn.getEndPoint());
        if (memberImpl != null) {
            memberImpl.didWrite();
        }
        if (packet.lockAddress != null && this.thisAddress.equals(packet.lockAddress)) {
            packet.lockAddress = null;
        }
        conn.getWriteHandler().enqueueSocketWritable(packet);
        return true;
    }

    abstract class SubCall
    extends TargetAwareOp {
        public SubCall(Address target) {
            this.target = target;
            if (target == null) {
                throw new IllegalArgumentException("SubCall target cannot be " + target);
            }
        }

        public void onDisconnect(Address dead) {
            BaseManager.this.removeCall(this.getCallId());
            this.setResult(Constants.Objects.OBJECT_REDO);
        }

        public void setTarget() {
        }

        protected void memberDoesNotExist() {
            this.setResult(Constants.Objects.OBJECT_REDO);
        }

        public Object getResult() {
            return this.waitAndGetResult();
        }

        public boolean isMigrationAware() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class MultiCall<T> {
        int redoCount = 0;

        MultiCall() {
        }

        private void logRedo(SubCall subCall) {
            ++this.redoCount;
            if (this.redoCount >= 20 && this.redoCount % 20 == 0) {
                BaseManager.this.logger.log(Level.WARNING, this.buildRedoLog(subCall));
            }
        }

        private String buildRedoLog(SubCall subCall) {
            StringBuilder s = new StringBuilder();
            s.append("=========== REDO LOG =========== ");
            s.append(this.getClass().getName());
            s.append(" Redoing ");
            s.append(subCall.request);
            s.append("\n");
            s.append(BaseManager.this.node.getClusterImpl());
            s.append("\n============================== ");
            return s.toString();
        }

        abstract SubCall createNewTargetAwareOp(Address var1);

        abstract boolean onResponse(Object var1);

        void onComplete() {
        }

        void onRedo() {
        }

        void onCall() {
        }

        abstract Object returnResult();

        protected Address getFirstAddressToMakeCall() {
            return BaseManager.this.thisAddress;
        }

        T call() {
            try {
                BaseManager.this.node.checkNodeState();
                this.onCall();
                SubCall localCall = this.createNewTargetAwareOp(this.getFirstAddressToMakeCall());
                localCall.doOp();
                Object result = localCall.getResultAsObject();
                if (result == Constants.Objects.OBJECT_REDO) {
                    this.logRedo(localCall);
                    this.onRedo();
                    Thread.sleep(BaseManager.this.redoWaitMillis);
                    return this.call();
                }
                if (this.onResponse(result)) {
                    Set<Member> members = BaseManager.this.node.getClusterImpl().getMembers();
                    ArrayList<SubCall> lsCalls = new ArrayList<SubCall>();
                    for (Member member : members) {
                        MemberImpl cMember = (MemberImpl)member;
                        if (cMember.getAddress().equals(this.getFirstAddressToMakeCall())) continue;
                        SubCall subCall = this.createNewTargetAwareOp(cMember.getAddress());
                        subCall.doOp();
                        lsCalls.add(subCall);
                    }
                    for (SubCall call : lsCalls) {
                        result = call.getResultAsObject();
                        if (result == Constants.Objects.OBJECT_REDO) {
                            this.logRedo(call);
                            this.onRedo();
                            Thread.sleep(BaseManager.this.redoWaitMillis);
                            return this.call();
                        }
                        if (this.onResponse(result)) continue;
                        break;
                    }
                    this.onComplete();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return (T)this.returnResult();
        }
    }

    public abstract class TargetAwareOp
    extends ResponseQueueCall {
        protected Address target;
        protected Connection targetConnection;

        public TargetAwareOp() {
            this.target = null;
            this.targetConnection = null;
        }

        public void handleResponse(Packet packet) {
            if (packet.responseType == 5) {
                this.redo();
            } else {
                this.handleNoneRedoResponse(packet);
            }
            this.doReleasePacket(packet);
        }

        protected void doReleasePacket(Packet packet) {
        }

        protected Packet doObtainPacket() {
            return new Packet();
        }

        protected void onStillWaiting() {
            BaseManager.this.enqueueAndReturn(new Processable(){

                public void process() {
                    if (TargetAwareOp.this.targetConnection != null && !TargetAwareOp.this.targetConnection.live()) {
                        TargetAwareOp.this.redo();
                    }
                }
            });
        }

        public void onDisconnect(Address dead) {
            if (dead.equals(this.target)) {
                this.target = null;
                this.redo();
            }
        }

        public void reset() {
            super.reset();
            this.target = null;
            this.targetConnection = null;
        }

        public void beforeRedo() {
            BaseManager.this.logger.log(Level.FINEST, (Object)((Object)this.request.operation) + " BeforeRedo target " + this.target);
            super.beforeRedo();
        }

        public void process() {
            this.request.caller = BaseManager.this.thisAddress;
            this.setTarget();
            if (this.target == null) {
                this.setResult(Constants.Objects.OBJECT_REDO);
            } else if (this.target.equals(BaseManager.this.thisAddress)) {
                long callId;
                this.request.callId = callId = BaseManager.this.localIdGen.incrementAndGet();
                this.setCallId(callId);
                this.doLocalOp();
            } else {
                this.invoke();
            }
        }

        protected void memberDoesNotExist() {
            this.setResult(Constants.Objects.OBJECT_REDO);
        }

        protected void invoke() {
            if (BaseManager.this.getMember(this.target) == null) {
                this.memberDoesNotExist();
            } else {
                BaseManager.this.addCall(this);
                Packet packet = this.doObtainPacket();
                this.request.setPacket(packet);
                packet.callId = this.getCallId();
                this.request.callId = this.getCallId();
                this.targetConnection = BaseManager.this.node.connectionManager.getConnection(this.target);
                boolean sent = BaseManager.this.send(packet, this.targetConnection);
                if (!sent) {
                    this.targetConnection = null;
                    BaseManager.this.logger.log(Level.FINEST, this + " Packet cannot be sent to " + this.target);
                    BaseManager.this.releasePacket(packet);
                    this.packetNotSent();
                }
            }
        }

        protected void packetNotSent() {
            this.redo();
        }

        public void doLocalOp() {
            if (this.isMigrationAware() && BaseManager.this.isMigrating(this.request)) {
                this.setResult(Constants.Objects.OBJECT_REDO);
            } else {
                this.request.attachment = this;
                this.request.local = true;
                ((RequestHandler)((Object)BaseManager.this.getPacketProcessor(this.request.operation))).handle(this.request);
            }
        }

        public abstract void setTarget();

        public Address getTarget() {
            return this.target;
        }

        public boolean isMigrationAware() {
            return false;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{[" + "" + this.getCallId() + "], firstEnqueue=" + (System.currentTimeMillis() - this.firstEnqueueTime) / 1000L + "sn., enqueueCount=" + this.enqueueCount + ", " + this.request + ", target=" + this.getTarget() + '}';
        }
    }

    public abstract class ConnectionAwareOp
    extends ResponseQueueCall {
        protected final Connection targetConnection;

        public ConnectionAwareOp(Connection targetConnection) {
            this.targetConnection = targetConnection;
        }

        public void handleResponse(Packet packet) {
            if (packet.responseType == 5) {
                this.redo();
            } else {
                this.handleNoneRedoResponse(packet);
            }
            BaseManager.this.releasePacket(packet);
        }

        public void onDisconnect(Address dead) {
        }

        public void reset() {
            super.reset();
        }

        public void beforeRedo() {
            BaseManager.this.logger.log(Level.FINEST, (Object)((Object)this.request.operation) + " BeforeRedo target " + this.targetConnection);
            super.beforeRedo();
        }

        public void process() {
            this.invoke();
        }

        protected void invoke() {
            BaseManager.this.addCall(this);
            Packet packet = BaseManager.this.obtainPacket();
            this.request.setPacket(packet);
            packet.callId = this.getCallId();
            this.request.callId = this.getCallId();
            boolean sent = BaseManager.this.send(packet, this.targetConnection);
            if (!sent) {
                BaseManager.this.logger.log(Level.FINEST, this + " Packet cannot be sent to " + this.targetConnection);
                BaseManager.this.releasePacket(packet);
                this.packetNotSent();
            }
        }

        protected void packetNotSent() {
            this.setResult(new IOException("Connection is lost!"));
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{[" + "" + this.getCallId() + "], firstEnqueue=" + (System.currentTimeMillis() - this.firstEnqueueTime) / 1000L + "sn., enqueueCount=" + this.enqueueCount + ", " + this.request + ", target=" + this.getTarget() + '}';
        }
    }

    public abstract class ResponseQueueCall
    extends RequestBasedCall {
        private final BlockingQueue<Object> responses;

        public ResponseQueueCall() {
            this.responses = ResponseQueueFactory.newResponseQueue();
        }

        public void doOp() {
            this.responses.clear();
            BaseManager.this.enqueueCall(this);
        }

        public void beforeRedo() {
            this.request.beforeRedo();
            BaseManager.this.node.checkNodeState();
        }

        public Object getResult(long time, TimeUnit unit) throws InterruptedException {
            return this.responses.poll(time, unit);
        }

        protected void onStillWaiting() {
        }

        public Object waitAndGetResult() {
            while (true) {
                try {
                    while (true) {
                        Object obj;
                        if ((obj = this.responses.poll(10L, TimeUnit.SECONDS)) != null) {
                            return obj;
                        }
                        if (BaseManager.this.node.isActive()) {
                            BaseManager.this.logger.log(Level.FINEST, "Still no response! " + this.request);
                        }
                        BaseManager.this.node.checkNodeState();
                        if (Thread.interrupted()) {
                            this.handleInterruptedException();
                        }
                        this.onStillWaiting();
                    }
                }
                catch (InterruptedException e) {
                    this.handleInterruptedException();
                    continue;
                }
                break;
            }
        }

        private void handleInterruptedException() {
            if (BaseManager.this.node.factory.restarted) {
                throw new RuntimeException();
            }
            throw new RuntimeInterruptedException(Thread.currentThread().toString() + " is interrupted.");
        }

        public Object getResult() {
            return this.getRedoAwareResult();
        }

        protected final Object getRedoAwareResult() {
            Object result;
            while (true) {
                result = this.waitAndGetResult();
                if (Thread.interrupted()) {
                    this.handleInterruptedException();
                }
                if (result != Constants.Objects.OBJECT_REDO) break;
                ++this.request.redoCount;
                if (this.request.redoCount > 19 && this.request.redoCount % 10 == 0) {
                    final CountDownLatch l = new CountDownLatch(1);
                    final Request reqCopy = this.request.hardCopy();
                    reqCopy.redoCount = this.request.redoCount;
                    final Address targetCopy = this.getTarget();
                    if (!BaseManager.this.thisAddress.equals(targetCopy)) {
                        BaseManager.this.enqueueAndReturn(new Processable(){

                            public void process() {
                                Block block;
                                Connection targetConnection = null;
                                MemberImpl targetMember = null;
                                Object key = IOUtil.toObject(reqCopy.key);
                                Block block2 = block = reqCopy.key == null ? null : BaseManager.this.node.concurrentMapManager.getOrCreateBlock(reqCopy);
                                if (targetCopy != null) {
                                    targetMember = BaseManager.this.getMember(targetCopy);
                                    targetConnection = BaseManager.this.node.connectionManager.getConnection(targetCopy);
                                    if (targetMember != null && !BaseManager.this.lsMembers.contains(targetMember)) {
                                        BaseManager.this.logger.log(Level.SEVERE, targetMember + " is not in member list!");
                                    }
                                }
                                String msg = "======= " + reqCopy.callId + ": " + (Object)((Object)reqCopy.operation) + " ======== " + "\n\t" + "thisAddress= " + BaseManager.this.thisAddress + ", target= " + targetCopy + "\n\t" + "targetMember= " + targetMember + ", targetConn=" + targetConnection + ", targetBlock=" + block + "\n\t" + key + " Re-doing [" + reqCopy.redoCount + "] times! " + reqCopy.name + " : " + IOUtil.toObject(reqCopy.value);
                                BaseManager.this.logger.log(Level.INFO, msg);
                                l.countDown();
                            }
                        });
                    } else {
                        String msg = "======= " + reqCopy.callId + ": " + (Object)((Object)reqCopy.operation) + " ======== " + "\n\t" + "thisAddress= " + BaseManager.this.thisAddress + ", target= " + targetCopy + "\n\t" + " Re-doing [" + reqCopy.redoCount + "] times! " + reqCopy.name + " : " + IOUtil.toObject(reqCopy.key) + "=" + IOUtil.toObject(reqCopy.value);
                        BaseManager.this.logger.log(Level.WARNING, msg);
                        l.countDown();
                    }
                    try {
                        l.await();
                    }
                    catch (InterruptedException e) {
                        this.handleInterruptedException();
                    }
                }
                try {
                    Thread.sleep(BaseManager.this.redoWaitMillis);
                }
                catch (InterruptedException e) {
                    this.handleInterruptedException();
                }
                this.beforeRedo();
                this.doOp();
            }
            return result;
        }

        protected Address getTarget() {
            return BaseManager.this.thisAddress;
        }

        public void redo() {
            BaseManager.this.removeCall(this.getCallId());
            this.responses.clear();
            this.setResult(Constants.Objects.OBJECT_REDO);
        }

        public void reset() {
            if (this.getCallId() != -1L) {
                BaseManager.this.removeCall(this.getCallId());
            }
            super.reset();
        }

        private void handleBooleanNoneRedoResponse(Packet packet) {
            if (packet.responseType == 3) {
                this.setResult(Boolean.TRUE);
            } else {
                this.setResult(Boolean.FALSE);
            }
        }

        private void handleLongNoneRedoResponse(Packet packet) {
            if (packet.responseType != 3) {
                throw new RuntimeException("handleLongNoneRedoResponse.responseType " + packet.responseType);
            }
            this.setResult(packet.longValue);
        }

        private void handleObjectNoneRedoResponse(Packet packet) {
            if (packet.responseType == 3) {
                Data oldValue = packet.getValueData();
                if (oldValue == null || oldValue.size() == 0) {
                    this.setResult(Constants.Objects.OBJECT_NULL);
                } else {
                    this.setResult(oldValue);
                }
            } else {
                throw new RuntimeException((Object)((Object)this.request.operation) + " handleObjectNoneRedoResponse.responseType " + packet.responseType);
            }
        }

        protected void handleNoneRedoResponse(Packet packet) {
            BaseManager.this.removeCall(this.getCallId());
            if (this.request.isBooleanRequest()) {
                this.handleBooleanNoneRedoResponse(packet);
            } else if (this.request.isLongRequest()) {
                this.handleLongNoneRedoResponse(packet);
            } else if (this.request.isObjectRequest()) {
                this.handleObjectNoneRedoResponse(packet);
            } else {
                throw new RuntimeException((Object)((Object)this.request.operation) + " Unknown request.responseType. " + (Object)((Object)this.request.responseType));
            }
        }

        protected void setResult(Object obj) {
            this.responses.offer(obj == null ? Constants.Objects.OBJECT_NULL : obj);
        }
    }

    abstract class RequestBasedCall
    extends AbstractCall {
        protected final Request request;

        RequestBasedCall() {
            this.request = new Request();
        }

        public boolean booleanCall(ClusterOperation operation, String name, Object key, Object value, long timeout, long recordId) {
            this.setLocal(operation, name, key, value, timeout, recordId);
            this.request.setBooleanRequest();
            this.doOp();
            return this.getResultAsBoolean();
        }

        public void reset() {
            super.reset();
        }

        public boolean getResultAsBoolean() {
            Object resultObj = this.getResult();
            boolean result = Boolean.TRUE.equals(resultObj);
            this.afterGettingResult(this.request);
            return result;
        }

        public Object getResultAsObject() {
            return this.getResultAsObject(true);
        }

        public Object getResultAsObject(boolean force) {
            Object result = this.getResult();
            if (result == Constants.Objects.OBJECT_NULL || result == null) {
                result = null;
            } else if (result instanceof Data) {
                Data data = (Data)result;
                result = ThreadContext.get().isClient() && force ? data : (data.size() == 0 ? null : IOUtil.toObject(data));
            }
            this.afterGettingResult(this.request);
            return result;
        }

        public Object getResultAsIs() {
            Object result = this.getResult();
            if (result != Constants.Objects.OBJECT_NULL && result != null) {
                return result;
            }
            result = null;
            this.afterGettingResult(this.request);
            return result;
        }

        protected void afterGettingResult(Request request) {
        }

        public Object objectCall() {
            this.request.setObjectRequest();
            this.doOp();
            return this.getResultAsObject();
        }

        public Object objectCall(ClusterOperation operation, String name, Object key, Object value, long timeout, long ttl) {
            this.setLocal(operation, name, key, value, timeout, ttl);
            return this.objectCall();
        }

        public void setLocal(ClusterOperation operation, String name) {
            this.setLocal(operation, name, null, null, -1L, -1L);
        }

        public void setLocal(ClusterOperation operation, String name, Object key, Object value, long timeout, long ttl) {
            Data keyData = null;
            Data valueData = null;
            if (key != null && (keyData = IOUtil.toData(key)).size() == 0) {
                throw new RuntimeException(name + " Key with zero-size " + (Object)((Object)operation));
            }
            if (value != null) {
                valueData = IOUtil.toData(value);
            }
            this.request.setLocal(operation, name, keyData, valueData, -1, timeout, ttl, BaseManager.this.thisAddress);
            this.request.attachment = this;
        }

        abstract void doOp();

        abstract Object getResult();

        public String toString() {
            return this.getClass().getSimpleName() + "{[" + "" + this.getCallId() + "], duration=" + this.getDurationSeconds() + "sn., enqueueCount=" + this.getEnqueueCount() + ", " + this.request + '}';
        }
    }

    abstract class AbstractOperationHandler
    extends ResponsiveOperationHandler {
        AbstractOperationHandler() {
        }

        public void process(Packet packet) {
            this.processSimple(packet);
        }

        abstract void doOperation(Request var1);

        public void handle(Request request) {
            this.doOperation(request);
            BaseManager.this.returnResponse(request);
        }
    }

    public class ReturnResponseProcess
    implements Processable {
        private final Request request;

        public ReturnResponseProcess(Request request) {
            this.request = request;
        }

        public void process() {
            BaseManager.this.returnResponse(this.request);
        }
    }

    public abstract class ResponsiveOperationHandler
    implements PacketProcessor,
    RequestHandler {
        public void process(Packet packet) {
            this.processSimple(packet);
        }

        public void processSimple(Packet packet) {
            Request request = Request.copy(packet);
            this.handle(request);
            BaseManager.this.releasePacket(packet);
        }

        public void processMigrationAware(Packet packet) {
            Request remoteReq = Request.copy(packet);
            if (BaseManager.this.isMigrating(remoteReq)) {
                remoteReq.clearForResponse();
                remoteReq.response = Constants.Objects.OBJECT_REDO;
                BaseManager.this.returnResponse(remoteReq);
            } else {
                this.handle(remoteReq);
            }
            BaseManager.this.releasePacket(packet);
        }
    }

    abstract class TargetAwareOperationHandler
    extends MigrationAwareOperationHandler {
        TargetAwareOperationHandler() {
        }

        abstract boolean isRightRemoteTarget(Request var1);

        public void process(Packet packet) {
            Request remoteReq = Request.copy(packet);
            if (BaseManager.this.isMigrating(remoteReq) || !this.isRightRemoteTarget(remoteReq)) {
                remoteReq.clearForResponse();
                remoteReq.response = Constants.Objects.OBJECT_REDO;
                BaseManager.this.returnResponse(remoteReq);
            } else {
                this.handle(remoteReq);
            }
            BaseManager.this.releasePacket(packet);
        }
    }

    abstract class MigrationAwareOperationHandler
    extends AbstractOperationHandler {
        MigrationAwareOperationHandler() {
        }

        public void process(Packet packet) {
            super.processMigrationAware(packet);
        }
    }

    abstract class AbstractCall
    implements Call {
        protected long callId = -1L;
        protected long firstEnqueueTime = -1L;
        protected int enqueueCount = 0;

        public long getCallId() {
            return this.callId;
        }

        public void onDisconnect(Address dead) {
        }

        public void onEnqueue() {
            if (this.firstEnqueueTime == -1L) {
                this.firstEnqueueTime = System.currentTimeMillis();
            }
            ++this.enqueueCount;
        }

        public void redo() {
            BaseManager.this.removeCall(this.getCallId());
            this.callId = -1L;
            BaseManager.this.enqueueCall(this);
        }

        public void setCallId(long callId) {
            this.callId = callId;
        }

        public void reset() {
            this.callId = -1L;
            this.firstEnqueueTime = -1L;
            this.enqueueCount = 0;
        }

        public long getFirstEnqueueTime() {
            return this.firstEnqueueTime;
        }

        public int getEnqueueCount() {
            return this.enqueueCount;
        }

        protected int getDurationSeconds() {
            return (int)(System.currentTimeMillis() - this.firstEnqueueTime) / 1000;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{[" + "" + this.getCallId() + "], duration=" + this.getDurationSeconds() + "sn., enqueueCount=" + this.getEnqueueCount() + '}';
        }
    }
}

