/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.examples;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiMap;
import com.hazelcast.examples.SimpleMapTest;
import com.hazelcast.partition.Partition;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMultiMapTest {
    public static final int STATS_SECONDS = 10;
    public static int THREAD_COUNT = 40;
    public static int ENTRY_COUNT = 10000;
    public static int VALUE_SIZE = 1000;
    public static int GET_PERCENTAGE = 40;
    public static int PUT_PERCENTAGE = 40;
    static Logger logger = Logger.getLogger(SimpleMapTest.class.getName());

    public static void main(String[] args) {
        boolean load = SimpleMultiMapTest.init(args);
        ExecutorService es = Executors.newFixedThreadPool(THREAD_COUNT);
        final MultiMap<String, byte[]> map = Hazelcast.getMultiMap("default");
        final AtomicInteger gets = new AtomicInteger(0);
        final AtomicInteger puts = new AtomicInteger(0);
        final AtomicInteger removes = new AtomicInteger(0);
        SimpleMultiMapTest.load(load, es, map);
        for (int i = 0; i < THREAD_COUNT; ++i) {
            es.execute(new Runnable(){

                public void run() {
                    while (true) {
                        int key = (int)(Math.random() * (double)ENTRY_COUNT);
                        int operation = (int)(Math.random() * 100.0);
                        if (operation < GET_PERCENTAGE) {
                            map.get(String.valueOf(key));
                            gets.incrementAndGet();
                            continue;
                        }
                        if (operation < GET_PERCENTAGE + PUT_PERCENTAGE) {
                            map.put(String.valueOf(key), new byte[VALUE_SIZE]);
                            puts.incrementAndGet();
                            continue;
                        }
                        map.remove(String.valueOf(key));
                        removes.incrementAndGet();
                    }
                }
            });
        }
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        Thread.sleep(10000L);
                        logger.info("cluster size:" + Hazelcast.getCluster().getMembers().size());
                        int putCount = puts.getAndSet(0);
                        int getCount = gets.getAndSet(0);
                        int removeCount = removes.getAndSet(0);
                        logger.info("TOTAL:" + (removeCount + putCount + getCount) / 10);
                        logger.info("PUTS:" + putCount / 10);
                        logger.info("GEtS:" + getCount / 10);
                        logger.info("REMOVES:" + removeCount / 10);
                    }
                }
                catch (InterruptedException ignored) {
                    return;
                }
            }
        });
    }

    private static void load(boolean load, ExecutorService es, final MultiMap<String, byte[]> map) {
        if (load) {
            Member thisMember = Hazelcast.getCluster().getLocalMember();
            for (int i = 0; i < ENTRY_COUNT; ++i) {
                final String key = String.valueOf(i);
                Partition partition = Hazelcast.getPartitionService().getPartition(key);
                if (!thisMember.equals(partition.getOwner())) continue;
                es.execute(new Runnable(){

                    public void run() {
                        map.put(key, new byte[VALUE_SIZE]);
                    }
                });
            }
        }
    }

    private static boolean init(String[] args) {
        boolean load = false;
        if (args != null && args.length > 0) {
            for (String arg : args) {
                if ((arg = arg.trim()).startsWith("t")) {
                    THREAD_COUNT = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (arg.startsWith("c")) {
                    ENTRY_COUNT = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (arg.startsWith("v")) {
                    VALUE_SIZE = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (arg.startsWith("g")) {
                    GET_PERCENTAGE = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (arg.startsWith("p")) {
                    PUT_PERCENTAGE = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (!arg.startsWith("load")) continue;
                load = true;
            }
        } else {
            logger.info("Help: sh test.sh t200 v130 p10 g85 ");
            logger.info("    // means 200 threads, value-size 130 bytes, 10% put, 85% get");
            logger.info("");
        }
        logger.info("Starting Test with ");
        logger.info("      Thread Count: " + THREAD_COUNT);
        logger.info("       Entry Count: " + ENTRY_COUNT);
        logger.info("        Value Size: " + VALUE_SIZE);
        logger.info("    Get Percentage: " + GET_PERCENTAGE);
        logger.info("    Put Percentage: " + PUT_PERCENTAGE);
        logger.info(" Remove Percentage: " + (100 - (PUT_PERCENTAGE + GET_PERCENTAGE)));
        return load;
    }
}

