/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnboundedBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final Object lock = new Object();
    private final ConcurrentLinkedQueue<E> queue = new ConcurrentLinkedQueue();

    @Override
    public boolean offer(E e) {
        this.put(e);
        return true;
    }

    @Override
    public boolean remove(Object obj) {
        return this.queue.remove(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e) {
        this.queue.add(e);
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    @Override
    public E take() throws InterruptedException {
        return this.poll(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Override
    public E poll() {
        return this.queue.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        E e = this.queue.poll();
        Object object = this.lock;
        synchronized (object) {
            long now;
            for (long timeLeft = unit.toMillis(timeout); e == null && timeLeft > 0L; timeLeft -= System.currentTimeMillis() - now) {
                now = System.currentTimeMillis();
                this.lock.wait(Math.min(100L, timeLeft));
                e = this.queue.poll();
            }
        }
        return e;
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(e);
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        E e = this.queue.poll();
        int count = 0;
        while (e != null) {
            c.add(e);
            ++count;
            e = this.queue.poll();
        }
        return count;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        int count;
        E e = this.queue.poll();
        for (count = 0; e != null && count < maxElements; ++count) {
            c.add(e);
            e = this.queue.poll();
        }
        return count;
    }

    @Override
    public E peek() {
        return this.queue.peek();
    }

    @Override
    public Iterator<E> iterator() {
        return this.queue.iterator();
    }

    @Override
    public int size() {
        return this.queue.size();
    }
}

