/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.concurrentmap;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MapLoader;
import com.hazelcast.core.MapLoaderLifecycleSupport;
import com.hazelcast.core.MapStore;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MapStoreWrapper
implements MapStore {
    private final MapLoader mapLoader;
    private final MapStore mapStore;
    private final Object initLock = new Object();
    private final boolean shouldInitialize;
    private final Object impl;
    private final HazelcastInstance hazelcastInstance;
    private final Properties properties;
    private final String mapName;
    volatile boolean initialized = false;

    public MapStoreWrapper(Object impl, HazelcastInstance hazelcastInstance, Properties properties, String mapName) {
        this.impl = impl;
        this.hazelcastInstance = hazelcastInstance;
        this.properties = properties;
        this.mapName = mapName;
        MapLoader loader = null;
        MapStore store = null;
        if (impl instanceof MapStore) {
            store = (MapStore)impl;
        }
        if (impl instanceof MapLoader) {
            loader = (MapLoader)impl;
        }
        this.mapLoader = loader;
        this.mapStore = store;
        this.shouldInitialize = impl instanceof MapLoaderLifecycleSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkInit() {
        if (this.shouldInitialize && !this.initialized) {
            Object object = this.initLock;
            synchronized (object) {
                if (!this.initialized) {
                    ((MapLoaderLifecycleSupport)this.impl).init(this.hazelcastInstance, this.properties, this.mapName);
                    this.initialized = true;
                }
            }
        }
    }

    public void destroy() {
        if (this.impl instanceof MapLoaderLifecycleSupport) {
            ((MapLoaderLifecycleSupport)this.impl).destroy();
        }
    }

    public boolean isMapStore() {
        return this.mapStore != null;
    }

    public boolean isMapLoader() {
        return this.mapLoader != null;
    }

    public void delete(Object key) {
        this.checkInit();
        this.mapStore.delete(key);
    }

    public void store(Object key, Object value) {
        this.checkInit();
        this.mapStore.store(key, value);
    }

    public void storeAll(Map map) {
        this.checkInit();
        this.mapStore.storeAll(map);
    }

    public void deleteAll(Collection keys) {
        this.checkInit();
        this.mapStore.deleteAll(keys);
    }

    public Set loadAllKeys() {
        this.checkInit();
        return this.mapLoader.loadAllKeys();
    }

    public Object load(Object key) {
        this.checkInit();
        return this.mapLoader.load(key);
    }

    public Map loadAll(Collection keys) {
        this.checkInit();
        return this.mapLoader.loadAll(keys);
    }

    public String toString() {
        return "MapStoreWrapper{mapName='" + this.mapName + '\'' + ", mapStore=" + this.mapStore + ", mapLoader=" + this.mapLoader + '}';
    }
}

