/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.core.Member;
import com.hazelcast.jmx.AbstractMBean;
import com.hazelcast.jmx.JMXAttribute;
import com.hazelcast.jmx.JMXDescription;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.jmx.ObjectNameSpec;
import java.net.InetAddress;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JMXDescription(value="A member of the cluster")
public class MemberMBean
extends AbstractMBean<Member> {
    private ObjectName name;

    public MemberMBean(Member managedObject, ManagementService managementService) {
        super(managedObject, managementService);
    }

    @Override
    public ObjectNameSpec getNameSpec() {
        String memberName = "Local";
        if (!((Member)this.getManagedObject()).localMember()) {
            memberName = '\"' + ((Member)this.getManagedObject()).getInetAddress().getHostAddress() + ":" + ((Member)this.getManagedObject()).getPort() + '\"';
        }
        return this.getParentName().getNested("Member", memberName);
    }

    @JMXDescription(value="The network address")
    @JMXAttribute(value="Port")
    public int getPort() {
        return ((Member)this.getManagedObject()).getPort();
    }

    @JMXAttribute(value="InetAddress")
    @JMXDescription(value="The network port")
    public InetAddress getInetAddress() {
        return ((Member)this.getManagedObject()).getInetAddress();
    }

    @JMXAttribute(value="SuperClient")
    @JMXDescription(value="The member is a superclient")
    public boolean isSuperClient() {
        return ((Member)this.getManagedObject()).isSuperClient();
    }
}

