/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.IHazelcastInstanceLoader;
import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.util.PropertiesHelper;

public final class HazelcastInstanceFactory {
    private static final String HZ_CLIENT_LOADER_CLASSNAME = "com.hazelcast.hibernate.HazelcastClientLoader";
    private static final String HZ_INSTANCE_LOADER_CLASSNAME = "com.hazelcast.hibernate.HazelcastInstanceLoader";

    public static HazelcastInstance createInstance(Properties props) throws CacheException {
        boolean useNativeClient = false;
        if (props != null) {
            useNativeClient = PropertiesHelper.getBoolean((String)"hibernate.cache.hazelcast.use_native_client", (Properties)props, (boolean)false);
        }
        IHazelcastInstanceLoader loader = null;
        Class<?> loaderClass = null;
        ClassLoader cl = HazelcastInstanceFactory.class.getClassLoader();
        try {
            loaderClass = useNativeClient ? cl.loadClass(HZ_CLIENT_LOADER_CLASSNAME) : cl.loadClass(HZ_INSTANCE_LOADER_CLASSNAME);
            loader = (IHazelcastInstanceLoader)loaderClass.newInstance();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
        return loader.loadInstance(props);
    }
}

