/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientBinder;
import com.hazelcast.client.ClientProperties;
import com.hazelcast.client.Connection;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.LifecycleServiceClientImpl;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionManager
implements MembershipListener {
    private volatile Connection currentConnection;
    private final AtomicInteger connectionIdGenerator = new AtomicInteger(-1);
    private final List<InetSocketAddress> clusterMembers = new CopyOnWriteArrayList<InetSocketAddress>();
    private final ILogger logger = Logger.getLogger(this.getClass().getName());
    private final HazelcastClient client;
    private volatile int lastDisconnectedConnectionId = -1;
    private ClientBinder binder;
    private volatile boolean lookinglForAlive = false;
    private volatile boolean running = true;
    private final LifecycleServiceClientImpl lifecycleService;

    public ConnectionManager(HazelcastClient client, LifecycleServiceClientImpl lifecycleService, InetSocketAddress[] clusterMembers, boolean shuffle) {
        this.client = client;
        this.lifecycleService = lifecycleService;
        this.clusterMembers.addAll(Arrays.asList(clusterMembers));
        if (shuffle) {
            Collections.shuffle(this.clusterMembers);
        }
    }

    public ConnectionManager(HazelcastClient client, LifecycleServiceClientImpl lifecycleService, InetSocketAddress address) {
        this.client = client;
        this.lifecycleService = lifecycleService;
        this.clusterMembers.add(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getInitConnection() throws IOException {
        if (this.currentConnection == null) {
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                int attemptsLimit = this.client.getProperties().getInteger(ClientProperties.ClientPropertyName.INIT_CONNECTION_ATTEMPTS_LIMIT);
                int reconnectionTimeout = this.client.getProperties().getInteger(ClientProperties.ClientPropertyName.RECONNECTION_TIMEOUT);
                this.currentConnection = this.lookForAliveConnection(attemptsLimit, reconnectionTimeout);
            }
        }
        return this.currentConnection;
    }

    public Connection lookForAliveConnection() throws IOException {
        int attemptsLimit = this.client.getProperties().getInteger(ClientProperties.ClientPropertyName.RECONNECTION_ATTEMPTS_LIMIT);
        int reconnectionTimeout = this.client.getProperties().getInteger(ClientProperties.ClientPropertyName.RECONNECTION_TIMEOUT);
        return this.lookForAliveConnection(attemptsLimit, reconnectionTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection lookForAliveConnection(int attemptsLimit, int reconnectionTimeout) throws IOException {
        this.lookinglForAlive = true;
        try {
            boolean restored = false;
            int attempt = 0;
            while (this.currentConnection == null && this.running && !Thread.interrupted()) {
                long next = System.currentTimeMillis() + (long)reconnectionTimeout;
                ConnectionManager connectionManager = this;
                synchronized (connectionManager) {
                    if (this.currentConnection == null) {
                        Connection connection = this.searchForAvailableConnection();
                        boolean bl = restored = connection != null;
                        if (restored) {
                            try {
                                this.bindConnection(connection);
                                this.currentConnection = connection;
                            }
                            catch (Throwable e) {
                                this.closeConnection(connection);
                                this.logger.log(Level.WARNING, "got an exception on getConnection:" + e.getMessage(), e);
                                restored = false;
                            }
                        }
                    }
                }
                if (this.currentConnection != null) {
                    this.logger.log(Level.FINE, "Client is connecting to " + this.currentConnection);
                    this.lookinglForAlive = false;
                    break;
                }
                if (attempt >= attemptsLimit) break;
                long t = next - System.currentTimeMillis();
                this.logger.log(Level.INFO, MessageFormat.format("Unable to get alive cluster connection, try in {0} ms later, attempt {1} of {2}.", Math.max(0L, t), ++attempt, attemptsLimit));
                if (t <= 0L) continue;
                try {
                    Thread.sleep(t);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            if (restored) {
                this.notifyConnectionIsRestored();
            }
        }
        finally {
            this.lookinglForAlive = false;
        }
        return this.currentConnection;
    }

    void closeConnection(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.INFO, "got an exception on closeConnection " + connection + ":" + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws IOException {
        if (this.currentConnection == null && this.running && !this.lookinglForAlive) {
            boolean restored = false;
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                if (this.currentConnection == null) {
                    Connection connection = this.searchForAvailableConnection();
                    if (connection != null) {
                        this.logger.log(Level.FINE, "Client is connecting to " + connection);
                        try {
                            this.bindConnection(connection);
                            this.currentConnection = connection;
                        }
                        catch (Throwable e) {
                            this.closeConnection(connection);
                            this.logger.log(Level.WARNING, "got an exception on getConnection:" + e.getMessage(), e);
                        }
                    }
                    restored = this.currentConnection != null;
                }
            }
            if (restored) {
                this.notifyConnectionIsRestored();
            }
        }
        return this.currentConnection;
    }

    void notifyConnectionIsRestored() {
        this.lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.CLIENT_CONNECTION_OPENING);
    }

    void notifyConnectionIsOpened() {
        this.notify(new Runnable(){

            public void run() {
                ConnectionManager.this.lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.CLIENT_CONNECTION_OPENED);
            }
        });
    }

    private void notify(Runnable target) {
        HazelcastClient.runAsyncAndWait(target);
    }

    void bindConnection(Connection connection) throws IOException {
        this.binder.bind(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyConnection(Connection connection) {
        boolean lost = false;
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (this.currentConnection != null && connection != null && this.currentConnection.getVersion() == connection.getVersion()) {
                this.logger.log(Level.WARNING, "Connection to " + this.currentConnection + " is lost");
                this.currentConnection = null;
                lost = true;
            }
        }
        if (lost) {
            this.notify(new Runnable(){

                public void run() {
                    ConnectionManager.this.lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.CLIENT_CONNECTION_LOST);
                }
            });
        }
    }

    private void popAndPush(List<InetSocketAddress> clusterMembers) {
        InetSocketAddress address = clusterMembers.remove(0);
        clusterMembers.add(address);
    }

    private Connection searchForAvailableConnection() {
        Connection connection = null;
        this.popAndPush(this.clusterMembers);
        for (int counter = this.clusterMembers.size(); counter > 0; --counter) {
            try {
                connection = this.getNextConnection();
                break;
            }
            catch (Exception e) {
                this.popAndPush(this.clusterMembers);
                continue;
            }
        }
        this.logger.log(Level.FINEST, MessageFormat.format("searchForAvailableConnection connection:{0}", connection));
        return connection;
    }

    protected Connection getNextConnection() {
        InetSocketAddress address = this.clusterMembers.get(0);
        return new Connection(address, this.connectionIdGenerator.incrementAndGet());
    }

    @Override
    public synchronized void memberAdded(MembershipEvent membershipEvent) {
        if (!this.clusterMembers.contains(membershipEvent.getMember().getInetSocketAddress())) {
            this.clusterMembers.add(membershipEvent.getMember().getInetSocketAddress());
        }
    }

    @Override
    public synchronized void memberRemoved(MembershipEvent membershipEvent) {
        this.clusterMembers.remove(membershipEvent.getMember().getInetSocketAddress());
    }

    public synchronized void updateMembers() {
        Set<Member> members = this.client.getCluster().getMembers();
        this.clusterMembers.clear();
        for (Member member : members) {
            this.clusterMembers.add(member.getInetSocketAddress());
        }
    }

    public boolean shouldExecuteOnDisconnect(Connection connection) {
        if (connection == null || this.lastDisconnectedConnectionId >= connection.getVersion()) {
            return false;
        }
        this.lastDisconnectedConnectionId = connection.getVersion();
        return true;
    }

    public void setBinder(ClientBinder binder) {
        this.binder = binder;
    }

    List<InetSocketAddress> getClusterMembers() {
        return this.clusterMembers;
    }

    public void shutdown() {
        this.logger.log(Level.INFO, this.getClass().getSimpleName() + " shutdown");
        this.running = false;
    }
}

