/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

public class ThreadStats {
    private final long waitCount;
    private final long runCount;
    private final int utilizationPercentage;
    private final long createMillis;
    private final boolean running;

    public ThreadStats(int utilizationPercentage, long runCount, long waitCount, boolean running) {
        this.utilizationPercentage = utilizationPercentage;
        this.runCount = runCount;
        this.waitCount = waitCount;
        this.running = running;
        this.createMillis = System.currentTimeMillis();
    }

    public long getRunCount() {
        return this.runCount;
    }

    public int getUtilizationPercentage() {
        return this.utilizationPercentage;
    }

    public long getWaitCount() {
        return this.waitCount;
    }

    public long getCreateMillis() {
        return this.createMillis;
    }

    public long getSecondsBetween(long millis) {
        return (millis - this.createMillis) / 1000L;
    }

    public boolean isRunning() {
        return this.running;
    }

    public String toString() {
        return "ThreadStats{utilization=" + this.utilizationPercentage + ", runs=" + this.runCount + ", waits=" + this.waitCount + ", running=" + this.running + '}';
    }
}

