/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.InstanceEvent;
import com.hazelcast.core.InstanceListener;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.MessageListener;
import com.hazelcast.impl.CallContext;
import com.hazelcast.impl.ClientService;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.DataAwareEntryEvent;
import com.hazelcast.impl.Keys;
import com.hazelcast.impl.LifecycleServiceImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientEndpoint
implements EntryListener,
InstanceListener,
MembershipListener,
ConnectionListener,
ClientService.ClientListener {
    private final Connection conn;
    private final Map<Integer, CallContext> callContexts = new HashMap<Integer, CallContext>(100);
    final Map<ITopic, MessageListener<Object>> messageListeners = new HashMap<ITopic, MessageListener<Object>>();
    private final Map<Integer, Map<IMap, List<Data>>> locks = new ConcurrentHashMap<Integer, Map<IMap, List<Data>>>();
    private final List<IMap> listeningMaps = new ArrayList<IMap>();
    private final List<Map.Entry<IMap, Object>> listeningKeysOfMaps = new ArrayList<Map.Entry<IMap, Object>>();
    public Map<IQueue, ItemListener<Object>> queueItemListeners = new HashMap<IQueue, ItemListener<Object>>();
    private final Node node;

    ClientEndpoint(Node node, Connection conn) {
        this.node = node;
        this.conn = conn;
    }

    public CallContext getCallContext(int threadId) {
        CallContext context = this.callContexts.get(threadId);
        if (context == null) {
            int locallyMappedThreadId = ThreadContext.get().createNewThreadId();
            context = new CallContext(locallyMappedThreadId, true);
            this.callContexts.put(threadId, context);
        }
        return context;
    }

    public synchronized void addThisAsListener(IMap map, Data key, boolean includeValue) {
        if (!this.listeningMaps.contains(map) && !this.listeningKeyExist(map, key)) {
            map.addEntryListener(this, includeValue);
        }
        if (key == null) {
            this.listeningMaps.add(map);
        } else {
            this.listeningKeysOfMaps.add(new Entry(map, key));
        }
    }

    public synchronized void removeThisListener(IMap map, Data key) {
        ArrayList<Map.Entry<IMap, Object>> entriesToRemove = new ArrayList<Map.Entry<IMap, Object>>();
        if (key == null) {
            this.listeningMaps.remove(map);
        } else {
            for (Map.Entry<IMap, Object> entry : this.listeningKeysOfMaps) {
                if (!entry.getKey().equals(map) || !entry.getValue().equals(key)) continue;
                entriesToRemove.add(entry);
                break;
            }
        }
        this.listeningKeysOfMaps.removeAll(entriesToRemove);
        if (!this.listeningMaps.contains(map) && !this.listeningKeyExist(map, key)) {
            map.removeEntryListener(this);
        }
    }

    private boolean listeningKeyExist(IMap map, Object key) {
        for (Map.Entry<IMap, Object> entry : this.listeningKeysOfMaps) {
            if (!entry.getKey().equals(map) || key != null && !entry.getValue().equals(key)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.conn.hashCode();
    }

    public void entryAdded(EntryEvent event) {
        this.processEvent(event);
    }

    public void entryEvicted(EntryEvent event) {
        this.processEvent(event);
    }

    public void entryRemoved(EntryEvent event) {
        this.processEvent(event);
    }

    public void entryUpdated(EntryEvent event) {
        this.processEvent(event);
    }

    @Override
    public void instanceCreated(InstanceEvent event) {
        this.processEvent(event);
    }

    @Override
    public void instanceDestroyed(InstanceEvent event) {
        this.processEvent(event);
    }

    @Override
    public void memberAdded(MembershipEvent membershipEvent) {
        this.processEvent(membershipEvent);
    }

    @Override
    public void memberRemoved(MembershipEvent membershipEvent) {
        this.processEvent(membershipEvent);
    }

    private void processEvent(MembershipEvent membershipEvent) {
        Packet packet = this.createMembershipEventPacket(membershipEvent);
        this.sendPacket(packet);
    }

    private void processEvent(InstanceEvent event) {
        Packet packet = this.createInstanceEventPacket(event);
        this.sendPacket(packet);
    }

    private void processEvent(EntryEvent event) {
        Packet packet = this.createEntryEventPacket(event);
        this.sendPacket(packet);
    }

    void sendPacket(Packet packet) {
        if (this.conn != null && this.conn.live()) {
            this.conn.getWriteHandler().enqueueSocketWritable(packet);
        }
    }

    Packet createEntryEventPacket(EntryEvent event) {
        Packet packet = new Packet();
        DataAwareEntryEvent dataAwareEntryEvent = (DataAwareEntryEvent)event;
        Data valueEvent = null;
        if (dataAwareEntryEvent.getNewValueData() != null) {
            Keys keys = new Keys();
            keys.add(dataAwareEntryEvent.getNewValueData());
            keys.add(dataAwareEntryEvent.getOldValueData());
            valueEvent = IOUtil.toData(keys);
        }
        packet.set(event.getName(), ClusterOperation.EVENT, dataAwareEntryEvent.getKeyData(), valueEvent);
        packet.longValue = event.getEventType().getType();
        return packet;
    }

    Packet createInstanceEventPacket(InstanceEvent event) {
        Packet packet = new Packet();
        packet.set(null, ClusterOperation.EVENT, IOUtil.toData(event.getInstance().getId()), IOUtil.toData((Object)event.getEventType()));
        return packet;
    }

    Packet createMembershipEventPacket(MembershipEvent membershipEvent) {
        Packet packet = new Packet();
        packet.set(null, ClusterOperation.EVENT, IOUtil.toData(membershipEvent.getMember()), IOUtil.toData(membershipEvent.getEventType()));
        return packet;
    }

    @Override
    public void connectionAdded(Connection connection) {
    }

    @Override
    public void connectionRemoved(Connection connection) {
        LifecycleServiceImpl lifecycleService = (LifecycleServiceImpl)this.node.factory.getLifecycleService();
        if (connection.equals(this.conn) && !lifecycleService.paused.get()) {
            this.removeLocks();
            this.rollbackTransactions();
            this.removeEntryListeners();
            this.removeEntryListenersWithKey();
            this.removeMessageListeners();
        }
    }

    private void rollbackTransactions() {
        for (CallContext callContext : this.callContexts.values()) {
            ThreadContext.get().setCallContext(callContext);
            if (callContext.getTransaction() == null || callContext.getTransaction().getStatus() != 1) continue;
            callContext.getTransaction().rollback();
        }
    }

    private void removeLocks() {
        for (Integer threadId : this.locks.keySet()) {
            ThreadContext.get().setCallContext(this.getCallContext(threadId));
            Map<IMap, List<Data>> mapOfLocks = this.locks.get(threadId);
            for (IMap map : mapOfLocks.keySet()) {
                List<Data> list = mapOfLocks.get(map);
                for (Data key : list) {
                    map.unlock(key);
                }
            }
        }
    }

    private void removeMessageListeners() {
        for (ITopic topic : this.messageListeners.keySet()) {
            topic.removeMessageListener(this.messageListeners.get(topic));
        }
    }

    private void removeEntryListenersWithKey() {
        for (Map.Entry<IMap, Object> e : this.listeningKeysOfMaps) {
            IMap m = e.getKey();
            m.removeEntryListener(this, e.getValue());
        }
    }

    private void removeEntryListeners() {
        for (IMap map : this.listeningMaps) {
            map.removeEntryListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void locked(IMap<Object, Object> map, Data keyData, int threadId) {
        Map<IMap, List<Data>> mapOfLocks;
        if (!this.locks.containsKey(threadId)) {
            Map<Integer, Map<IMap, List<Data>>> map2 = this.locks;
            synchronized (map2) {
                if (!this.locks.containsKey(threadId)) {
                    ConcurrentHashMap mapOfLocks2 = new ConcurrentHashMap();
                    this.locks.put(threadId, mapOfLocks2);
                }
            }
        }
        if (!(mapOfLocks = this.locks.get(threadId)).containsKey(map)) {
            Map<IMap, List<Data>> map3 = this.locks.get(threadId);
            synchronized (map3) {
                if (!mapOfLocks.containsKey(map)) {
                    CopyOnWriteArrayList list = new CopyOnWriteArrayList();
                    mapOfLocks.put(map, list);
                }
            }
        }
        mapOfLocks.get(map).add(keyData);
    }

    public void unlocked(IMap<Object, Object> map, Data keyData, int threadId) {
        Map<IMap, List<Data>> mapOfLocks;
        if (this.locks.containsKey(threadId) && (mapOfLocks = this.locks.get(threadId)).containsKey(map)) {
            List<Data> list = mapOfLocks.get(map);
            list.remove(keyData);
            if (list.size() == 0) {
                mapOfLocks.remove(map);
            }
            if (this.locks.keySet().size() == 0) {
                this.locks.remove(threadId);
            }
        }
    }

    static class Entry
    implements Map.Entry {
        Object key;
        Object value;

        Entry(Object k, Object v) {
            this.key = k;
            this.value = v;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object r = this.key;
            this.key = value;
            return r;
        }
    }
}

