/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query;

import com.hazelcast.core.MapEntry;
import com.hazelcast.impl.Record;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.query.Expression;
import com.hazelcast.query.Index;
import com.hazelcast.query.IndexAwarePredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.QueryContext;
import com.hazelcast.query.SingleResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapIndexService {
    private final ConcurrentMap<Long, Record> records = new ConcurrentHashMap<Long, Record>(10000, 0.75f, 1);
    private final Index indexValue;
    private final Map<Expression, Index> mapIndexes = new ConcurrentHashMap<Expression, Index>(4, 0.74f, 1);
    private final Object indexTypesLock = new Object();
    private volatile boolean hasIndexedAttributes = false;
    private volatile byte[] indexTypes = null;
    private volatile int size = 0;

    public MapIndexService(boolean valueIndexed) {
        this.indexValue = valueIndexed ? new Index(null, false, -1) : null;
    }

    public void remove(Record record) {
        Record existingRecord = (Record)this.records.remove(record.getId());
        if (existingRecord != null) {
            --this.size;
        }
    }

    public void index(Record record) {
        Long[] indexValues;
        Long recordId = record.getId();
        if (record.isActive()) {
            Record anotherRecord = this.records.putIfAbsent(recordId, record);
            if (anotherRecord != null) {
                record = anotherRecord;
            } else {
                ++this.size;
            }
        } else {
            this.remove(record);
        }
        if (this.indexValue != null) {
            Long newValueIndex = -1L;
            if (record.isActive() && record.getValueData() != null) {
                newValueIndex = record.getValueData().hashCode();
            }
            this.indexValue.index(newValueIndex, record);
        }
        if ((indexValues = record.getIndexes()) != null && this.hasIndexedAttributes) {
            byte[] indexTypes = record.getIndexTypes();
            if (indexTypes == null || indexValues.length != indexTypes.length) {
                throw new IllegalArgumentException("index and types don't match " + Arrays.toString(indexTypes));
            }
            Collection<Index> indexes = this.mapIndexes.values();
            for (Index index : indexes) {
                if (indexValues.length <= index.getAttributeIndex()) continue;
                Long newValue = indexValues[index.getAttributeIndex()];
                index.index(newValue, record);
            }
        }
    }

    public Collection<Record> getOwnedRecords() {
        return this.records.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long[] getIndexValues(Object value) {
        if (this.hasIndexedAttributes) {
            int indexCount = this.mapIndexes.size();
            Long[] newIndexes = new Long[indexCount];
            if (value instanceof Data) {
                value = IOUtil.toObject((Data)value);
            }
            Collection<Index> indexes = this.mapIndexes.values();
            for (Index index : indexes) {
                int attributedIndex = index.getAttributeIndex();
                newIndexes[attributedIndex] = index.extractLongValue(value);
            }
            if (this.indexTypes == null || this.indexTypes.length != indexCount) {
                Object object = this.indexTypesLock;
                synchronized (object) {
                    if (this.indexTypes == null || this.indexTypes.length != indexCount) {
                        this.indexTypes = new byte[indexCount];
                        for (Index index : indexes) {
                            int attributedIndex = index.getAttributeIndex();
                            this.indexTypes[attributedIndex] = index.getIndexType();
                        }
                    }
                }
            }
            return newIndexes;
        }
        return null;
    }

    public byte[] getIndexTypes() {
        return this.indexTypes;
    }

    public Index addIndex(Expression expression, boolean ordered, int attributeIndex) {
        Index index = this.mapIndexes.get(expression);
        if (index == null) {
            if (attributeIndex == -1) {
                attributeIndex = this.mapIndexes.size();
            }
            index = new Index(expression, ordered, attributeIndex);
            this.mapIndexes.put(expression, index);
            this.indexTypes = null;
            this.hasIndexedAttributes = true;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MapEntry> doQuery(QueryContext queryContext) {
        boolean strong = false;
        HashSet<MapEntry> results = null;
        Predicate predicate = queryContext.getPredicate();
        queryContext.setMapIndexes(this.mapIndexes);
        try {
            if (predicate != null && this.mapIndexes != null && predicate instanceof IndexAwarePredicate) {
                IndexAwarePredicate iap = (IndexAwarePredicate)predicate;
                ArrayList<IndexAwarePredicate> lsIndexAwarePredicates = new ArrayList<IndexAwarePredicate>();
                strong = iap.collectIndexAwarePredicates(lsIndexAwarePredicates, this.mapIndexes);
                if (strong) {
                    HashSet<Index> setAppliedIndexes = new HashSet<Index>(1);
                    iap.collectAppliedIndexes(setAppliedIndexes, this.mapIndexes);
                    if (setAppliedIndexes.size() > 0) {
                        for (Index index : setAppliedIndexes) {
                            if (!strong) continue;
                            strong = index.isStrong();
                        }
                    }
                }
                int indexAwarePredicateCount = lsIndexAwarePredicates.size();
                queryContext.setIndexedPredicateCount(indexAwarePredicateCount);
                if (indexAwarePredicateCount == 1) {
                    IndexAwarePredicate indexAwarePredicate = (IndexAwarePredicate)lsIndexAwarePredicates.get(0);
                    Set<MapEntry> sub = indexAwarePredicate.filter(queryContext);
                    if (sub == null || sub.size() == 0) {
                        Set<MapEntry> set = null;
                        return set;
                    }
                    Set<MapEntry> set = sub;
                    return set;
                }
                if (indexAwarePredicateCount > 0) {
                    IndexAwarePredicate indexAwarePredicateFirst = (IndexAwarePredicate)lsIndexAwarePredicates.get(0);
                    Set<MapEntry> subFirst = indexAwarePredicateFirst.filter(queryContext);
                    if (subFirst != null && subFirst.size() < 11) {
                        strong = true;
                        HashSet<MapEntry> resultSet = new HashSet<MapEntry>(subFirst);
                        for (int i = 1; i < lsIndexAwarePredicates.size(); ++i) {
                            IndexAwarePredicate p = (IndexAwarePredicate)lsIndexAwarePredicates.get(i);
                            Iterator it = resultSet.iterator();
                            while (it.hasNext()) {
                                Record record = (Record)it.next();
                                if (p.apply(record)) continue;
                                it.remove();
                            }
                        }
                        HashSet<MapEntry> i = resultSet;
                        return i;
                    }
                    if (subFirst != null) {
                        ArrayList<Set<MapEntry>> lsSubResults = new ArrayList<Set<MapEntry>>(indexAwarePredicateCount);
                        lsSubResults.add(subFirst);
                        Set<MapEntry> smallestSet = subFirst;
                        for (int i = 1; i < indexAwarePredicateCount; ++i) {
                            IndexAwarePredicate p = (IndexAwarePredicate)lsIndexAwarePredicates.get(i);
                            Set<MapEntry> sub = p.filter(queryContext);
                            if (sub == null) {
                                strong = false;
                                continue;
                            }
                            if (sub.size() == 0) {
                                strong = true;
                                Set<MapEntry> set = null;
                                return set;
                            }
                            if (sub.size() < smallestSet.size()) {
                                smallestSet = sub;
                            }
                            lsSubResults.add(sub);
                        }
                        if (smallestSet == null) {
                            Set<MapEntry> i = null;
                            return i;
                        }
                        results = new HashSet<MapEntry>(smallestSet.size());
                        block13: for (MapEntry entry : smallestSet) {
                            for (Set set : lsSubResults) {
                                if (set.contains(entry)) continue;
                                continue block13;
                            }
                            results.add(entry);
                        }
                        HashSet<MapEntry> hashSet = results;
                        return hashSet;
                    }
                }
            }
            SingleResultSet singleResultSet = new SingleResultSet(this.records);
            return singleResultSet;
        }
        finally {
            queryContext.setStrong(strong);
        }
    }

    public Map<Expression, Index> getIndexes() {
        return this.mapIndexes;
    }

    public boolean hasIndexedAttributes() {
        return this.hasIndexedAttributes;
    }

    public boolean containsValue(Data value) {
        if (this.indexValue != null) {
            Set<MapEntry> results = this.indexValue.getRecords(Long.valueOf(value.hashCode()));
            if (results == null || results.size() == 0) {
                return false;
            }
            for (MapEntry entry : results) {
                Record record = (Record)entry;
                if (!record.containsValue(value)) continue;
                return true;
            }
        } else {
            for (Record record : this.records.values()) {
                if (!record.containsValue(value)) continue;
                return true;
            }
        }
        return false;
    }

    public Index[] getIndexesInOrder() {
        if (this.mapIndexes.size() == 0) {
            return null;
        }
        Index[] indexes = new Index[this.mapIndexes.size()];
        Iterator<Index> i$ = this.mapIndexes.values().iterator();
        while (i$.hasNext()) {
            Index index;
            indexes[index.getAttributeIndex()] = index = i$.next();
        }
        return indexes;
    }

    public void appendState(StringBuffer sbState) {
        sbState.append("\nIndex- records: " + this.records.size() + ", mapIndexes:" + this.mapIndexes.size() + ", indexTypes:" + (this.indexTypes == null ? 0 : this.indexTypes.length));
        for (Index index : this.mapIndexes.values()) {
            index.appendState(sbState);
        }
    }

    public void clear() {
        this.mapIndexes.clear();
        this.records.clear();
        this.size = 0;
    }

    public int size() {
        return this.size;
    }
}

