/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.nio.AbstractSerializer;
import com.hazelcast.nio.Data;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Serializer
extends AbstractSerializer {
    private static final AbstractSerializer.TypeSerializer[] serializers = Serializer.sort(new AbstractSerializer.TypeSerializer[]{new AbstractSerializer.DataSerializer(), new AbstractSerializer.ByteArraySerializer(), new AbstractSerializer.LongSerializer(), new AbstractSerializer.IntegerSerializer(), new AbstractSerializer.StringSerializer(), new AbstractSerializer.ClassSerializer(), new AbstractSerializer.DateSerializer(), new AbstractSerializer.BigIntegerSerializer(), new AbstractSerializer.Externalizer(), new AbstractSerializer.ObjectSerializer()});

    public Serializer() {
        super(serializers);
    }

    public static Object newInstance(Class klass) throws Exception {
        return AbstractSerializer.newInstance(klass);
    }

    public static Class<?> classForName(String className) throws ClassNotFoundException {
        return AbstractSerializer.classForName(className);
    }

    public static Class<?> classForName(ClassLoader classLoader, String className) throws ClassNotFoundException {
        return AbstractSerializer.classForName(classLoader, className);
    }

    public Data writeObject(Object obj) {
        if (obj instanceof Data) {
            return (Data)obj;
        }
        byte[] bytes = this.toByteArray(obj);
        if (bytes == null) {
            return null;
        }
        return new Data(bytes);
    }

    public Object readObject(Data data) {
        if (data == null || data.buffer == null || data.buffer.length == 0) {
            return null;
        }
        byte[] byteArray = data.buffer;
        Object obj = this.toObject(byteArray);
        if (obj instanceof HazelcastInstanceAware) {
            ((HazelcastInstanceAware)obj).setHazelcastInstance(ThreadContext.get().getCurrentFactory());
        }
        return obj;
    }

    @Override
    public byte[] toByteArray(Object obj) {
        return super.toByteArray(obj);
    }
}

