/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.impl.GroupProperties;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.FastByteArrayInputStream;
import com.hazelcast.nio.FastByteArrayOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSerializer {
    private static final ILogger logger = Logger.getLogger(AbstractSerializer.class.getName());
    private static final byte SERIALIZER_TYPE_DATA = 0;
    private static final byte SERIALIZER_TYPE_OBJECT = 1;
    private static final byte SERIALIZER_TYPE_BYTE_ARRAY = 2;
    private static final byte SERIALIZER_TYPE_INTEGER = 3;
    private static final byte SERIALIZER_TYPE_LONG = 4;
    private static final byte SERIALIZER_TYPE_CLASS = 5;
    private static final byte SERIALIZER_TYPE_STRING = 6;
    private static final byte SERIALIZER_TYPE_DATE = 7;
    private static final byte SERIALIZER_TYPE_BIG_INTEGER = 8;
    private static final byte SERIALIZER_TYPE_EXTERNALIZABLE = 9;
    private static final boolean shared = GroupProperties.SERIALIZER_SHARED.getBoolean();
    private static final boolean gzipEnabled = GroupProperties.SERIALIZER_GZIP_ENABLED.getBoolean();
    protected static int OUTPUT_STREAM_BUFFER_SIZE = 102400;
    private final TypeSerializer[] serializer;
    private final TypeSerializer[] typeSerializer;
    final FastByteArrayOutputStream bbos;
    protected final FastByteArrayInputStream bbis;

    protected static TypeSerializer[] sort(TypeSerializer[] serializers) {
        Arrays.sort(serializers, new Comparator<TypeSerializer>(){

            @Override
            public int compare(TypeSerializer o1, TypeSerializer o2) {
                int p2;
                int p1 = o1.priority();
                return p1 < (p2 = o2.priority()) ? -1 : (p1 == p2 ? 0 : 1);
            }
        });
        return serializers;
    }

    public AbstractSerializer(TypeSerializer[] serializer) {
        this.serializer = serializer;
        this.typeSerializer = new TypeSerializer[serializer.length];
        for (int i = 0; i < serializer.length; ++i) {
            this.typeSerializer[serializer[i].getTypeId()] = serializer[i];
        }
        this.bbis = new FastByteArrayInputStream(new byte[10]);
        this.bbos = new FastByteArrayOutputStream(OUTPUT_STREAM_BUFFER_SIZE);
    }

    public static Object newInstance(Class klass) throws Exception {
        Constructor constructor = klass.getDeclaredConstructor(new Class[0]);
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        return constructor.newInstance(new Object[0]);
    }

    public static Class<?> classForName(String className) throws ClassNotFoundException {
        return AbstractSerializer.classForName(null, className);
    }

    public static Class<?> classForName(ClassLoader classLoader, String className) throws ClassNotFoundException {
        if (className == null) {
            throw new IllegalArgumentException("ClassName cannot be null!");
        }
        if (className.startsWith("com.hazelcast")) {
            return Class.forName(className, true, AbstractSerializer.class.getClassLoader());
        }
        ClassLoader theClassLoader = classLoader;
        if (theClassLoader == null) {
            theClassLoader = Thread.currentThread().getContextClassLoader();
        }
        if (theClassLoader != null) {
            return Class.forName(className, true, theClassLoader);
        }
        return Class.forName(className);
    }

    protected final void toByte(FastByteArrayOutputStream bos, Object object) {
        if (object == null) {
            return;
        }
        try {
            int typeId = -1;
            for (int i = 0; i < this.serializer.length; ++i) {
                if (!this.serializer[i].isSuitable(object)) continue;
                typeId = this.serializer[i].getTypeId();
                break;
            }
            if (typeId == -1) {
                throw new NotSerializableException("There is no suitable serializer for " + object.getClass().getName());
            }
            bos.writeByte(typeId);
            this.typeSerializer[typeId].write(bos, object);
            bos.flush();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    protected final Object toObject(FastByteArrayInputStream bis) {
        try {
            byte typeId = bis.readByte();
            if (typeId < 0 || typeId >= this.typeSerializer.length) {
                throw new IllegalArgumentException("There is no suitable deserializer for type 0x" + Integer.toHexString(typeId));
            }
            return this.typeSerializer[typeId].read(bis);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public byte[] toByteArray(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            this.bbos.reset();
            this.toByte(this.bbos, obj);
            byte[] result = this.bbos.toByteArray();
            if (this.bbos.size() > OUTPUT_STREAM_BUFFER_SIZE) {
                this.bbos.set(new byte[OUTPUT_STREAM_BUFFER_SIZE]);
            }
            return result;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public Object toObject(byte[] byteArray) {
        if (byteArray == null || byteArray.length == 0) {
            return null;
        }
        this.bbis.set(byteArray, byteArray.length);
        return this.toObject(this.bbis);
    }

    public static final ObjectInputStream newObjectInputStream(InputStream in) throws IOException {
        return new ObjectInputStream(in){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
                return AbstractSerializer.classForName(desc.getName());
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TypeSerializer<T> {
        public int priority();

        public boolean isSuitable(Object var1);

        public byte getTypeId();

        public void write(FastByteArrayOutputStream var1, T var2) throws Exception;

        public T read(FastByteArrayInputStream var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjectSerializer
    implements TypeSerializer<Object> {
        @Override
        public final int priority() {
            return Integer.MAX_VALUE;
        }

        @Override
        public final boolean isSuitable(Object obj) {
            return obj instanceof Serializable;
        }

        @Override
        public final byte getTypeId() {
            return 1;
        }

        @Override
        public final Object read(FastByteArrayInputStream bbis) throws Exception {
            if (gzipEnabled) {
                return this.readGZip(bbis);
            }
            return this.readNormal(bbis);
        }

        @Override
        public final void write(FastByteArrayOutputStream bbos, Object obj) throws Exception {
            if (gzipEnabled) {
                this.writeGZip(bbos, obj);
            } else {
                this.writeNormal(bbos, obj);
            }
        }

        private Object readGZip(FastByteArrayInputStream bbis) throws Exception {
            BufferedInputStream zis = new BufferedInputStream(new GZIPInputStream(bbis));
            ObjectInputStream in = AbstractSerializer.newObjectInputStream(zis);
            Object result = shared ? in.readObject() : in.readUnshared();
            in.close();
            return result;
        }

        private Object readNormal(FastByteArrayInputStream bbis) throws Exception {
            ObjectInputStream in = AbstractSerializer.newObjectInputStream(bbis);
            Object result = shared ? in.readObject() : in.readUnshared();
            in.close();
            return result;
        }

        private void writeGZip(FastByteArrayOutputStream bbos, Object obj) throws Exception {
            BufferedOutputStream zos = new BufferedOutputStream(new GZIPOutputStream(bbos));
            ObjectOutputStream os = new ObjectOutputStream(zos);
            if (shared) {
                os.writeObject(obj);
            } else {
                os.writeUnshared(obj);
            }
            os.flush();
            os.close();
        }

        private void writeNormal(FastByteArrayOutputStream bbos, Object obj) throws Exception {
            ObjectOutputStream os = new ObjectOutputStream(bbos);
            if (shared) {
                os.writeObject(obj);
            } else {
                os.writeUnshared(obj);
            }
            os.flush();
            os.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Externalizer
    implements TypeSerializer<Externalizable> {
        @Override
        public final int priority() {
            return 50;
        }

        @Override
        public final boolean isSuitable(Object obj) {
            return obj instanceof Externalizable;
        }

        @Override
        public final byte getTypeId() {
            return 9;
        }

        @Override
        public final Externalizable read(FastByteArrayInputStream bbis) throws Exception {
            String className = bbis.readUTF();
            try {
                Externalizable ds = (Externalizable)AbstractSerializer.newInstance(AbstractSerializer.classForName(className));
                ds.readExternal(AbstractSerializer.newObjectInputStream(bbis));
                return ds;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException("Problem reading Externalizable class : " + className + ", exception: " + e);
            }
        }

        @Override
        public final void write(FastByteArrayOutputStream bbos, Externalizable obj) throws Exception {
            bbos.writeUTF(obj.getClass().getName());
            ObjectOutputStream out = new ObjectOutputStream(bbos);
            obj.writeExternal(out);
            out.flush();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DataSerializer
    implements TypeSerializer<DataSerializable> {
        @Override
        public final int priority() {
            return 0;
        }

        @Override
        public final boolean isSuitable(Object obj) {
            return obj instanceof DataSerializable;
        }

        @Override
        public final byte getTypeId() {
            return 0;
        }

        protected Class classForName(String className) throws ClassNotFoundException {
            return AbstractSerializer.classForName(className);
        }

        protected String toClassName(Class clazz) throws ClassNotFoundException {
            return clazz.getName();
        }

        @Override
        public final DataSerializable read(FastByteArrayInputStream bbis) throws Exception {
            String className = bbis.readUTF();
            try {
                DataSerializable ds = (DataSerializable)AbstractSerializer.newInstance(this.classForName(className));
                ds.readData(bbis);
                return ds;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException("Problem reading DataSerializable class : " + className + ", exception: " + e);
            }
        }

        @Override
        public final void write(FastByteArrayOutputStream bbos, DataSerializable obj) throws Exception {
            bbos.writeUTF(this.toClassName(obj.getClass()));
            obj.writeData(bbos);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByteArraySerializer
    implements TypeSerializer<byte[]> {
        @Override
        public final int priority() {
            return 100;
        }

        @Override
        public final boolean isSuitable(Object obj) {
            return obj instanceof byte[];
        }

        @Override
        public final byte getTypeId() {
            return 2;
        }

        @Override
        public final byte[] read(FastByteArrayInputStream bbis) throws Exception {
            int size = bbis.readInt();
            byte[] bytes = new byte[size];
            bbis.readFully(bytes);
            return bytes;
        }

        @Override
        public final void write(FastByteArrayOutputStream bbos, byte[] obj) throws Exception {
            bbos.writeInt(obj.length);
            bbos.write(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringSerializer
    implements TypeSerializer<String> {
        @Override
        public final int priority() {
            return 400;
        }

        @Override
        public final boolean isSuitable(Object obj) {
            return obj instanceof String;
        }

        @Override
        public final byte getTypeId() {
            return 6;
        }

        @Override
        public final String read(FastByteArrayInputStream bbis) throws Exception {
            return bbis.readUTF();
        }

        @Override
        public final void write(FastByteArrayOutputStream bbos, String obj) throws Exception {
            bbos.writeUTF(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassSerializer
    implements TypeSerializer<Class> {
        @Override
        public final int priority() {
            return 500;
        }

        @Override
        public final boolean isSuitable(Object obj) {
            return obj instanceof Class;
        }

        @Override
        public final byte getTypeId() {
            return 5;
        }

        @Override
        public final Class read(FastByteArrayInputStream bbis) throws Exception {
            return this.classForName(bbis.readUTF());
        }

        protected Class classForName(String className) throws ClassNotFoundException {
            return AbstractSerializer.classForName(className);
        }

        @Override
        public final void write(FastByteArrayOutputStream bbos, Class obj) throws Exception {
            bbos.writeUTF(obj.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntegerSerializer
    implements TypeSerializer<Integer> {
        @Override
        public final int priority() {
            return 300;
        }

        @Override
        public final boolean isSuitable(Object obj) {
            return obj instanceof Integer;
        }

        @Override
        public final byte getTypeId() {
            return 3;
        }

        @Override
        public final Integer read(FastByteArrayInputStream bbis) throws Exception {
            return bbis.readInt();
        }

        @Override
        public final void write(FastByteArrayOutputStream bbos, Integer obj) throws Exception {
            bbos.writeInt(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BigIntegerSerializer
    implements TypeSerializer<BigInteger> {
        @Override
        public final int priority() {
            return 600;
        }

        @Override
        public final boolean isSuitable(Object obj) {
            return obj instanceof BigInteger;
        }

        @Override
        public final byte getTypeId() {
            return 8;
        }

        @Override
        public final BigInteger read(FastByteArrayInputStream bbis) throws Exception {
            byte[] bytes = new byte[bbis.readInt()];
            bbis.readFully(bytes);
            return new BigInteger(bytes);
        }

        @Override
        public final void write(FastByteArrayOutputStream bbos, BigInteger obj) throws Exception {
            byte[] bytes = obj.toByteArray();
            bbos.writeInt(bytes.length);
            bbos.write(bytes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateSerializer
    implements TypeSerializer<Date> {
        @Override
        public int priority() {
            return 500;
        }

        @Override
        public final boolean isSuitable(Object obj) {
            return obj instanceof Date;
        }

        @Override
        public final byte getTypeId() {
            return 7;
        }

        @Override
        public final Date read(FastByteArrayInputStream bbis) throws Exception {
            return new Date(bbis.readLong());
        }

        @Override
        public final void write(FastByteArrayOutputStream bbos, Date obj) throws Exception {
            bbos.writeLong(obj.getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongSerializer
    implements TypeSerializer<Long> {
        @Override
        public final int priority() {
            return 200;
        }

        @Override
        public final boolean isSuitable(Object obj) {
            return obj instanceof Long;
        }

        @Override
        public final byte getTypeId() {
            return 4;
        }

        @Override
        public final Long read(FastByteArrayInputStream bbis) throws Exception {
            return bbis.readLong();
        }

        @Override
        public final void write(FastByteArrayOutputStream bbos, Long obj) throws Exception {
            bbos.writeLong(obj);
        }
    }
}

