/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor;

import com.hazelcast.core.Member;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.MemberStateImpl;
import com.hazelcast.monitor.ClusterStateView;
import com.hazelcast.monitor.ClusterStateViewImpl;
import com.hazelcast.monitor.MemberState;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedClusterState
implements DataSerializable {
    long time;
    Map<Member, MemberState> memberStates = new ConcurrentHashMap<Member, MemberState>();
    ClusterStateView clusterStateView;

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeLong(this.time);
        out.writeInt(this.memberStates.size());
        Set<Map.Entry<Member, MemberState>> memberStateEntries = this.memberStates.entrySet();
        for (Map.Entry<Member, MemberState> memberStatEntry : memberStateEntries) {
            memberStatEntry.getKey().writeData(out);
            memberStatEntry.getValue().writeData(out);
        }
        if (this.clusterStateView != null) {
            out.writeBoolean(true);
            this.clusterStateView.writeData(out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.time = in.readLong();
        int memberStatsCount = in.readInt();
        for (int i = 0; i < memberStatsCount; ++i) {
            MemberImpl member = new MemberImpl();
            member.readData(in);
            MemberStateImpl memberStateImpl = new MemberStateImpl();
            memberStateImpl.readData(in);
            this.memberStates.put(member, memberStateImpl);
        }
        if (in.readBoolean()) {
            this.clusterStateView = new ClusterStateViewImpl();
            this.clusterStateView.readData(in);
        }
    }

    public boolean containsKey(Member member) {
        return this.memberStates.containsKey(member);
    }

    public void putMemberState(Member member, MemberState mapStat) {
        this.memberStates.put(member, mapStat);
    }

    public Map<Member, MemberState> getMemberState() {
        return this.memberStates;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public ClusterStateView getClusterStateView() {
        return this.clusterStateView;
    }

    public void setClusterStateView(ClusterStateView clusterStateView) {
        this.clusterStateView = clusterStateView;
    }
}

