/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.base;

import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.IGetAwareProxy;
import com.hazelcast.impl.MProxy;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

public class KeyValue
implements Map.Entry,
DataSerializable {
    Data key = null;
    Data value = null;
    Object objKey = null;
    Object objValue = null;
    String name = null;
    FactoryImpl factory;

    public KeyValue() {
    }

    public KeyValue(Data key, Data value) {
        this.key = key;
        this.value = value;
    }

    public void writeData(DataOutput out) throws IOException {
        this.key.writeData(out);
        boolean gotValue = this.value != null && this.value.size() > 0;
        out.writeBoolean(gotValue);
        if (gotValue) {
            this.value.writeData(out);
        }
    }

    public void readData(DataInput in) throws IOException {
        this.key = new Data();
        this.key.readData(in);
        boolean gotValue = in.readBoolean();
        if (gotValue) {
            this.value = new Data();
            this.value.readData(in);
        }
    }

    public Data getKeyData() {
        return this.key;
    }

    public Data getValueData() {
        return this.value;
    }

    public Object getKey() {
        if (this.objKey == null) {
            this.objKey = IOUtil.toObject(this.key);
        }
        return this.objKey;
    }

    public Object getValue() {
        if (this.objValue == null) {
            this.objValue = this.value != null ? IOUtil.toObject(this.value) : ((IGetAwareProxy)this.factory.getOrCreateProxyByName(this.name)).get(this.key == null ? this.getKey() : this.key);
        }
        return this.objValue;
    }

    public Object setValue(Object newValue) {
        if (this.name == null) {
            throw new UnsupportedOperationException();
        }
        this.objValue = this.value;
        return ((MProxy)this.factory.getOrCreateProxyByName(this.name)).put(this.key, newValue);
    }

    public void setName(FactoryImpl factoryImpl, String name) {
        this.factory = factoryImpl;
        this.name = name;
    }

    public String toString() {
        return "Map.Entry key=" + this.getKey() + ", value=" + this.getValue();
    }
}

