/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.LocalQueueOperationStatsImpl;
import com.hazelcast.monitor.LocalQueueOperationStats;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueOperationsCounter {
    private AtomicLong offers = new AtomicLong();
    private AtomicLong rejectedOffers = new AtomicLong();
    private AtomicLong polls = new AtomicLong();
    private AtomicLong emptyPolls = new AtomicLong();
    private AtomicLong others = new AtomicLong();
    private AtomicLong events = new AtomicLong();
    private long startTime = this.now();
    private long endTime = Long.MAX_VALUE;
    private transient LocalQueueOperationStats published = null;
    private List<QueueOperationsCounter> listOfSubStats = new ArrayList<QueueOperationsCounter>();
    private final Object lock = new Object();
    private final LocalQueueOperationStats empty = new LocalQueueOperationStatsImpl();
    private final long interval;

    public QueueOperationsCounter() {
        this(5000L);
    }

    public QueueOperationsCounter(long interval) {
        this.interval = interval;
    }

    private QueueOperationsCounter getAndReset() {
        QueueOperationsCounter newOne = new QueueOperationsCounter();
        newOne.offers.set(this.offers.getAndSet(0L));
        newOne.polls.set(this.polls.getAndSet(0L));
        newOne.rejectedOffers.set(this.rejectedOffers.getAndSet(0L));
        newOne.emptyPolls.set(this.emptyPolls.getAndSet(0L));
        newOne.others.set(this.others.getAndSet(0L));
        newOne.events.set(this.events.getAndSet(0L));
        newOne.startTime = this.startTime;
        this.startTime = newOne.endTime = this.now();
        return newOne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalQueueOperationStats getPublishedStats() {
        if (this.published == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.published == null) {
                    this.published = this.getThis();
                }
            }
        }
        if (this.published.getPeriodEnd() < this.now() - this.interval) {
            return this.empty;
        }
        return this.published;
    }

    public void incrementOffers() {
        this.offers.incrementAndGet();
        this.publishSubResult();
    }

    public void incrementRejectedOffers() {
        this.rejectedOffers.incrementAndGet();
        this.publishSubResult();
    }

    public void incrementPolls() {
        this.polls.incrementAndGet();
        this.publishSubResult();
    }

    public void incrementEmptyPolls() {
        this.emptyPolls.incrementAndGet();
        this.publishSubResult();
    }

    public void incrementOtherOperations() {
        this.others.incrementAndGet();
        this.publishSubResult();
    }

    public void incrementReceivedEvents() {
        this.events.incrementAndGet();
        this.publishSubResult();
    }

    long now() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishSubResult() {
        long subInterval = this.interval / 5L;
        if (this.now() - this.startTime > subInterval) {
            Object object = this.lock;
            synchronized (object) {
                if (this.now() - this.startTime >= subInterval) {
                    QueueOperationsCounter copy = this.getAndReset();
                    if (this.listOfSubStats.size() == 5) {
                        this.listOfSubStats.remove(0);
                    }
                    this.listOfSubStats.add(copy);
                    this.published = this.aggregate(this.listOfSubStats);
                }
            }
        }
    }

    private LocalQueueOperationStats aggregate(List<QueueOperationsCounter> list) {
        LocalQueueOperationStatsImpl stats = new LocalQueueOperationStatsImpl();
        stats.periodStart = list.get((int)0).startTime;
        for (int i = 0; i < list.size(); ++i) {
            QueueOperationsCounter sub = list.get(i);
            stats.numberOfPolls += sub.polls.get();
            stats.numberOfOffers += sub.offers.get();
            stats.numberOfRejectedOffers += sub.rejectedOffers.get();
            stats.numberOfEmptyPolls += sub.emptyPolls.get();
            stats.numberOfOtherOperations += sub.others.get();
            stats.numberOfEvents += sub.events.get();
            stats.periodEnd = sub.endTime;
        }
        return stats;
    }

    private LocalQueueOperationStats getThis() {
        LocalQueueOperationStatsImpl stats = new LocalQueueOperationStatsImpl();
        stats.periodStart = this.startTime;
        stats.numberOfPolls = this.polls.get();
        stats.numberOfOffers = this.offers.get();
        stats.numberOfEmptyPolls = this.emptyPolls.get();
        stats.numberOfRejectedOffers = this.rejectedOffers.get();
        stats.numberOfEvents = this.events.get();
        stats.periodEnd = this.now();
        return stats;
    }
}

