/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.Connection;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.IORunnable;
import com.hazelcast.client.NoMemberAvailableException;
import com.hazelcast.client.Packet;
import com.hazelcast.client.PacketWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutRunnable
extends IORunnable {
    final PacketWriter writer;
    final BlockingQueue<Call> queue = new LinkedBlockingQueue<Call>();
    private Connection connection = null;
    final AtomicBoolean reconnection;
    private final Collection<Call> reconnectionCalls = new LinkedBlockingQueue<Call>();

    public OutRunnable(HazelcastClient client, Map<Long, Call> calls, PacketWriter writer) {
        super(client, calls);
        this.writer = writer;
        this.reconnection = new AtomicBoolean(false);
    }

    @Override
    protected void customRun() throws InterruptedException {
        if (this.reconnection.get()) {
            Thread.sleep(50L);
            return;
        }
        Call call = this.queue.poll(100L, TimeUnit.MILLISECONDS);
        try {
            if (call == null) {
                if (this.reconnectionCalls.size() > 0) {
                    this.checkOnReconnect(call);
                }
                return;
            }
            if (call != RECONNECT_CALL) {
                this.callMap.put(call.getId(), call);
            }
            Connection oldConnection = this.connection;
            this.connection = this.client.getConnectionManager().getConnection();
            boolean wrote = false;
            if (this.restoredConnection(oldConnection, this.connection)) {
                this.resubscribe(call, oldConnection);
            } else if (this.connection != null) {
                if (call != RECONNECT_CALL) {
                    this.logger.log(Level.FINEST, "Sending: " + call);
                    this.writer.write(this.connection, call.getRequest());
                    wrote = true;
                }
            } else {
                this.enQueue(call);
                this.clusterIsDown(oldConnection);
                return;
            }
            if (this.connection != null && wrote) {
                this.writer.flush(this.connection);
            }
            if (this.reconnectionCalls.size() > 0) {
                this.checkOnReconnect(call);
            }
        }
        catch (Throwable io) {
            this.logger.log(Level.WARNING, "OutRunnable [" + this.connection + "] got exception:" + io.getMessage(), io);
            this.clusterIsDown(this.connection);
        }
    }

    private void checkOnReconnect(Call call) {
        try {
            Object response;
            Object object = response = this.reconnectionCalls.contains(call) ? call.getResponse(100L, TimeUnit.MILLISECONDS) : null;
            if (response != null) {
                this.reconnectionCalls.remove(call);
            } else {
                Iterator<Call> it = this.reconnectionCalls.iterator();
                while (it.hasNext()) {
                    Call c = it.next();
                    response = !c.hasResponse() ? c.getResponse(100L, TimeUnit.MILLISECONDS) : Boolean.TRUE;
                    if (response == null) continue;
                    it.remove();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.reconnectionCalls.size() == 0) {
            this.client.getConnectionManager().notifyConnectionIsOpened();
        }
    }

    @Override
    public void interruptWaitingCalls() {
        super.interruptWaitingCalls();
        LinkedBlockingQueue<Call> temp = new LinkedBlockingQueue<Call>();
        this.queue.drainTo(temp);
        this.clearCalls(temp);
        this.clearCalls(this.reconnectionCalls);
        this.reconnectionCalls.clear();
    }

    private void clearCalls(Collection<Call> calls) {
        if (calls == null) {
            return;
        }
        Iterator<Call> it = calls.iterator();
        while (it.hasNext()) {
            Call c = it.next();
            if (c == RECONNECT_CALL) continue;
            c.setResponse(new NoMemberAvailableException());
            it.remove();
        }
    }

    void clusterIsDown(Connection oldConnection) {
        if (!this.running) {
            return;
        }
        this.client.getConnectionManager().destroyConnection(oldConnection);
        if (this.reconnection.compareAndSet(false, true)) {
            this.client.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Connection lookForAliveConnection = OutRunnable.this.client.getConnectionManager().lookForAliveConnection();
                        if (lookForAliveConnection == null) {
                            OutRunnable.this.logger.log(Level.WARNING, "lookForAliveConnection is null, reconnection: " + OutRunnable.this.reconnection);
                            if (OutRunnable.this.reconnection.get()) {
                                OutRunnable.this.interruptWaitingCalls();
                            }
                        } else if (OutRunnable.this.running) {
                            OutRunnable.this.enQueue(IORunnable.RECONNECT_CALL);
                        }
                    }
                    catch (IOException e) {
                        OutRunnable.this.logger.log(Level.WARNING, Thread.currentThread().getName() + " got exception:" + e.getMessage(), e);
                    }
                    finally {
                        OutRunnable.this.reconnection.compareAndSet(true, false);
                    }
                }
            });
        }
    }

    private void resubscribe(Call call, Connection oldConnection) {
        this.onDisconnect(oldConnection);
        LinkedBlockingQueue<Call> temp = new LinkedBlockingQueue<Call>();
        this.queue.drainTo(temp);
        temp.remove(RECONNECT_CALL);
        this.reconnectionCalls.addAll(this.client.getListenerManager().getListenerCalls());
        this.queue.addAll(this.reconnectionCalls);
        temp.drainTo(this.queue);
        this.queue.addAll(this.callMap.values());
    }

    public void enQueue(Call call) {
        try {
            if (!this.running) {
                throw new NoMemberAvailableException("Client is shutdown.");
            }
            this.logger.log(Level.FINEST, "From " + Thread.currentThread() + ": Enqueue: " + call);
            this.queue.put(call);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    boolean sendReconnectCall(Connection connection) {
        if (this.running && !this.reconnection.get() && this.connection != connection && !this.queue.contains(RECONNECT_CALL)) {
            this.enQueue(RECONNECT_CALL);
            return true;
        }
        return false;
    }

    void write(Connection connection, Packet packet) throws IOException {
        if (this.running) {
            this.client.getOutRunnable().writer.write(connection, packet);
            this.client.getOutRunnable().writer.flush(connection);
        }
    }
}

