/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query;

import com.hazelcast.core.MapEntry;
import com.hazelcast.impl.Record;
import com.hazelcast.query.IndexStore;
import com.hazelcast.query.MultiResultSet;
import com.hazelcast.query.SingleResultSet;
import com.hazelcast.util.NavigableSet;
import com.hazelcast.util.concurrent.ConcurrentSkipListSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedIndexStore
implements IndexStore {
    private final ConcurrentMap<Long, ConcurrentMap<Long, Record>> mapRecords = new ConcurrentHashMap<Long, ConcurrentMap<Long, Record>>(100, 0.75f, 1);
    private final NavigableSet<Long> sortedSet = new ConcurrentSkipListSet<Long>();

    @Override
    public void getSubRecordsBetween(MultiResultSet results, long from, long to) {
        SortedSet<Long> values = this.sortedSet.subSet(from, to);
        for (Long value : values) {
            ConcurrentMap records = (ConcurrentMap)this.mapRecords.get(value);
            if (records == null) continue;
            results.addResultSet(value, records.values());
        }
        ConcurrentMap records = (ConcurrentMap)this.mapRecords.get(to);
        if (records != null) {
            results.addResultSet(to, records.values());
        }
    }

    @Override
    public void getSubRecords(MultiResultSet results, boolean equal, boolean lessThan, long searchedValue) {
        ConcurrentMap records;
        SortedSet<Long> values = lessThan ? this.sortedSet.headSet(searchedValue) : this.sortedSet.tailSet(searchedValue);
        for (Long value : values) {
            ConcurrentMap records2;
            if (!lessThan && !equal && value.equals(searchedValue) || (records2 = (ConcurrentMap)this.mapRecords.get(value)) == null) continue;
            results.addResultSet(value, records2.values());
        }
        if (lessThan && equal && (records = (ConcurrentMap)this.mapRecords.get(searchedValue)) != null) {
            results.addResultSet(searchedValue, records.values());
        }
    }

    @Override
    public void newRecordIndex(long newValue, Record record) {
        long recordId = record.getId();
        ConcurrentHashMap<Long, Record> records = (ConcurrentHashMap<Long, Record>)this.mapRecords.get(newValue);
        if (records == null) {
            records = new ConcurrentHashMap<Long, Record>(1, 0.75f, 1);
            this.mapRecords.put(newValue, records);
            this.sortedSet.add(newValue);
        }
        records.put(recordId, record);
    }

    @Override
    public void removeRecordIndex(long oldValue, long recordId) {
        ConcurrentMap records = (ConcurrentMap)this.mapRecords.get(oldValue);
        if (records != null) {
            records.remove(recordId);
            if (records.size() == 0) {
                this.mapRecords.remove(oldValue);
                this.sortedSet.remove(oldValue);
            }
        }
    }

    @Override
    public Set<MapEntry> getRecords(long value) {
        return new SingleResultSet((ConcurrentMap)this.mapRecords.get(value));
    }

    @Override
    public void getRecords(MultiResultSet results, long[] values) {
        long[] arr$ = values;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Long value = arr$[i$];
            ConcurrentMap records = (ConcurrentMap)this.mapRecords.get(value);
            if (records == null) continue;
            results.addResultSet(value, records.values());
        }
    }

    @Override
    public ConcurrentMap<Long, ConcurrentMap<Long, Record>> getMapRecords() {
        return this.mapRecords;
    }

    public String toString() {
        return "SortedIndexStore{mapRecords=" + this.mapRecords.size() + '}';
    }
}

