/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query;

import com.hazelcast.core.MapEntry;
import com.hazelcast.impl.Record;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.query.Expression;
import com.hazelcast.query.Index;
import com.hazelcast.query.IndexAwarePredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.QueryContext;
import com.hazelcast.query.SingleResultSet;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapIndexService {
    private final ConcurrentMap<Long, Record> records = new ConcurrentHashMap<Long, Record>(10000);
    private final Index indexValue;
    private final Map<Expression, Index> mapIndexes = new ConcurrentHashMap<Expression, Index>(2);
    private volatile boolean hasIndexedAttributes = false;
    private volatile byte[] indexTypes = null;
    private final Object indexTypesLock = new Object();

    public MapIndexService(boolean valueIndexed) {
        this.indexValue = valueIndexed ? new Index(null, false, -1) : null;
    }

    public void remove(Record record) {
        this.records.remove(record.getId());
    }

    public void index(Record record) {
        long recordId = record.getId();
        if (record.isActive()) {
            this.records.putIfAbsent(recordId, record);
        } else {
            this.remove(record);
        }
        int newValueIndex = -1;
        if (record.isActive() && record.getValue() != null) {
            newValueIndex = record.getValue().hashCode();
        }
        if (this.indexValue != null) {
            this.indexValue.index(newValueIndex, record);
        }
        long[] indexValues = record.getIndexes();
        byte[] indexTypes = record.getIndexTypes();
        if (indexValues != null && this.hasIndexedAttributes) {
            if (indexTypes == null || indexValues.length != indexTypes.length) {
                throw new IllegalArgumentException("index and types don't match " + indexTypes);
            }
            Collection<Index> indexes = this.mapIndexes.values();
            for (Index index : indexes) {
                if (indexValues.length <= index.getAttributeIndex()) continue;
                long newValue = indexValues[index.getAttributeIndex()];
                index.index(newValue, record);
            }
        }
    }

    public Collection<Record> getOwnedRecords() {
        return this.records.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getIndexValues(Object value) {
        if (this.hasIndexedAttributes) {
            int indexCount = this.mapIndexes.size();
            long[] newIndexes = new long[indexCount];
            if (value instanceof Data) {
                value = IOUtil.toObject((Data)value);
            }
            Collection<Index> indexes = this.mapIndexes.values();
            for (Index index : indexes) {
                int attributedIndex = index.getAttributeIndex();
                newIndexes[attributedIndex] = index.extractLongValue(value);
            }
            if (this.indexTypes == null || this.indexTypes.length != indexCount) {
                Object object = this.indexTypesLock;
                synchronized (object) {
                    if (this.indexTypes == null || this.indexTypes.length != indexCount) {
                        this.indexTypes = new byte[indexCount];
                        for (Index index : indexes) {
                            int attributedIndex = index.getAttributeIndex();
                            this.indexTypes[attributedIndex] = index.getIndexType();
                        }
                    }
                }
            }
            return newIndexes;
        }
        return null;
    }

    public byte[] getIndexTypes() {
        return this.indexTypes;
    }

    public Index addIndex(Expression expression, boolean ordered, int attributeIndex) {
        Index index = this.mapIndexes.get(expression);
        if (index == null) {
            if (attributeIndex == -1) {
                attributeIndex = this.mapIndexes.size();
            }
            index = new Index(expression, ordered, attributeIndex);
            this.mapIndexes.put(expression, index);
            this.indexTypes = null;
            this.hasIndexedAttributes = true;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MapEntry> doQuery(QueryContext queryContext) {
        boolean strong = false;
        AbstractSet results = null;
        Predicate predicate = queryContext.getPredicate();
        queryContext.setMapIndexes(this.mapIndexes);
        try {
            if (predicate != null && this.mapIndexes != null && predicate instanceof IndexAwarePredicate) {
                IndexAwarePredicate iap = (IndexAwarePredicate)predicate;
                ArrayList<IndexAwarePredicate> lsIndexAwarePredicates = new ArrayList<IndexAwarePredicate>();
                strong = iap.collectIndexAwarePredicates(lsIndexAwarePredicates, this.mapIndexes);
                if (strong) {
                    HashSet<Index> setAppliedIndexes = new HashSet<Index>(1);
                    iap.collectAppliedIndexes(setAppliedIndexes, this.mapIndexes);
                    if (setAppliedIndexes.size() > 0) {
                        for (Index index : setAppliedIndexes) {
                            if (!strong) continue;
                            strong = index.isStrong();
                        }
                    }
                }
                queryContext.setIndexedPredicateCount(lsIndexAwarePredicates.size());
                if (lsIndexAwarePredicates.size() == 1) {
                    IndexAwarePredicate indexAwarePredicate = (IndexAwarePredicate)lsIndexAwarePredicates.get(0);
                    Set<MapEntry> sub = indexAwarePredicate.filter(queryContext);
                    if (sub == null || sub.size() == 0) {
                        Index index;
                        index = null;
                        return index;
                    }
                    results = new HashSet(sub.size());
                    for (MapEntry entry : sub) {
                        Record record = (Record)entry;
                        if (!record.isActive()) continue;
                        results.add(record);
                    }
                } else if (lsIndexAwarePredicates.size() > 0) {
                    Set<MapEntry> smallestSet = null;
                    ArrayList<Set<MapEntry>> lsSubResults = new ArrayList<Set<MapEntry>>(lsIndexAwarePredicates.size());
                    for (IndexAwarePredicate indexAwarePredicate : lsIndexAwarePredicates) {
                        Set<MapEntry> sub = indexAwarePredicate.filter(queryContext);
                        if (sub == null) {
                            strong = false;
                            continue;
                        }
                        if (sub.size() == 0) {
                            strong = true;
                            Set<MapEntry> set = null;
                            return set;
                        }
                        if (smallestSet == null) {
                            smallestSet = sub;
                            continue;
                        }
                        if (sub.size() < smallestSet.size()) {
                            lsSubResults.add(smallestSet);
                            smallestSet = sub;
                            continue;
                        }
                        lsSubResults.add(sub);
                    }
                    if (smallestSet == null) {
                        Iterator<Object> i$ = null;
                        return i$;
                    }
                    results = new HashSet(smallestSet.size());
                    block9: for (MapEntry entry : smallestSet) {
                        for (Set set : lsSubResults) {
                            if (set.contains(entry)) continue;
                            continue block9;
                        }
                        results.add(entry);
                    }
                } else {
                    results = new SingleResultSet(this.records);
                }
            } else {
                results = new SingleResultSet(this.records);
            }
        }
        finally {
            queryContext.setStrong(strong);
        }
        return results;
    }

    public Map<Expression, Index> getIndexes() {
        return this.mapIndexes;
    }

    public boolean hasIndexedAttributes() {
        return this.hasIndexedAttributes;
    }

    public boolean containsValue(Data value) {
        if (this.indexValue != null) {
            Set<MapEntry> results = this.indexValue.getRecords(value.hashCode());
            if (results == null || results.size() == 0) {
                return false;
            }
            for (MapEntry entry : results) {
                Record record = (Record)entry;
                if (!record.containsValue(value)) continue;
                return true;
            }
        } else {
            for (Record record : this.records.values()) {
                if (!record.containsValue(value)) continue;
                return true;
            }
        }
        return false;
    }

    public Index[] getIndexesInOrder() {
        if (this.mapIndexes.size() == 0) {
            return null;
        }
        Index[] indexes = new Index[this.mapIndexes.size()];
        Iterator<Index> i$ = this.mapIndexes.values().iterator();
        while (i$.hasNext()) {
            Index index;
            indexes[index.getAttributeIndex()] = index = i$.next();
        }
        return indexes;
    }

    public void appendState(StringBuffer sbState) {
        sbState.append("\nIndex- records: " + this.records.size() + ", mapIndexes:" + this.mapIndexes.size() + ", indexTypes:" + (this.indexTypes == null ? 0 : this.indexTypes.length));
        for (Index index : this.mapIndexes.values()) {
            index.appendState(sbState);
        }
    }

    public void clear() {
    }

    public int size() {
        return this.records.size();
    }
}

