/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.cluster.ClusterService;
import com.hazelcast.impl.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.InSelector;
import com.hazelcast.nio.OutSelector;
import com.hazelcast.nio.SelectionHandler;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

abstract class AbstractSelectionHandler
implements SelectionHandler {
    public static final int RECEIVE_SOCKET_BUFFER_SIZE = 32768;
    public static final int SEND_SOCKET_BUFFER_SIZE = 32768;
    protected final ILogger logger;
    protected final SocketChannel socketChannel;
    protected final Connection connection;
    protected final InSelector inSelector;
    protected final OutSelector outSelector;
    protected final ClusterService clusterService;
    protected final Node node;
    protected SelectionKey sk = null;

    public AbstractSelectionHandler(Connection connection) {
        this.connection = connection;
        this.socketChannel = connection.getSocketChannel();
        this.node = connection.connectionManager.node;
        this.logger = this.node.getLogger(this.getClass().getName());
        this.inSelector = this.node.inSelector;
        this.outSelector = this.node.outSelector;
        this.clusterService = this.node.clusterService;
    }

    protected void shutdown() {
    }

    final void handleSocketException(Throwable e) {
        this.logger.log(Level.FINEST, Thread.currentThread().getName() + " Closing Socket. cause:  ", e);
        if (this.sk != null) {
            this.sk.cancel();
        }
        this.connection.close();
    }

    final void registerOp(Selector selector, int operation) {
        try {
            if (!this.connection.live()) {
                return;
            }
            if (this.sk == null) {
                this.sk = this.socketChannel.register(selector, operation, this);
            } else {
                this.sk.interestOps(operation);
            }
        }
        catch (Exception e) {
            this.handleSocketException(e);
        }
    }
}

