/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.logging;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LogEvent;
import com.hazelcast.logging.LoggerFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class StandardLoggerFactory
implements LoggerFactory {
    final ConcurrentMap<String, ILogger> mapLoggers = new ConcurrentHashMap<String, ILogger>(100);

    public ILogger getLogger(String name) {
        Logger l;
        StandardLogger newLogger;
        ILogger logger = (ILogger)this.mapLoggers.get(name);
        if (logger == null && (logger = this.mapLoggers.putIfAbsent(name, newLogger = new StandardLogger(l = Logger.getLogger(name)))) == null) {
            logger = newLogger;
        }
        return logger;
    }

    class StandardLogger
    implements ILogger {
        private final Logger logger;

        public StandardLogger(Logger logger) {
            this.logger = logger;
        }

        public void log(Level level, String message) {
            this.log(level, message, null);
        }

        public void log(Level level, String message, Throwable thrown) {
            LogRecord logRecord = new LogRecord(level, message);
            logRecord.setLoggerName(this.logger.getName());
            logRecord.setThrown(thrown);
            logRecord.setSourceClassName(this.logger.getName());
            this.logger.log(logRecord);
        }

        public void log(LogEvent logEvent) {
            this.logger.log(logEvent.getLogRecord());
        }

        public Level getLevel() {
            return this.logger.getLevel();
        }

        public boolean isLoggable(Level level) {
            return this.logger.isLoggable(level);
        }
    }
}

