/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.Transaction;
import com.hazelcast.impl.CallContext;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.Serializer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class ThreadContext {
    private static final ThreadLocal<ThreadContext> threadLocal = new ThreadLocal();
    private final Serializer serializer = new Serializer();
    private CallContext callContext = null;
    private FactoryImpl currentFactory = null;
    private final ConcurrentMap<FactoryImpl, CallCache> mapCallCacheForFactories = new ConcurrentHashMap<FactoryImpl, CallCache>();
    private static final AtomicInteger newThreadId = new AtomicInteger();

    private ThreadContext() {
        this.setCallContext(new CallContext(this.createNewThreadId(), false));
    }

    public static ThreadContext get() {
        ThreadContext threadContext = threadLocal.get();
        if (threadContext == null) {
            threadContext = new ThreadContext();
            threadLocal.set(threadContext);
        }
        return threadContext;
    }

    public void finalizeTxn() {
        this.getCallContext().finalizeTransaction();
    }

    public Transaction getTransaction() {
        return this.getCallContext().getTransaction();
    }

    public long getTxnId() {
        return this.getCallContext().getTxnId();
    }

    public FactoryImpl getCurrentFactory() {
        return this.currentFactory;
    }

    public void setCurrentFactory(FactoryImpl currentFactory) {
        this.currentFactory = currentFactory;
    }

    public void reset() {
        this.finalizeTxn();
    }

    public Data toData(Object obj) {
        return this.serializer.writeObject(obj);
    }

    public Object toObject(Data data) {
        return this.serializer.readObject(data);
    }

    public CallCache getCallCache(FactoryImpl factory) {
        CallCache callCache = (CallCache)this.mapCallCacheForFactories.get(factory);
        if (callCache == null) {
            callCache = new CallCache(factory);
            this.mapCallCacheForFactories.put(factory, callCache);
        }
        return callCache;
    }

    public boolean isClient() {
        return this.getCallContext().isClient();
    }

    public int createNewThreadId() {
        return newThreadId.incrementAndGet();
    }

    public CallContext getCallContext() {
        return this.callContext;
    }

    public int getThreadId() {
        return this.getCallContext().getThreadId();
    }

    public void setCallContext(CallContext callContext) {
        this.callContext = callContext;
    }

    class CallCache {
        final FactoryImpl factory;
        final ConcurrentMapManager.MPut mput;
        final ConcurrentMapManager.MGet mget;
        final ConcurrentMapManager.MRemove mremove;
        final ConcurrentMapManager.MEvict mevict;

        CallCache(FactoryImpl factory) {
            this.factory = factory;
            this.mput = factory.node.concurrentMapManager.new ConcurrentMapManager.MPut();
            this.mget = factory.node.concurrentMapManager.new ConcurrentMapManager.MGet();
            this.mremove = factory.node.concurrentMapManager.new ConcurrentMapManager.MRemove();
            this.mevict = factory.node.concurrentMapManager.new ConcurrentMapManager.MEvict();
        }

        public ConcurrentMapManager.MPut getMPut() {
            this.mput.reset();
            return this.mput;
        }

        public ConcurrentMapManager.MGet getMGet() {
            this.mget.reset();
            return this.mget;
        }

        public ConcurrentMapManager.MRemove getMRemove() {
            this.mremove.reset();
            return this.mremove;
        }

        public ConcurrentMapManager.MEvict getMEvict() {
            this.mevict.reset();
            return this.mevict;
        }
    }
}

