/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.JoinInfo;
import com.hazelcast.config.Config;
import com.hazelcast.impl.Node;
import com.hazelcast.nio.Address;
import com.hazelcast.util.UnboundedBlockingQueue;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;

public class MulticastService
implements Runnable {
    private final BlockingQueue<Runnable> queue = new UnboundedBlockingQueue<Runnable>();
    private final MulticastSocket multicastSocket;
    private final DatagramPacket datagramPacketSend;
    private final DatagramPacket datagramPacketReceive;
    private final Object sendLock = new Object();
    private final Object receiveLock = new Object();
    final Node node;
    private int bufferSize = 1024;
    private boolean running = true;

    public MulticastService(Node node, MulticastSocket multicastSocket) throws Exception {
        this.node = node;
        Config config = node.getConfig();
        this.multicastSocket = multicastSocket;
        this.datagramPacketReceive = new DatagramPacket(new byte[this.bufferSize], this.bufferSize);
        this.datagramPacketSend = new DatagramPacket(new byte[this.bufferSize], this.bufferSize, InetAddress.getByName(config.getNetworkConfig().getJoin().getMulticastConfig().getMulticastGroup()), config.getNetworkConfig().getJoin().getMulticastConfig().getMulticastPort());
        this.running = true;
    }

    public void stop() {
        try {
            final CountDownLatch l = new CountDownLatch(1);
            this.queue.put(new Runnable(){

                public void run() {
                    MulticastService.this.running = false;
                    l.countDown();
                }
            });
            l.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        while (this.running) {
            try {
                Runnable runnable = (Runnable)this.queue.poll();
                if (runnable != null) {
                    runnable.run();
                    return;
                }
                JoinInfo joinInfo = this.receive();
                if (joinInfo == null || this.node.address == null || this.node.address.equals(joinInfo.address) || !this.node.validateJoinRequest(joinInfo)) continue;
                if (this.node.isMaster()) {
                    if (!joinInfo.isRequest()) continue;
                    this.send(joinInfo.copy(false, this.node.address));
                    continue;
                }
                if (this.node.joined() || joinInfo.isRequest() || this.node.masterAddress != null) continue;
                this.node.masterAddress = new Address(joinInfo.address);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JoinInfo receive() {
        Object object = this.receiveLock;
        synchronized (object) {
            try {
                try {
                    this.multicastSocket.receive(this.datagramPacketReceive);
                }
                catch (SocketTimeoutException ignore) {
                    return null;
                }
                JoinInfo joinInfo = new JoinInfo();
                joinInfo.readFromPacket(this.datagramPacketReceive);
                return joinInfo;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(JoinInfo joinInfo) {
        Object object = this.sendLock;
        synchronized (object) {
            try {
                joinInfo.writeToPacket(this.datagramPacketSend);
                this.multicastSocket.send(this.datagramPacketSend);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

