/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.provider;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.hibernate.provider.HazelcastCache;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Properties;
import java.util.logging.Level;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;

public final class HazelcastCacheProvider
implements CacheProvider {
    private static final ILogger LOG = Logger.getLogger(HazelcastCacheProvider.class.getName());
    private final IdGenerator idGenerator = Hazelcast.getIdGenerator("HazelcastCacheProviderTimestampIdGenerator");

    public Cache buildCache(String name, Properties properties) throws CacheException {
        return new HazelcastCache(name);
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public long nextTimestamp() {
        long id = this.idGenerator.newId();
        return id;
    }

    public void start(Properties arg0) throws CacheException {
        LOG.log(Level.INFO, "Starting up HazelcastCacheProvider...");
    }

    public void stop() {
        LOG.log(Level.INFO, "Shutting down HazelcastCacheProvider...");
        Hazelcast.shutdown();
    }
}

