/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.hibernate.collection.HazelcastCollectionRegion;
import com.hazelcast.hibernate.entity.HazelcastEntityRegion;
import com.hazelcast.hibernate.query.HazelcastQueryResultsRegion;
import com.hazelcast.hibernate.timestamp.HazelcastTimestampsRegion;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Properties;
import java.util.logging.Level;
import org.hibernate.cache.CacheDataDescription;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CollectionRegion;
import org.hibernate.cache.EntityRegion;
import org.hibernate.cache.QueryResultsRegion;
import org.hibernate.cache.RegionFactory;
import org.hibernate.cache.TimestampsRegion;
import org.hibernate.cfg.Settings;

public class HazelcastCacheRegionFactory
implements RegionFactory {
    private static final ILogger LOG = Logger.getLogger(HazelcastCacheRegionFactory.class.getName());
    private final IdGenerator idGenerator;

    public HazelcastCacheRegionFactory() {
        LOG.log(Level.INFO, "Initializing HazelcastCacheRegionFactory...");
        this.idGenerator = Hazelcast.getIdGenerator("HazelcastCacheRegionFactoryTimestampIdGenerator");
    }

    public HazelcastCacheRegionFactory(Properties properties) {
        this();
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new HazelcastCollectionRegion(regionName, metadata);
    }

    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new HazelcastEntityRegion(regionName, metadata);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        return new HazelcastQueryResultsRegion(regionName);
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        return new HazelcastTimestampsRegion(regionName);
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public long nextTimestamp() {
        long id = this.idGenerator.newId();
        return id;
    }

    public void start(Settings settings, Properties properties) throws CacheException {
        LOG.log(Level.INFO, "Starting up HazelcastCacheRegionFactory...");
    }

    public void stop() {
        LOG.log(Level.INFO, "Shutting down HazelcastCacheRegionFactory...");
        Hazelcast.shutdown();
    }
}

