/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.examples;

import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAwareObject;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Instance;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MessageListener;
import com.hazelcast.core.MultiTask;
import com.hazelcast.partition.Partition;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

public class TestApp
implements EntryListener,
ItemListener,
MessageListener {
    private IQueue queue = null;
    private ITopic topic = null;
    private IMap map = null;
    private ISet set = null;
    private IList list = null;
    private String namespace = "default";
    private boolean silent = false;
    private boolean echo = false;
    private HazelcastInstance hazelcast;

    public TestApp(HazelcastInstance hazelcast) {
        this.hazelcast = hazelcast;
    }

    public static void main(String[] args) throws Exception {
        TestApp testApp = new TestApp(Hazelcast.newHazelcastInstance(null));
        testApp.start(args);
    }

    public void start(String[] args) throws Exception {
        this.queue = this.hazelcast.getQueue(this.namespace);
        this.topic = this.hazelcast.getTopic(this.namespace);
        this.map = this.hazelcast.getMap(this.namespace);
        this.set = this.hazelcast.getSet(this.namespace);
        this.list = this.hazelcast.getList(this.namespace);
        DefaultLineReader lineReader = new DefaultLineReader();
        while (true) {
            System.out.print("hazelcast[" + this.namespace + "] > ");
            try {
                String command = lineReader.readLine();
                this.handleCommand(command);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void handleCommand(String command) {
        if (this.echo) {
            if (Thread.currentThread().getName().toLowerCase().indexOf("main") < 0) {
                System.out.println(" [" + Thread.currentThread().getName() + "] " + command);
            } else {
                System.out.println(command);
            }
        }
        if (command == null || command.startsWith("//")) {
            return;
        }
        if ((command = command.trim()) == null || command.length() == 0) {
            return;
        }
        String first = command;
        int spaceIndex = command.indexOf(32);
        String[] argsSplit = command.split(" ");
        String[] args = new String[argsSplit.length];
        for (int i = 0; i < argsSplit.length; ++i) {
            args[i] = argsSplit[i].trim();
        }
        if (spaceIndex != -1) {
            first = args[0];
        }
        if (command.startsWith("help")) {
            this.handleHelp(command);
        } else {
            if (first.startsWith("#") && first.length() > 1) {
                int repeat = Integer.parseInt(first.substring(1));
                long t0 = System.currentTimeMillis();
                for (int i = 0; i < repeat; ++i) {
                    this.handleCommand(command.substring(first.length()).replaceAll("\\$i", "" + i));
                }
                System.out.println("ops/s = " + (long)(repeat * 1000) / (System.currentTimeMillis() - t0));
                return;
            }
            if (first.startsWith("&") && first.length() > 1) {
                int fork = Integer.parseInt(first.substring(1));
                ExecutorService pool = Executors.newFixedThreadPool(fork);
                final String threadCommand = command.substring(first.length());
                int i = 0;
                while (i < fork) {
                    final int threadID = i++;
                    pool.submit(new Runnable(){

                        public void run() {
                            String command = threadCommand;
                            String[] threadArgs = command.replaceAll("\\$t", "" + threadID).trim().split(" ");
                            if (("m.putmany".equals(threadArgs[0]) || "m.removemany".equals(threadArgs[0])) && threadArgs.length < 4) {
                                command = command + " " + Integer.parseInt(threadArgs[1]) * threadID;
                            }
                            TestApp.this.handleCommand(command);
                        }
                    });
                }
                pool.shutdown();
                try {
                    pool.awaitTermination(3600L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (first.startsWith("@")) {
                if (first.length() == 1) {
                    System.out.println("usage: @<file-name>");
                    return;
                }
                File f = new File(first.substring(1));
                System.out.println("Executing script file " + f.getAbsolutePath());
                if (f.exists()) {
                    try {
                        BufferedReader br = new BufferedReader(new FileReader(f));
                        String l = br.readLine();
                        while (l != null) {
                            this.handleCommand(l);
                            l = br.readLine();
                        }
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    System.out.println("File not found! " + f.getAbsolutePath());
                }
            } else {
                if (command.indexOf(59) != -1) {
                    StringTokenizer st = new StringTokenizer(command, ";");
                    while (st.hasMoreTokens()) {
                        this.handleCommand(st.nextToken());
                    }
                    return;
                }
                if ("silent".equals(first)) {
                    this.silent = Boolean.parseBoolean(args[1]);
                } else if ("restart".equals(first)) {
                    this.hazelcast.restart();
                } else if ("shutdown".equals(first)) {
                    this.hazelcast.shutdown();
                } else if ("echo".equals(first)) {
                    this.echo = Boolean.parseBoolean(args[1]);
                } else if ("ns".equals(first)) {
                    if (args.length > 1) {
                        this.namespace = args[1];
                        this.queue = this.hazelcast.getQueue(this.namespace);
                        this.topic = this.hazelcast.getTopic(this.namespace);
                        this.map = this.hazelcast.getMap(this.namespace);
                        this.set = this.hazelcast.getSet(this.namespace);
                        this.list = this.hazelcast.getList(this.namespace);
                    }
                } else if ("whoami".equals(first)) {
                    System.out.println(this.hazelcast.getCluster().getLocalMember());
                } else if ("who".equals(first)) {
                    System.out.println(this.hazelcast.getCluster());
                } else if ("jvm".equals(first)) {
                    System.gc();
                    System.out.println("Memory max: " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + "M");
                    System.out.println("Memory free: " + Runtime.getRuntime().freeMemory() / 1024L / 1024L + "M " + (int)(Runtime.getRuntime().freeMemory() * 100L / Runtime.getRuntime().maxMemory()) + "%");
                    long total = Runtime.getRuntime().totalMemory();
                    long free = Runtime.getRuntime().freeMemory();
                    System.out.println("Used Memory:" + (total - free) / 1024L / 1024L + "MB");
                    System.out.println("# procs: " + Runtime.getRuntime().availableProcessors());
                    System.out.println("OS info: " + ManagementFactory.getOperatingSystemMXBean().getArch() + " " + ManagementFactory.getOperatingSystemMXBean().getName() + " " + ManagementFactory.getOperatingSystemMXBean().getVersion());
                    System.out.println("JVM: " + ManagementFactory.getRuntimeMXBean().getVmVendor() + " " + ManagementFactory.getRuntimeMXBean().getVmName() + " " + ManagementFactory.getRuntimeMXBean().getVmVersion());
                } else if (first.indexOf("ock") != -1 && first.indexOf(".") == -1) {
                    this.handleLock(args);
                } else if (first.indexOf(".size") != -1) {
                    this.handleSize(args);
                } else if (first.indexOf(".clear") != -1) {
                    this.handleClear(args);
                } else if (first.indexOf(".destroy") != -1) {
                    this.handleDestroy(args);
                } else if (first.indexOf(".iterator") != -1) {
                    this.handleIterator(args);
                } else if (first.indexOf(".contains") != -1) {
                    this.handleContains(args);
                } else if (first.indexOf(".stats") != -1) {
                    this.handStats(args);
                } else if ("t.publish".equals(first)) {
                    this.handleTopicPublish(args);
                } else if ("q.offer".equals(first)) {
                    this.handleQOffer(args);
                } else if ("q.take".equals(first)) {
                    this.handleQTake(args);
                } else if ("q.poll".equals(first)) {
                    this.handleQPoll(args);
                } else if ("q.peek".equals(first)) {
                    this.handleQPeek(args);
                } else if ("q.capacity".equals(first)) {
                    this.handleQCapacity(args);
                } else if ("q.offermany".equals(first)) {
                    this.handleQOfferMany(args);
                } else if ("q.pollmany".equals(first)) {
                    this.handleQPollMany(args);
                } else if ("s.add".equals(first)) {
                    this.handleSetAdd(args);
                } else if ("s.remove".equals(first)) {
                    this.handleSetRemove(args);
                } else if ("s.addmany".equals(first)) {
                    this.handleSetAddMany(args);
                } else if ("s.removemany".equals(first)) {
                    this.handleSetRemoveMany(args);
                } else if (first.equals("m.replace")) {
                    this.handleMapReplace(args);
                } else if (first.equalsIgnoreCase("m.putIfAbsent")) {
                    this.handleMapPutIfAbsent(args);
                } else if (first.equals("m.putAsync")) {
                    this.handleMapPutAsync(args);
                } else if (first.equals("m.getAsync")) {
                    this.handleMapGetAsync(args);
                } else if (first.equals("m.put")) {
                    this.handleMapPut(args);
                } else if (first.equals("m.get")) {
                    this.handleMapGet(args);
                } else if (first.equalsIgnoreCase("m.getMapEntry")) {
                    this.handleMapGetMapEntry(args);
                } else if (first.equals("m.remove")) {
                    this.handleMapRemove(args);
                } else if (first.equals("m.evict")) {
                    this.handleMapEvict(args);
                } else if (first.equals("m.putmany") || first.equalsIgnoreCase("m.putAll")) {
                    this.handleMapPutMany(args);
                } else if (first.equals("m.getmany")) {
                    this.handleMapGetMany(args);
                } else if (first.equals("m.removemany")) {
                    this.handleMapRemoveMany(args);
                } else if (command.equalsIgnoreCase("m.localKeys")) {
                    this.handleMapLocalKeys();
                } else if (command.equals("m.keys")) {
                    this.handleMapKeys();
                } else if (command.equals("m.values")) {
                    this.handleMapValues();
                } else if (command.equals("m.entries")) {
                    this.handleMapEntries();
                } else if (first.equals("m.lock")) {
                    this.handleMapLock(args);
                } else if (first.equalsIgnoreCase("m.tryLock")) {
                    this.handleMapTryLock(args);
                } else if (first.equals("m.unlock")) {
                    this.handleMapUnlock(args);
                } else if (first.indexOf(".addListener") != -1) {
                    this.handleAddListener(args);
                } else if (first.equals("m.removeMapListener")) {
                    this.handleRemoveListener(args);
                } else if (first.equals("m.unlock")) {
                    this.handleMapUnlock(args);
                } else if (first.equals("l.add")) {
                    this.handleListAdd(args);
                } else if ("l.addmany".equals(first)) {
                    this.handleListAddMany(args);
                } else if (first.equals("l.remove")) {
                    this.handleListRemove(args);
                } else if (first.equals("l.contains")) {
                    this.handleListContains(args);
                } else if (first.equals("execute")) {
                    this.execute(args);
                } else if (first.equals("partitions")) {
                    this.handlePartitions(args);
                } else if (first.equals("txn")) {
                    this.hazelcast.getTransaction().begin();
                } else if (first.equals("commit")) {
                    this.hazelcast.getTransaction().commit();
                } else if (first.equals("rollback")) {
                    this.hazelcast.getTransaction().rollback();
                } else if (first.equalsIgnoreCase("executeOnKey")) {
                    this.executeOnKey(args);
                } else if (first.equalsIgnoreCase("executeOnMember")) {
                    this.executeOnMember(args);
                } else if (first.equalsIgnoreCase("executeOnMembers")) {
                    this.executeOnMembers(args);
                } else if (first.equalsIgnoreCase("longOther") || first.equalsIgnoreCase("executeLongOther")) {
                    this.executeLongTaskOnOtherMember(args);
                } else if (first.equalsIgnoreCase("long") || first.equalsIgnoreCase("executeLong")) {
                    this.executeLong(args);
                } else if (first.equalsIgnoreCase("instances")) {
                    this.handleInstances(args);
                } else if (first.equalsIgnoreCase("quit") || first.equalsIgnoreCase("exit")) {
                    System.exit(0);
                } else {
                    this.print("type 'help' for help");
                }
            }
        }
    }

    private void handlePartitions(String[] args) {
        Set<Partition> partitions = this.hazelcast.getPartitionService().getPartitions();
        HashMap<Member, Integer> partitionCounts = new HashMap<Member, Integer>();
        for (Partition partition : partitions) {
            Member owner = partition.getOwner();
            if (owner != null) {
                Integer count = (Integer)partitionCounts.get(owner);
                int newCount = 1;
                if (count != null) {
                    newCount = count + 1;
                }
                partitionCounts.put(owner, newCount);
            }
            System.out.println(partition);
        }
        Set entries = partitionCounts.entrySet();
        for (Map.Entry entry : entries) {
            System.out.println(entry.getKey() + ":" + entry.getValue());
        }
    }

    private void handleInstances(String[] args) {
        Collection<Instance> instances = this.hazelcast.getInstances();
        for (Instance instance : instances) {
            this.print(instance);
        }
    }

    private void handleListContains(String[] args) {
        this.print(this.list.contains(args[1]));
    }

    private void handleListRemove(String[] args) {
        this.print(this.list.remove(args[1]));
    }

    private void handleListAdd(String[] args) {
        this.print(this.list.add(args[1]));
    }

    private void handleMapPut(String[] args) {
        this.print(this.map.put(args[1], args[2]));
    }

    private void handleMapPutAsync(String[] args) {
        try {
            this.print(this.map.putAsync(args[1], args[2]).get());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private void handleMapPutIfAbsent(String[] args) {
        this.print(this.map.putIfAbsent(args[1], args[2]));
    }

    private void handleMapReplace(String[] args) {
        this.print(this.map.replace(args[1], args[2]));
    }

    private void handleMapGet(String[] args) {
        this.print(this.map.get(args[1]));
    }

    private void handleMapGetAsync(String[] args) {
        try {
            this.print(this.map.getAsync(args[1]).get());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private void handleMapGetMapEntry(String[] args) {
        this.print(this.map.getMapEntry(args[1]));
    }

    private void handleMapRemove(String[] args) {
        this.print(this.map.remove(args[1]));
    }

    private void handleMapEvict(String[] args) {
        this.print(this.map.evict(args[1]));
    }

    private void handleMapPutMany(String[] args) {
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        int b = 100;
        byte[] value = new byte[b];
        if (args.length > 2) {
            b = Integer.parseInt(args[2]);
            value = new byte[b];
        }
        int start = this.map.size();
        if (args.length > 3) {
            start = Integer.parseInt(args[3]);
        }
        HashMap<String, byte[]> theMap = new HashMap<String, byte[]>(count);
        for (int i = 0; i < count; ++i) {
            theMap.put("key" + (start + i), value);
        }
        long t0 = System.currentTimeMillis();
        this.map.putAll(theMap);
        long t1 = System.currentTimeMillis();
        if (t1 - t0 > 1L) {
            System.out.println("size = " + this.map.size() + ", " + (long)(count * 1000) / (t1 - t0) + " evt/s, " + (long)(count * 1000) / (t1 - t0) * (long)(b * 8) / 1024L + " Kbit/s, " + count * b / 1024 + " KB added");
        }
    }

    private void handStats(String[] args) {
        String iteratorStr = args[0];
        if (!iteratorStr.startsWith("s.")) {
            if (iteratorStr.startsWith("m.")) {
                this.print(this.map.getLocalMapStats());
            } else if (iteratorStr.startsWith("q.")) {
                this.print(this.queue.getLocalQueueStats());
            } else if (iteratorStr.startsWith("l.")) {
                // empty if block
            }
        }
    }

    private void handleMapGetMany(String[] args) {
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        for (int i = 0; i < count; ++i) {
            this.print(this.map.get("key" + i));
        }
    }

    private void handleMapRemoveMany(String[] args) {
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        int start = 0;
        if (args.length > 2) {
            start = Integer.parseInt(args[2]);
        }
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            this.map.remove("key" + (start + i));
        }
        long t1 = System.currentTimeMillis();
        System.out.println("size = " + this.map.size() + ", " + (long)(count * 1000) / (t1 - t0) + " evt/s");
    }

    private void handleMapLock(String[] args) {
        this.map.lock(args[1]);
        this.print("true");
    }

    private void handleLock(String[] args) {
        String lockStr = args[0];
        String key = args[1];
        ILock lock = this.hazelcast.getLock(key);
        if (lockStr.equalsIgnoreCase("lock")) {
            lock.lock();
            this.print("true");
        } else if (lockStr.equalsIgnoreCase("unlock")) {
            lock.unlock();
            this.print("true");
        } else if (lockStr.equalsIgnoreCase("trylock")) {
            String timeout;
            String string = timeout = args.length > 2 ? args[2] : null;
            if (timeout == null) {
                this.print(lock.tryLock());
            } else {
                long time = Long.valueOf(timeout);
                try {
                    this.print(lock.tryLock(time, TimeUnit.SECONDS));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void handleMapTryLock(String[] args) {
        String key = args[1];
        long time = args.length > 2 ? Long.valueOf(args[2]) : 0L;
        boolean locked = false;
        locked = time == 0L ? this.map.tryLock(key) : this.map.tryLock(key, time, TimeUnit.SECONDS);
        this.print(locked);
    }

    private void handleMapUnlock(String[] args) {
        this.map.unlock(args[1]);
        this.print("true");
    }

    private void handleAddListener(String[] args) {
        String first = args[0];
        if (first.startsWith("s.")) {
            this.set.addItemListener(this, true);
        } else if (first.startsWith("m.")) {
            if (args.length > 1) {
                this.map.addEntryListener(this, args[1], true);
            } else {
                this.map.addEntryListener(this, true);
            }
        } else if (first.startsWith("q.")) {
            this.queue.addItemListener(this, true);
        } else if (first.startsWith("t.")) {
            this.topic.addMessageListener(this);
        } else if (first.startsWith("l.")) {
            this.list.addItemListener(this, true);
        }
    }

    private void handleRemoveListener(String[] args) {
        String first = args[0];
        if (first.startsWith("s.")) {
            this.set.removeItemListener(this);
        } else if (first.startsWith("m.")) {
            if (args.length > 1) {
                this.map.removeEntryListener(this, args[1]);
            } else {
                this.map.removeEntryListener(this);
            }
        } else if (first.startsWith("q.")) {
            this.queue.removeItemListener(this);
        } else if (first.startsWith("t.")) {
            this.topic.removeMessageListener(this);
        } else if (first.startsWith("l.")) {
            this.list.removeItemListener(this);
        }
    }

    private void handleMapLocalKeys() {
        Set set = this.map.localKeySet();
        Iterator it = set.iterator();
        int count = 0;
        while (it.hasNext()) {
            ++count;
            this.print(it.next());
        }
        this.print("Total " + count);
    }

    private void handleMapKeys() {
        Set set = this.map.keySet();
        Iterator it = set.iterator();
        int count = 0;
        while (it.hasNext()) {
            ++count;
            this.print(it.next());
        }
        this.print("Total " + count);
    }

    private void handleMapEntries() {
        Set set = this.map.entrySet();
        Iterator it = set.iterator();
        int count = 0;
        long time = System.currentTimeMillis();
        while (it.hasNext()) {
            ++count;
            Map.Entry entry = it.next();
            this.print(entry.getKey() + " : " + entry.getValue());
        }
        this.print("Total " + count);
    }

    private void handleMapValues() {
        Collection set = this.map.values();
        Iterator it = set.iterator();
        int count = 0;
        while (it.hasNext()) {
            ++count;
            this.print(it.next());
        }
        this.print("Total " + count);
    }

    private void handleSetAdd(String[] args) {
        this.print(this.set.add(args[1]));
    }

    private void handleSetRemove(String[] args) {
        this.print(this.set.remove(args[1]));
    }

    private void handleSetAddMany(String[] args) {
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        int successCount = 0;
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            boolean success = this.set.add("obj" + i);
            if (!success) continue;
            ++successCount;
        }
        long t1 = System.currentTimeMillis();
        this.print("Added " + successCount + " objects.");
        System.out.println("size = " + this.set.size() + ", " + (long)(successCount * 1000) / (t1 - t0) + " evt/s");
    }

    private void handleListAddMany(String[] args) {
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        int successCount = 0;
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            boolean success = this.list.add("obj" + i);
            if (!success) continue;
            ++successCount;
        }
        long t1 = System.currentTimeMillis();
        this.print("Added " + successCount + " objects.");
        System.out.println("size = " + this.list.size() + ", " + (long)(successCount * 1000) / (t1 - t0) + " evt/s");
    }

    private void handleSetRemoveMany(String[] args) {
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        int successCount = 0;
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            boolean success = this.set.remove("obj" + i);
            if (!success) continue;
            ++successCount;
        }
        long t1 = System.currentTimeMillis();
        this.print("Removed " + successCount + " objects.");
        System.out.println("size = " + this.set.size() + ", " + (long)(successCount * 1000) / (t1 - t0) + " evt/s");
    }

    private void handleIterator(String[] args) {
        Iterator<Object> it = null;
        String iteratorStr = args[0];
        if (iteratorStr.startsWith("s.")) {
            it = this.set.iterator();
        } else if (iteratorStr.startsWith("m.")) {
            it = this.map.keySet().iterator();
        } else if (iteratorStr.startsWith("q.")) {
            it = this.queue.iterator();
        } else if (iteratorStr.startsWith("l.")) {
            it = this.list.iterator();
        }
        boolean remove = false;
        if (args.length > 1) {
            String removeStr = args[1];
            remove = removeStr.equals("remove");
        }
        int count = 1;
        while (it.hasNext()) {
            System.out.print(count++ + " " + it.next());
            if (remove) {
                it.remove();
                System.out.print(" removed");
            }
            this.print("");
        }
    }

    private void handleContains(String[] args) {
        String iteratorStr = args[0];
        boolean key = false;
        boolean value = false;
        if (iteratorStr.toLowerCase().endsWith("key")) {
            key = true;
        } else if (iteratorStr.toLowerCase().endsWith("value")) {
            value = true;
        }
        String data = args[1];
        boolean result = false;
        if (iteratorStr.startsWith("s.")) {
            result = this.set.contains(data);
        } else if (iteratorStr.startsWith("m.")) {
            result = key ? this.map.containsKey(data) : this.map.containsValue(data);
        } else if (iteratorStr.startsWith("q.")) {
            result = this.queue.contains(data);
        } else if (iteratorStr.startsWith("l.")) {
            result = this.list.contains(data);
        }
        this.print("Contains : " + result);
    }

    private void handleSize(String[] args) {
        int size = 0;
        String iteratorStr = args[0];
        if (iteratorStr.startsWith("s.")) {
            size = this.set.size();
        } else if (iteratorStr.startsWith("m.")) {
            size = this.map.size();
        } else if (iteratorStr.startsWith("q.")) {
            size = this.queue.size();
        } else if (iteratorStr.startsWith("l.")) {
            size = this.list.size();
        }
        this.print("Size = " + size);
    }

    private void handleClear(String[] args) {
        String iteratorStr = args[0];
        if (iteratorStr.startsWith("s.")) {
            this.set.clear();
        } else if (iteratorStr.startsWith("m.")) {
            this.map.clear();
        } else if (iteratorStr.startsWith("q.")) {
            this.queue.clear();
        } else if (iteratorStr.startsWith("l.")) {
            this.list.clear();
        }
        this.print("Cleared all.");
    }

    private void handleDestroy(String[] args) {
        String iteratorStr = args[0];
        if (iteratorStr.startsWith("s.")) {
            this.set.destroy();
        } else if (iteratorStr.startsWith("m.")) {
            this.map.destroy();
        } else if (iteratorStr.startsWith("q.")) {
            this.queue.destroy();
        } else if (iteratorStr.startsWith("l.")) {
            this.list.destroy();
        } else if (iteratorStr.startsWith("t.")) {
            this.topic.destroy();
        }
        this.print("Destroyed!");
    }

    private void handleQOffer(String[] args) {
        long timeout = 0L;
        if (args.length > 2) {
            timeout = Long.valueOf(args[2]);
        }
        try {
            boolean offered = this.queue.offer(args[1], timeout, TimeUnit.SECONDS);
            this.print(offered);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void handleQTake(String[] args) {
        try {
            this.print(this.queue.take());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void handleQPoll(String[] args) {
        long timeout = 0L;
        if (args.length > 1) {
            timeout = Long.valueOf(args[1]);
        }
        try {
            this.print(this.queue.poll(timeout, TimeUnit.SECONDS));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void handleTopicPublish(String[] args) {
        this.topic.publish(args[1]);
    }

    private void handleQOfferMany(String[] args) {
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        byte[] value = null;
        if (args.length > 2) {
            value = new byte[Integer.parseInt(args[2])];
        }
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            if (value == null) {
                this.queue.offer("obj");
                continue;
            }
            this.queue.offer(value);
        }
        long t1 = System.currentTimeMillis();
        System.out.print("size = " + this.queue.size() + ", " + (long)(count * 1000) / (t1 - t0) + " evt/s");
        if (value == null) {
            System.out.println("");
        } else {
            int b = Integer.parseInt(args[2]);
            System.out.println(", " + (long)(count * 1000) / (t1 - t0) * (long)(b * 8) / 1024L + " Kbit/s, " + count * b / 1024 + " KB added");
        }
    }

    private void handleQPollMany(String[] args) {
        int count = 1;
        if (args.length > 1) {
            count = Integer.parseInt(args[1]);
        }
        int c = 1;
        for (int i = 0; i < count; ++i) {
            Object obj = this.queue.poll();
            if (obj instanceof byte[]) {
                this.print(c++ + " " + ((byte[])obj).length);
                continue;
            }
            this.print(c++ + " " + obj);
        }
    }

    private void handleQPeek(String[] args) {
        this.print(this.queue.peek());
    }

    private void handleQCapacity(String[] args) {
        this.print(this.queue.remainingCapacity());
    }

    private void execute(String[] args) {
        this.doExecute(false, false, args);
    }

    private void executeOnKey(String[] args) {
        this.doExecute(true, false, args);
    }

    private void executeOnMember(String[] args) {
        this.doExecute(false, true, args);
    }

    private void ex(String input) throws Exception {
        DistributedTask<String> task = new DistributedTask<String>(new Echo(input));
        ExecutorService executorService = this.hazelcast.getExecutorService();
        executorService.execute(task);
        String echoResult = (String)((FutureTask)task).get();
    }

    private void doExecute(boolean onKey, boolean onMember, String[] args) {
        try {
            ExecutorService executorService = this.hazelcast.getExecutorService();
            Echo callable = new Echo(args[1]);
            DistributedTask<String> task = null;
            if (onKey) {
                String key = args[2];
                task = new DistributedTask<String>(callable, (Object)key);
            } else if (onMember) {
                int memberIndex = Integer.parseInt(args[2]);
                Member member = (Member)this.hazelcast.getCluster().getMembers().toArray()[memberIndex];
                task = new DistributedTask<String>(callable, member);
            } else {
                task = new DistributedTask<String>(callable);
            }
            executorService.execute(task);
            System.out.println("Result: " + (String)((FutureTask)task).get());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private void executeOnMembers(String[] args) {
        try {
            ExecutorService executorService = this.hazelcast.getExecutorService();
            MultiTask<String> echoTask = new MultiTask<String>(new Echo(args[1]), this.hazelcast.getCluster().getMembers());
            executorService.execute(echoTask);
            Object results = echoTask.get();
            Iterator i$ = results.iterator();
            while (i$.hasNext()) {
                String result = (String)i$.next();
                System.out.println(result);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private void executeLong(String[] args) {
        try {
            ExecutorService executorService = this.hazelcast.getExecutorService();
            MultiTask echoTask = new MultiTask(new LongTask(args[1]), this.hazelcast.getCluster().getMembers()){

                public void setMemberLeft(Member member) {
                    System.out.println("Member Left " + member);
                }

                public void done() {
                    System.out.println("Done!");
                }
            };
            executorService.execute(echoTask);
            Object results = echoTask.get();
            Iterator i$ = results.iterator();
            while (i$.hasNext()) {
                String result = (String)i$.next();
                System.out.println(result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void executeLongTaskOnOtherMember(String[] args) {
        try {
            ExecutorService executorService = this.hazelcast.getExecutorService();
            Member otherMember = null;
            Set<Member> members = this.hazelcast.getCluster().getMembers();
            for (Member member : members) {
                if (member.localMember()) continue;
                otherMember = member;
            }
            if (otherMember == null) {
                otherMember = this.hazelcast.getCluster().getLocalMember();
            }
            DistributedTask echoTask = new DistributedTask(new LongTask(args[1]), otherMember){

                public void setMemberLeft(Member member) {
                    System.out.println("Member Left " + member);
                }

                public void done() {
                    System.out.println("Done!");
                }
            };
            executorService.execute(echoTask);
            Object result = echoTask.get();
            System.out.println(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void entryAdded(EntryEvent event) {
        System.out.println(event);
    }

    public void entryRemoved(EntryEvent event) {
        System.out.println(event);
    }

    public void entryUpdated(EntryEvent event) {
        System.out.println(event);
    }

    public void entryEvicted(EntryEvent event) {
        System.out.println(event);
    }

    public void itemAdded(Object item) {
        System.out.println("Item added = " + item);
    }

    public void itemRemoved(Object item) {
        System.out.println("Item removed = " + item);
    }

    public void onMessage(Object msg) {
        System.out.println("Topic received = " + msg);
    }

    private void handleHelp(String command) {
        boolean silentBefore = this.silent;
        this.silent = false;
        this.print("Commands:");
        this.print("-- General commands");
        this.print("echo true|false                      //turns on/off echo of commands (default false)");
        this.print("silent true|false                    //turns on/off silent of command output (default false)");
        this.print("#<number> <command>                  //repeats <number> time <command>, replace $i in <command> with current iteration (0..<number-1>)");
        this.print("&<number> <command>                  //forks <number> threads to execute <command>, replace $t in <command> with current thread number (0..<number-1>");
        this.print("     When using #x or &x, is is advised to use silent true as well.");
        this.print("     When using &x with m.putmany and m.removemany, each thread will get a different share of keys unless a start key index is specified");
        this.print("jvm                                  //displays info about the runtime");
        this.print("who                                  //displays info about the cluster");
        this.print("whoami                               //displays info about this cluster member");
        this.print("ns <string>                          //switch the namespace for using the distributed queue/map/set/list <string> (defaults to \"default\"");
        this.print("@<file>                              //executes the given <file> script. Use '//' for comments in the script");
        this.print("");
        this.print("-- Queue commands");
        this.print("q.offer <string>                     //adds a string object to the queue");
        this.print("q.poll                               //takes an object from the queue");
        this.print("q.offermany <number> [<size>]        //adds indicated number of string objects to the queue ('obj<i>' or byte[<size>]) ");
        this.print("q.pollmany <number>                  //takes indicated number of objects from the queue");
        this.print("q.iterator [remove]                  //iterates the queue, remove if specified");
        this.print("q.size                               //size of the queue");
        this.print("q.clear                              //clears the queue");
        this.print("");
        this.print("-- Set commands");
        this.print("s.add <string>                       //adds a string object to the set");
        this.print("s.remove <string>                    //removes the string object from the set");
        this.print("s.addmany <number>                   //adds indicated number of string objects to the set ('obj<i>')");
        this.print("s.removemany <number>                //takes indicated number of objects from the set");
        this.print("s.iterator [remove]                  //iterates the set, removes if specified");
        this.print("s.size                               //size of the set");
        this.print("s.clear                              //clears the set");
        this.print("");
        this.print("-- Lock commands");
        this.print("lock <key>                           //same as Hazelcast.getLock(key).lock()");
        this.print("tryLock <key>                        //same as Hazelcast.getLock(key).tryLock()");
        this.print("tryLock <key> <time>                 //same as tryLock <key> with timeout in seconds");
        this.print("unlock <key>                         //same as Hazelcast.getLock(key).unlock()");
        this.print("");
        this.print("-- Map commands");
        this.print("m.put <key> <value>                  //puts an entry to the map");
        this.print("m.remove <key>                       //removes the entry of given key from the map");
        this.print("m.get <key>                          //returns the value of given key from the map");
        this.print("m.putmany <number> [<size>] [<index>]//puts indicated number of entries to the map ('key<i>':byte[<size>], <index>+(0..<number>)");
        this.print("m.removemany <number> [<index>]      //removes indicated number of entries from the map ('key<i>', <index>+(0..<number>)");
        this.print("     When using &x with m.putmany and m.removemany, each thread will get a different share of keys unless a start key <index> is specified");
        this.print("m.keys                               //iterates the keys of the map");
        this.print("m.values                             //iterates the values of the map");
        this.print("m.entries                            //iterates the entries of the map");
        this.print("m.iterator [remove]                  //iterates the keys of the map, remove if specified");
        this.print("m.size                               //size of the map");
        this.print("m.clear                              //clears the map");
        this.print("m.lock <key>                         //locks the key");
        this.print("m.tryLock <key>                      //tries to lock the key and returns immediately");
        this.print("m.tryLock <key> <time>               //tries to lock the key within given seconds");
        this.print("m.unlock <key>                       //unlocks the key");
        this.print("");
        this.print("-- List commands:");
        this.print("l.add <string>");
        this.print("l.contains <string>");
        this.print("l.remove <string>");
        this.print("l.iterator [remove]");
        this.print("l.size");
        this.print("l.clear");
        this.print("execute\t<echo-input>\t\t\t\t//executes an echo task on random member");
        this.print("execute0nKey\t<echo-input> <key>\t\t//executes an echo task on the member that owns the given key");
        this.print("execute0nMember <echo-input> <key>\t//executes an echo task on the member with given index");
        this.print("execute0nMembers <echo-input> \t\t//executes an echo task on all of the members");
        this.print("");
        this.silent = silentBefore;
    }

    void print(Object obj) {
        if (!this.silent) {
            System.out.println(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Echo
    extends HazelcastInstanceAwareObject
    implements Callable<String>,
    Serializable {
        String input = null;

        public Echo() {
        }

        public Echo(String input) {
            this.input = input;
        }

        @Override
        public String call() {
            return this.getHazelcastInstance().getCluster().getLocalMember().toString() + ":" + this.input;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongTask
    extends HazelcastInstanceAwareObject
    implements Callable<String>,
    Serializable {
        String input = null;

        public LongTask() {
        }

        public LongTask(String input) {
            this.input = input;
        }

        @Override
        public String call() {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                System.out.println("Interrupted! Cancelling task!");
                return "No-result";
            }
            return this.getHazelcastInstance().getCluster().getLocalMember().toString() + ":" + this.input;
        }
    }

    class HistoricLineReader
    implements LineReader {
        InputStream in = System.in;

        HistoricLineReader() {
        }

        public String readLine() throws Exception {
            while (true) {
                System.in.read();
                System.out.println("char " + System.in.read());
            }
        }

        int readCharacter() throws Exception {
            return this.in.read();
        }
    }

    class DefaultLineReader
    implements LineReader {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

        DefaultLineReader() {
        }

        public String readLine() throws Exception {
            return this.in.readLine();
        }
    }

    static interface LineReader {
        public String readLine() throws Exception;
    }
}

