/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.JoinRequest;
import com.hazelcast.impl.NodeType;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Packet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;

public class JoinInfo
extends JoinRequest {
    private static final long serialVersionUID = 1088129500826234941L;
    private boolean request = true;

    public JoinInfo() {
    }

    public JoinInfo(boolean request, Address address, String groupName, String groupPassword, NodeType type, byte packetVersion, int buildNumber) {
        super(address, groupName, groupPassword, type, packetVersion, buildNumber);
        this.setRequest(request);
    }

    public JoinInfo copy(boolean newRequest, Address newAddress) {
        return new JoinInfo(newRequest, newAddress, this.groupName, this.groupPassword, this.nodeType, this.packetVersion, this.buildNumber);
    }

    public void writeToPacket(DatagramPacket packet) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeBoolean(this.isRequest());
            this.address.writeData(dos);
            dos.writeUTF(this.groupName);
            dos.writeUTF(this.groupPassword);
            dos.writeByte(Packet.PACKET_VERSION);
            dos.writeInt(this.buildNumber);
            packet.setData(bos.toByteArray());
            packet.setLength(bos.size());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readFromPacket(DatagramPacket packet) {
        ByteArrayInputStream bis = new ByteArrayInputStream(packet.getData(), 0, packet.getLength());
        DataInputStream dis = new DataInputStream(bis);
        try {
            this.setRequest(dis.readBoolean());
            this.address = new Address();
            this.address.readData(dis);
            this.groupName = dis.readUTF();
            this.groupPassword = dis.readUTF();
            this.packetVersion = dis.readByte();
            this.buildNumber = dis.readInt();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setRequest(boolean request) {
        this.request = request;
    }

    public boolean isRequest() {
        return this.request;
    }

    public String toString() {
        return "JoinInfo{request=" + this.isRequest() + "  " + super.toString() + '}';
    }
}

