/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.Packet;
import com.hazelcast.client.Serializer;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MembershipListenerManager {
    private final List<MembershipListener> memberShipListeners = new CopyOnWriteArrayList<MembershipListener>();
    private final HazelcastClient client;

    public MembershipListenerManager(HazelcastClient client) {
        this.client = client;
    }

    public void registerMembershipListener(MembershipListener listener) {
        this.memberShipListeners.add(listener);
    }

    public void removeMembershipListener(MembershipListener listener) {
        this.memberShipListeners.remove(listener);
    }

    public synchronized boolean noMembershipListenerRegistered() {
        return this.memberShipListeners.isEmpty();
    }

    public void notifyMembershipListeners(Packet packet) {
        Member member = (Member)Serializer.toObject(packet.getKey());
        Integer type = (Integer)Serializer.toObject(packet.getValue());
        MembershipEvent event = new MembershipEvent(this.client.getCluster(), member, type);
        if (type.equals(1)) {
            for (MembershipListener membershipListener : this.memberShipListeners) {
                membershipListener.memberAdded(event);
            }
        } else {
            for (MembershipListener membershipListener : this.memberShipListeners) {
                membershipListener.memberRemoved(event);
            }
        }
    }
}

