/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.AsyncClientCall;
import com.hazelcast.client.Call;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.Packet;
import com.hazelcast.client.Serializer;
import com.hazelcast.client.impl.CollectionWrapper;
import com.hazelcast.core.Member;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.query.Predicate;
import java.io.Serializable;
import java.util.Collection;
import java.util.EventListener;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyHelper {
    private static final AtomicLong callIdGen = new AtomicLong(0L);
    private final String name;
    private final HazelcastClient client;
    final ILogger logger = Logger.getLogger(this.getClass().getName());

    public ProxyHelper(String name, HazelcastClient client) {
        this.name = name == null ? "" : name;
        this.client = client;
    }

    public String getName() {
        return this.name.substring(2);
    }

    protected Packet callAndGetResult(Packet request) {
        Call c = this.createCall(request);
        return this.doCall(c);
    }

    protected Packet doCall(Call c) {
        this.sendCall(c);
        return (Packet)c.getResponse();
    }

    public void sendCall(Call c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.client.getOutRunnable().enQueue(c);
    }

    public Call createCall(Packet request) {
        long id = ProxyHelper.newCallId();
        return new Call(id, request){

            public void onDisconnect(Member member) {
                ProxyHelper.this.logger.log(Level.FINE, "Re enqueue " + this);
                if (!((ProxyHelper)ProxyHelper.this).client.getOutRunnable().queue.contains(this)) {
                    ProxyHelper.this.client.getOutRunnable().enQueue(this);
                }
            }
        };
    }

    public static long newCallId() {
        return callIdGen.incrementAndGet();
    }

    private Packet createRequestPacket() {
        Packet request = new Packet();
        request.setName(this.name);
        request.setThreadId(this.getCurrentThreadId());
        return request;
    }

    public int getCurrentThreadId() {
        return (int)Thread.currentThread().getId();
    }

    public Packet createRequestPacket(ClusterOperation operation, byte[] key, byte[] value) {
        Packet request = this.createRequestPacket();
        request.setOperation(operation);
        request.setKey(key);
        request.setValue(value);
        return request;
    }

    <V> Future<V> doAsync(final ClusterOperation operation, final Object key, final Object value) {
        final int threadId = this.getCurrentThreadId();
        AsyncClientCall call = new AsyncClientCall<V>(){

            @Override
            protected void call() {
                Packet request = ProxyHelper.this.prepareRequest(operation, key, value);
                request.setThreadId(threadId);
                Packet response = ProxyHelper.this.callAndGetResult(request);
                this.setResult(ProxyHelper.this.getValue(response));
            }
        };
        this.client.getDefaultParallelExecutor().execute(call);
        return call;
    }

    protected Object doOp(ClusterOperation operation, Object key, Object value) {
        Packet request = this.prepareRequest(operation, key, value);
        Packet response = this.callAndGetResult(request);
        return this.getValue(response);
    }

    protected Packet prepareRequest(ClusterOperation operation, Object key, Object value) {
        byte[] k = null;
        byte[] v = null;
        if (key != null) {
            k = Serializer.toByte(key);
        }
        if (value != null) {
            v = Serializer.toByte(value);
        }
        return this.createRequestPacket(operation, k, v);
    }

    protected Object getValue(Packet response) {
        if (response.getValue() != null) {
            return Serializer.toObject(response.getValue());
        }
        return null;
    }

    public void destroy() {
        this.doOp(ClusterOperation.DESTROY, null, null);
        this.client.destroy(this.name);
    }

    public <K> Collection<K> keys(Predicate predicate) {
        return ((CollectionWrapper)this.doOp(ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS, null, predicate)).getKeys();
    }

    static void check(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Object cannot be null.");
        }
        if (!(obj instanceof Serializable)) {
            throw new IllegalArgumentException(obj.getClass().getName() + " is not Serializable.");
        }
    }

    static void check(EventListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener can not be null");
        }
    }

    static void checkTime(long time, TimeUnit timeunit) {
        if (time < 0L) {
            throw new IllegalArgumentException("Time can not be less than 0.");
        }
        if (timeunit == null) {
            throw new NullPointerException("TimeUnit can not be null.");
        }
    }

    public HazelcastClient getHazelcastClient() {
        return this.client;
    }
}

