/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.ClusterClientProxy;
import com.hazelcast.client.ConnectionManager;
import com.hazelcast.client.DefaultClientBinder;
import com.hazelcast.client.ExecutorServiceClientProxy;
import com.hazelcast.client.IdGeneratorClientProxy;
import com.hazelcast.client.InRunnable;
import com.hazelcast.client.ListClientProxy;
import com.hazelcast.client.LockClientProxy;
import com.hazelcast.client.MapClientProxy;
import com.hazelcast.client.MultiMapClientProxy;
import com.hazelcast.client.OutRunnable;
import com.hazelcast.client.PacketReader;
import com.hazelcast.client.PacketWriter;
import com.hazelcast.client.PartitionClientProxy;
import com.hazelcast.client.QueueClientProxy;
import com.hazelcast.client.SetClientProxy;
import com.hazelcast.client.ThreadContext;
import com.hazelcast.client.TopicClientProxy;
import com.hazelcast.client.TransactionClientProxy;
import com.hazelcast.client.impl.ListenerManager;
import com.hazelcast.config.Config;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.Instance;
import com.hazelcast.core.InstanceListener;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.Transaction;
import com.hazelcast.impl.executor.ParallelExecutor;
import com.hazelcast.impl.executor.ParallelExecutorService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.partition.PartitionService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HazelcastClient
implements HazelcastInstance {
    final Map<Long, Call> calls = new ConcurrentHashMap<Long, Call>();
    private final ListenerManager listenerManager;
    private final OutRunnable out;
    final InRunnable in;
    final ConnectionManager connectionManager;
    final Map<Object, Object> mapProxies = new ConcurrentHashMap<Object, Object>(100);
    final ConcurrentMap<String, ExecutorServiceClientProxy> mapExecutors = new ConcurrentHashMap<String, ExecutorServiceClientProxy>(2);
    final IMap mapLockProxy;
    final ClusterClientProxy clusterClientProxy;
    final PartitionClientProxy partitionClientProxy;
    final String groupName;
    final ExecutorService executor;
    final ParallelExecutorService parallelExecutorService;
    final ParallelExecutor parallelExecutorDefault;
    static final ILogger logger = Logger.getLogger(HazelcastClient.class.getName());
    private volatile boolean shutdownInProgress = false;

    private HazelcastClient(String groupName, String groupPassword, boolean shuffle, InetSocketAddress[] clusterMembers, boolean automatic) {
        this.groupName = groupName;
        ThreadFactory threadFactory = new ThreadFactory(){
            final AtomicInteger atomicInteger = new AtomicInteger();

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "hz.client." + HazelcastClient.this.groupName + "_cached_thread_" + this.atomicInteger.incrementAndGet());
                if (t.isDaemon()) {
                    t.setDaemon(false);
                }
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                return t;
            }
        };
        this.executor = Executors.newCachedThreadPool(threadFactory);
        this.parallelExecutorService = new ParallelExecutorService(this.executor);
        this.parallelExecutorDefault = this.parallelExecutorService.newParallelExecutor(10);
        this.connectionManager = automatic ? new ConnectionManager(this, clusterMembers[0]) : new ConnectionManager(this, clusterMembers, shuffle);
        this.connectionManager.setBinder(new DefaultClientBinder(this));
        this.out = new OutRunnable(this, this.calls, new PacketWriter());
        new Thread((Runnable)this.out, "hz.client.OutThread").start();
        this.in = new InRunnable(this, this.calls, new PacketReader());
        new Thread((Runnable)this.in, "hz.client.InThread").start();
        this.listenerManager = new ListenerManager(this);
        new Thread((Runnable)this.listenerManager, "hz.client.Listener").start();
        this.mapLockProxy = this.getMap("__hz_Locks");
        this.clusterClientProxy = new ClusterClientProxy(this);
        this.partitionClientProxy = new PartitionClientProxy(this);
        Boolean authenticate = this.clusterClientProxy.authenticate(groupName, groupPassword);
        if (!authenticate.booleanValue()) {
            this.shutdown();
            throw new RuntimeException("Wrong group name and password.");
        }
        try {
            this.connectionManager.getConnection();
        }
        catch (IOException ignored) {
            // empty catch block
        }
        if (automatic) {
            this.getCluster().addMembershipListener(this.connectionManager);
            this.connectionManager.updateMembers();
        }
    }

    public ParallelExecutor getDefaultParallelExecutor() {
        return this.parallelExecutorDefault;
    }

    public OutRunnable getOutRunnable() {
        return this.out;
    }

    ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    private HazelcastClient(String groupName, String groupPassword, InetSocketAddress address) {
        this(groupName, groupPassword, false, new InetSocketAddress[]{address}, true);
    }

    public static HazelcastClient newHazelcastClient(String groupName, String groupPassword, String ... addresses) {
        return HazelcastClient.newHazelcastClient(groupName, groupPassword, true, addresses);
    }

    public static HazelcastClient newHazelcastClient(String groupName, String groupPassword, boolean shuffle, String ... addresses) {
        InetSocketAddress[] socketAddressArr = new InetSocketAddress[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            InetSocketAddress inetSocketAddress;
            socketAddressArr[i] = inetSocketAddress = HazelcastClient.parse(addresses[i]);
        }
        return HazelcastClient.newHazelcastClient(groupName, groupPassword, shuffle, socketAddressArr);
    }

    private static InetSocketAddress parse(String address) {
        String[] seperated = address.split(":");
        int port = seperated.length > 1 ? Integer.valueOf(seperated[1]) : 5701;
        InetSocketAddress inetSocketAddress = new InetSocketAddress(seperated[0], port);
        return inetSocketAddress;
    }

    public static HazelcastClient newHazelcastClient(String groupName, String groupPassword, boolean shuffle, InetSocketAddress ... addresses) {
        return new HazelcastClient(groupName, groupPassword, shuffle, addresses, false);
    }

    public static HazelcastClient newHazelcastClient(String groupName, String groupPassword, String address) {
        InetSocketAddress inetSocketAddress = HazelcastClient.parse(address);
        return new HazelcastClient(groupName, groupPassword, inetSocketAddress);
    }

    @Override
    public Config getConfig() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PartitionService getPartitionService() {
        return this.partitionClientProxy;
    }

    @Override
    public LoggingService getLoggingService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <K, V> IMap<K, V> getMap(String name) {
        return (IMap)this.getClientProxy("c:" + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V, E> Object getClientProxy(Object o) {
        Instance proxy = this.mapProxies.get(o);
        if (proxy == null) {
            Map<Object, Object> map = this.mapProxies;
            synchronized (map) {
                proxy = this.mapProxies.get(o);
                if (proxy == null) {
                    if (o instanceof String) {
                        String name = (String)o;
                        proxy = name.startsWith("c:") ? new MapClientProxy(this, name) : (name.startsWith("m:l:") ? new ListClientProxy(this, name) : (name.startsWith("m:s:") ? new SetClientProxy(this, name) : (name.startsWith("q:") ? new QueueClientProxy(this, name) : (name.startsWith("t:") ? new TopicClientProxy(this, name) : (name.startsWith("i:") ? new IdGeneratorClientProxy(this, name) : (name.startsWith("m:u:") ? new MultiMapClientProxy(this, name) : new LockClientProxy(o, this)))))));
                        this.mapProxies.put(o, proxy);
                    } else {
                        proxy = new LockClientProxy(o, this);
                    }
                }
            }
        }
        return this.mapProxies.get(o);
    }

    @Override
    public Transaction getTransaction() {
        ThreadContext trc = ThreadContext.get();
        TransactionClientProxy proxy = (TransactionClientProxy)trc.getTransaction(this);
        return proxy;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public void shutdown() {
        if (!this.shutdownInProgress) {
            this.shutdownInProgress = true;
            long begin = System.currentTimeMillis();
            this.out.shutdown();
            this.listenerManager.shutdown();
            this.in.shutdown();
            long time = System.currentTimeMillis() - begin;
            logger.log(Level.FINE, "HazelcastClient shutdown completed in " + time + " ms.");
            this.shutdownInProgress = false;
            this.executor.shutdownNow();
            try {
                this.executor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        }
    }

    @Override
    public void addInstanceListener(InstanceListener instanceListener) {
        this.clusterClientProxy.addInstanceListener(instanceListener);
    }

    @Override
    public Cluster getCluster() {
        return this.clusterClientProxy;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.getExecutorService("default");
    }

    @Override
    public ExecutorService getExecutorService(String name) {
        ExecutorServiceClientProxy old;
        if (name == null) {
            throw new IllegalArgumentException("ExecutorService name cannot be null");
        }
        name = "x:" + name;
        ExecutorServiceClientProxy executorServiceProxy = (ExecutorServiceClientProxy)this.mapExecutors.get(name);
        if (executorServiceProxy == null && (old = this.mapExecutors.putIfAbsent(name, executorServiceProxy = new ExecutorServiceClientProxy(this, name))) != null) {
            executorServiceProxy = old;
        }
        return executorServiceProxy;
    }

    @Override
    public IdGenerator getIdGenerator(String name) {
        return (IdGenerator)this.getClientProxy("i:" + name);
    }

    @Override
    public Collection<Instance> getInstances() {
        return this.clusterClientProxy.getInstances();
    }

    @Override
    public <E> IList<E> getList(String name) {
        return (IList)this.getClientProxy("m:l:" + name);
    }

    @Override
    public ILock getLock(Object obj) {
        return new LockClientProxy(obj, this);
    }

    @Override
    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        return (MultiMap)this.getClientProxy("m:u:" + name);
    }

    @Override
    public String getName() {
        return this.groupName;
    }

    @Override
    public <E> IQueue<E> getQueue(String name) {
        return (IQueue)this.getClientProxy("q:" + name);
    }

    @Override
    public <E> ISet<E> getSet(String name) {
        return (ISet)this.getClientProxy("m:s:" + name);
    }

    @Override
    public <E> ITopic<E> getTopic(String name) {
        return (ITopic)this.getClientProxy("t:" + name);
    }

    @Override
    public void removeInstanceListener(InstanceListener instanceListener) {
        this.clusterClientProxy.removeInstanceListener(instanceListener);
    }

    @Override
    public void restart() {
        throw new UnsupportedOperationException();
    }

    protected void destroy(String proxyName) {
        this.mapProxies.remove(proxyName);
    }
}

