/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query;

import com.hazelcast.core.MapEntry;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.SerializationHelper;
import com.hazelcast.query.Expression;
import com.hazelcast.query.Index;
import com.hazelcast.query.IndexAwarePredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.QueryContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Predicates {
    public static Predicate instanceOf(final Class klass) {
        return new Predicate(){

            public boolean apply(MapEntry mapEntry) {
                Object value = mapEntry.getValue();
                if (value == null) {
                    return false;
                }
                return klass.isAssignableFrom(value.getClass());
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                sb.append(" instanceOf (");
                sb.append(klass.getName());
                sb.append(")");
                return sb.toString();
            }
        };
    }

    public static Predicate and(Predicate x, Predicate y) {
        return new AndOrPredicate(true, x, y);
    }

    public static Predicate not(Predicate predicate) {
        return new NotPredicate(predicate);
    }

    public static Predicate or(Predicate x, Predicate y) {
        return new AndOrPredicate(false, x, y);
    }

    public static Predicate notEqual(Expression x, Object y) {
        return new NotEqualPredicate(x, y);
    }

    public static Predicate equal(Expression x, Object y) {
        return new EqualPredicate(x, y);
    }

    public static Predicate like(Expression<String> x, String pattern) {
        return new LikePredicate(x, pattern);
    }

    public static <T extends Comparable<T>> Predicate greaterThan(Expression<? extends T> x, T y) {
        return new GreaterLessPredicate(x, y, false, false);
    }

    public static <T extends Comparable<T>> Predicate greaterEqual(Expression<? extends T> x, T y) {
        return new GreaterLessPredicate(x, y, true, false);
    }

    public static <T extends Comparable<T>> Predicate lessThan(Expression<? extends T> x, T y) {
        return new GreaterLessPredicate(x, y, false, true);
    }

    public static <T extends Comparable<T>> Predicate lessEqual(Expression<? extends T> x, T y) {
        return new GreaterLessPredicate(x, y, true, true);
    }

    public static <T extends Comparable<T>> Predicate between(Expression<? extends T> expression, T from, T to) {
        return new BetweenPredicate(expression, from, to);
    }

    public static <T extends Comparable<T>> Predicate in(Expression<? extends T> expression, T ... values) {
        return new InPredicate(expression, values);
    }

    public static Predicate isNot(final Expression<Boolean> x) {
        return new Predicate(){

            public boolean apply(MapEntry entry) {
                Boolean value = (Boolean)x.getValue(entry);
                return Boolean.FALSE.equals(value);
            }
        };
    }

    public static GetExpression get(String methodName) {
        return new GetExpressionImpl(methodName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetExpressionImpl<T>
    extends AbstractExpression
    implements GetExpression,
    DataSerializable {
        transient Getter getter = null;
        String input;
        List<GetExpressionImpl<T>> ls = null;

        public GetExpressionImpl() {
        }

        public GetExpressionImpl(String input) {
            this.input = input;
        }

        @Override
        public GetExpression get(String methodName) {
            if (this.ls == null) {
                this.ls = new ArrayList<GetExpressionImpl<T>>();
            }
            this.ls.add(new GetExpressionImpl<T>(methodName));
            return this;
        }

        public Object getValue(Object obj) {
            if (this.ls != null) {
                Object result = this.doGetValue(obj);
                for (GetExpressionImpl<T> e : this.ls) {
                    result = super.doGetValue(result);
                }
                return result;
            }
            return this.doGetValue(obj);
        }

        private Object doGetValue(Object obj) {
            if (obj instanceof MapEntry) {
                obj = ((MapEntry)obj).getValue();
            }
            if (obj == null) {
                return null;
            }
            try {
                if (this.getter == null) {
                    ArrayList<String> possibleMethodNames = new ArrayList<String>(3);
                    possibleMethodNames.add(this.input);
                    possibleMethodNames.add("get" + this.input.substring(0, 1).toUpperCase() + this.input.substring(1));
                    possibleMethodNames.add("is" + this.input.substring(0, 1).toUpperCase() + this.input.substring(1));
                    for (String methodName : possibleMethodNames) {
                        try {
                            this.getter = new MethodGetter(obj.getClass().getMethod(methodName, null));
                            break;
                        }
                        catch (NoSuchMethodException ignored) {
                        }
                    }
                    if (this.getter == null) {
                        try {
                            this.getter = new FieldGetter(obj.getClass().getField(this.input));
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            // empty catch block
                        }
                    }
                    if (this.getter == null) {
                        throw new RuntimeException("There is no method of field matching " + this.input);
                    }
                }
                return this.getter.getValue(obj);
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            out.writeUTF(this.input);
        }

        @Override
        public void readData(DataInput in) throws IOException {
            this.input = in.readUTF();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GetExpressionImpl that = (GetExpressionImpl)o;
            return this.input.equals(that.input);
        }

        public int hashCode() {
            return this.input.hashCode();
        }

        public String toString() {
            return this.input;
        }

        class FieldGetter
        extends Getter {
            final Field field;

            FieldGetter(Field field) {
                this.field = field;
            }

            Object getValue(Object obj) throws Exception {
                return this.field.get(obj);
            }

            Class getReturnType() {
                return this.field.getType();
            }
        }

        class MethodGetter
        extends Getter {
            final Method method;

            MethodGetter(Method method) {
                this.method = method;
            }

            Object getValue(Object obj) throws Exception {
                return this.method.invoke(obj, new Object[0]);
            }

            Class getReturnType() {
                return this.method.getReturnType();
            }
        }

        abstract class Getter {
            Getter() {
            }

            abstract Object getValue(Object var1) throws Exception;

            abstract Class getReturnType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface GetExpression<T>
    extends Expression {
        public GetExpression get(String var1);
    }

    public static abstract class AbstractExpression
    extends SerializationHelper
    implements Expression {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AndOrPredicate
    extends AbstractPredicate
    implements IndexAwarePredicate {
        Predicate[] predicates;
        boolean and = false;

        public AndOrPredicate() {
        }

        public AndOrPredicate(boolean and, Predicate first, Predicate second) {
            this.and = and;
            this.predicates = new Predicate[]{first, second};
        }

        public AndOrPredicate(boolean and, Predicate ... predicates) {
            this.and = and;
            this.predicates = predicates;
        }

        @Override
        public boolean apply(MapEntry mapEntry) {
            for (Predicate predicate : this.predicates) {
                boolean result = predicate.apply(mapEntry);
                if (this.and && !result) {
                    return false;
                }
                if (this.and || !result) continue;
                return true;
            }
            return this.and;
        }

        @Override
        public boolean collectIndexAwarePredicates(List<IndexAwarePredicate> lsIndexPredicates, Map<Expression, Index> mapIndexes) {
            boolean strong = this.and;
            if (this.and) {
                for (Predicate predicate : this.predicates) {
                    if (predicate instanceof IndexAwarePredicate) {
                        IndexAwarePredicate p = (IndexAwarePredicate)predicate;
                        if (p.collectIndexAwarePredicates(lsIndexPredicates, mapIndexes)) continue;
                        strong = false;
                        continue;
                    }
                    strong = false;
                }
            }
            return strong;
        }

        @Override
        public Set<MapEntry> filter(QueryContext queryContext) {
            return null;
        }

        @Override
        public void collectAppliedIndexes(Set<Index> setAppliedIndexes, Map<Expression, Index> mapIndexes) {
            if (this.and) {
                for (Predicate predicate : this.predicates) {
                    if (!(predicate instanceof IndexAwarePredicate)) continue;
                    IndexAwarePredicate p = (IndexAwarePredicate)predicate;
                    p.collectAppliedIndexes(setAppliedIndexes, mapIndexes);
                }
            }
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            out.writeBoolean(this.and);
            out.writeInt(this.predicates.length);
            for (Predicate predicate : this.predicates) {
                AndOrPredicate.writeObject(out, predicate);
            }
        }

        @Override
        public void readData(DataInput in) throws IOException {
            this.and = in.readBoolean();
            int len = in.readInt();
            this.predicates = new Predicate[len];
            for (int i = 0; i < len; ++i) {
                this.predicates[i] = (Predicate)AndOrPredicate.readObject(in);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("(");
            String andOr = this.and ? " AND " : " OR ";
            int size = this.predicates.length;
            for (int i = 0; i < size; ++i) {
                sb.append(this.predicates[i]);
                if (i >= size - 1) continue;
                sb.append(andOr);
            }
            sb.append(")");
            return sb.toString();
        }
    }

    public static abstract class AbstractPredicate
    extends SerializationHelper
    implements Predicate,
    DataSerializable {
        public static Object getRealObject(Object type, String value) {
            Constable result = null;
            if (type instanceof Boolean) {
                result = Boolean.valueOf("true".equalsIgnoreCase(value));
            } else if (type instanceof Integer) {
                result = Integer.valueOf(value);
            } else if (type instanceof Double) {
                result = Double.valueOf(value);
            } else if (type instanceof Float) {
                result = Float.valueOf(value);
            } else if (type instanceof Byte) {
                result = Byte.valueOf(value);
            } else if (type instanceof Long) {
                result = Long.valueOf(value);
            } else {
                throw new RuntimeException("Unknown type " + type.getClass() + " value=" + value);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EqualPredicate
    extends AbstractPredicate
    implements IndexAwarePredicate {
        Expression first;
        Object second;
        Object convertedSecondValue = null;
        protected boolean secondIsExpression = false;

        public EqualPredicate() {
        }

        public EqualPredicate(Expression first, Expression second) {
            this.first = first;
            this.second = second;
            this.secondIsExpression = true;
        }

        public EqualPredicate(Expression first, Object second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public boolean apply(MapEntry entry) {
            if (this.secondIsExpression) {
                return this.doApply(this.first.getValue(entry), ((Expression)this.second).getValue(entry));
            }
            Object firstVal = this.first.getValue(entry);
            if (firstVal == null) {
                return this.second == null;
            }
            if (this.second == null) {
                return false;
            }
            if (this.convertedSecondValue == null) {
                this.convertedSecondValue = EqualPredicate.getConvertedRealValue(firstVal, this.second);
            }
            return this.doApply(firstVal, this.convertedSecondValue);
        }

        protected static Object getConvertedRealValue(Object firstValue, Object value) {
            if (firstValue == null) {
                return value;
            }
            if (firstValue.getClass() == value.getClass()) {
                return value;
            }
            if (value instanceof String) {
                String str = (String)value;
                return EqualPredicate.getRealObject(firstValue, str);
            }
            throw new RuntimeException("Cannot get real object " + value);
        }

        protected boolean doApply(Object first, Object second) {
            return first.equals(second);
        }

        @Override
        public boolean collectIndexAwarePredicates(List<IndexAwarePredicate> lsIndexPredicates, Map<Expression, Index> mapIndexes) {
            if (!this.secondIsExpression && this.first instanceof GetExpression) {
                Index index = mapIndexes.get(this.first);
                if (index != null) {
                    lsIndexPredicates.add(this);
                } else {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void collectAppliedIndexes(Set<Index> setAppliedIndexes, Map<Expression, Index> mapIndexes) {
            Index index = mapIndexes.get(this.first);
            if (index != null) {
                setAppliedIndexes.add(index);
            }
        }

        @Override
        public Set<MapEntry> filter(QueryContext queryContext) {
            Index index = queryContext.getMapIndexes().get(this.first);
            if (index != null) {
                return index.getRecords(index.getLongValue(this.second));
            }
            return null;
        }

        public Object getValue() {
            return this.second;
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            EqualPredicate.writeObject(out, this.first);
            out.writeBoolean(this.secondIsExpression);
            EqualPredicate.writeObject(out, this.second);
        }

        @Override
        public void readData(DataInput in) throws IOException {
            try {
                this.first = (Expression)EqualPredicate.readObject(in);
                this.secondIsExpression = in.readBoolean();
                this.second = EqualPredicate.readObject(in);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.first);
            sb.append("=");
            sb.append(this.second);
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LikePredicate
    extends AbstractPredicate {
        Expression<String> first;
        String second;
        Pattern pattern = null;

        public LikePredicate() {
        }

        public LikePredicate(Expression<String> first, String second) {
            this.first = first;
            this.second = second;
            second = second.replaceAll("%", ".*").replaceAll("_", ".");
            this.pattern = Pattern.compile(second);
        }

        @Override
        public boolean apply(MapEntry entry) {
            String firstVal = this.first.getValue(entry);
            if (firstVal == null) {
                return this.second == null;
            }
            if (this.second == null) {
                return false;
            }
            Matcher m = this.pattern.matcher(firstVal);
            return m.matches();
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            LikePredicate.writeObject(out, this.first);
            out.writeUTF(this.second);
        }

        @Override
        public void readData(DataInput in) throws IOException {
            try {
                this.first = (Expression)LikePredicate.readObject(in);
                this.second = in.readUTF();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.first);
            sb.append(" LIKE '");
            sb.append(this.second);
            sb.append("'");
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InPredicate
    extends AbstractPredicate
    implements IndexAwarePredicate {
        Expression first;
        Object[] values = null;
        Object[] convertedValues = null;

        public InPredicate() {
        }

        public InPredicate(Expression first, Object ... second) {
            this.first = first;
            this.values = second;
        }

        @Override
        public boolean apply(MapEntry entry) {
            Object firstVal = this.first.getValue(entry);
            if (firstVal == null) {
                return false;
            }
            if (this.convertedValues != null) {
                return this.in(firstVal, this.convertedValues);
            }
            if (firstVal.getClass() == this.values[0].getClass()) {
                return this.in(firstVal, this.values);
            }
            if (this.values[0] instanceof String) {
                this.convertedValues = new Object[this.values.length];
                for (int i = 0; i < this.values.length; ++i) {
                    this.convertedValues[i] = InPredicate.getRealObject(firstVal.getClass(), (String)this.values[i]);
                }
                return this.in(firstVal, this.convertedValues);
            }
            return this.in(firstVal, this.values);
        }

        private boolean in(Object firstVal, Object[] values) {
            for (Object o : values) {
                if (!firstVal.equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean collectIndexAwarePredicates(List<IndexAwarePredicate> lsIndexPredicates, Map<Expression, Index> mapIndexes) {
            if (this.first instanceof GetExpression) {
                Index index = mapIndexes.get(this.first);
                if (index != null) {
                    lsIndexPredicates.add(this);
                } else {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void collectAppliedIndexes(Set<Index> setAppliedIndexes, Map<Expression, Index> mapIndexes) {
            Index index = mapIndexes.get(this.first);
            if (index != null) {
                setAppliedIndexes.add(index);
            }
        }

        @Override
        public Set<MapEntry> filter(QueryContext queryContext) {
            Index index = queryContext.getMapIndexes().get(this.first);
            if (index != null) {
                long[] longValues = new long[this.values.length];
                for (int i = 0; i < this.values.length; ++i) {
                    longValues[i] = index.getLongValue(this.values[i]);
                }
                return index.getRecords(longValues);
            }
            return null;
        }

        public Object getValue() {
            return this.values;
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            InPredicate.writeObject(out, this.first);
            out.writeInt(this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                InPredicate.writeObject(out, this.values[i]);
            }
        }

        @Override
        public void readData(DataInput in) throws IOException {
            try {
                this.first = (Expression)InPredicate.readObject(in);
                int len = in.readInt();
                this.values = new Object[len];
                for (int i = 0; i < this.values.length; ++i) {
                    this.values[i] = InPredicate.readObject(in);
                }
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.first);
            sb.append(" IN (");
            for (int i = 0; i < this.values.length; ++i) {
                sb.append(this.values[i]);
                if (i >= this.values.length - 1) continue;
                sb.append(",");
            }
            sb.append(")");
            return sb.toString();
        }
    }

    public static class NotPredicate
    extends AbstractPredicate {
        Predicate predicate;

        public NotPredicate(Predicate predicate) {
            this.predicate = predicate;
        }

        public NotPredicate() {
        }

        public boolean apply(MapEntry mapEntry) {
            return !this.predicate.apply(mapEntry);
        }

        public void writeData(DataOutput out) throws IOException {
            NotPredicate.writeObject(out, this.predicate);
        }

        public void readData(DataInput in) throws IOException {
            this.predicate = (Predicate)NotPredicate.readObject(in);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("NOT(");
            sb.append(this.predicate.toString());
            sb.append(")");
            return sb.toString();
        }
    }

    public static class NotEqualPredicate
    extends EqualPredicate {
        public NotEqualPredicate() {
        }

        public NotEqualPredicate(Expression first, Expression second) {
            super(first, second);
        }

        public NotEqualPredicate(Expression first, Object second) {
            super(first, second);
        }

        public boolean apply(MapEntry entry) {
            return !super.apply(entry);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.first);
            sb.append("!=");
            sb.append(this.second);
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BetweenPredicate
    extends EqualPredicate {
        Object to;
        Comparable fromConvertedValue = null;
        Comparable toConvertedValue = null;

        public BetweenPredicate() {
        }

        public BetweenPredicate(Expression first, Expression from, Object to) {
            super(first, from);
            this.to = to;
        }

        public BetweenPredicate(Expression first, Object from, Object to) {
            super(first, from);
            this.to = to;
        }

        @Override
        public boolean apply(MapEntry entry) {
            Expression cFirst = this.first;
            Comparable firstValue = (Comparable)cFirst.getValue(entry);
            if (firstValue == null) {
                return false;
            }
            if (this.fromConvertedValue == null) {
                this.fromConvertedValue = (Comparable)BetweenPredicate.getConvertedRealValue(firstValue, this.second);
                this.toConvertedValue = (Comparable)BetweenPredicate.getConvertedRealValue(firstValue, this.to);
            }
            if (firstValue == null || this.fromConvertedValue == null || this.toConvertedValue == null) {
                return false;
            }
            return firstValue.compareTo(this.fromConvertedValue) >= 0 && firstValue.compareTo(this.toConvertedValue) <= 0;
        }

        @Override
        public Set<MapEntry> filter(QueryContext queryContext) {
            Index index = queryContext.getMapIndexes().get(this.first);
            return index.getSubRecordsBetween(index.getLongValue(this.second), index.getLongValue(this.to));
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            super.writeData(out);
            BetweenPredicate.writeObject(out, this.to);
        }

        @Override
        public void readData(DataInput in) throws IOException {
            super.readData(in);
            this.to = BetweenPredicate.readObject(in);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.first);
            sb.append(" BETWEEN ");
            sb.append(this.second);
            sb.append(" AND ");
            sb.append(this.to);
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GreaterLessPredicate
    extends EqualPredicate {
        boolean equal = false;
        boolean less = false;

        public GreaterLessPredicate() {
        }

        public GreaterLessPredicate(Expression first, Expression second, boolean equal, boolean less) {
            super(first, second);
            this.equal = equal;
            this.less = less;
        }

        public GreaterLessPredicate(Expression first, Object second, boolean equal, boolean less) {
            super(first, second);
            this.equal = equal;
            this.less = less;
        }

        @Override
        protected boolean doApply(Object first, Object second) {
            int expectedResult = this.less ? -1 : 1;
            int result = ((Comparable)first).compareTo(second);
            if (this.equal && result == 0) {
                return true;
            }
            return expectedResult == result;
        }

        @Override
        public Set<MapEntry> filter(QueryContext queryContext) {
            Index index = queryContext.getMapIndexes().get(this.first);
            return index.getSubRecords(this.equal, this.less, index.getLongValue(this.second));
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.first);
            sb.append(this.less ? "<" : ">");
            sb.append(this.equal ? "=" : "");
            sb.append(this.second);
            return sb.toString();
        }
    }
}

